/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.bucket;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketCreateResponse;
import org.apache.hadoop.ozone.om.response.s3.bucket.S3BucketCreateResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BucketCreateRequest
extends OMVolumeRequest {
    private static final String S3_ADMIN_NAME = "OzoneS3Manager";
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerProtocolProtos.S3CreateBucketRequest.class);

    public S3BucketCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.S3CreateBucketRequest s3CreateBucketRequest = this.getOmRequest().getCreateS3BucketRequest();
        Preconditions.checkNotNull((Object)s3CreateBucketRequest);
        OzoneManagerProtocolProtos.S3CreateBucketRequest.Builder newS3CreateBucketRequest = s3CreateBucketRequest.toBuilder().setS3CreateVolumeInfo(OzoneManagerProtocolProtos.S3CreateVolumeInfo.newBuilder().setCreationTime(Time.now()));
        int bucketLength = s3CreateBucketRequest.getS3Bucketname().length();
        if (bucketLength < 3 || bucketLength >= 64) {
            throw new OMException("S3BucketName must be at least 3 and not more than 63 characters long", OMException.ResultCodes.S3_BUCKET_INVALID_LENGTH);
        }
        return this.getOmRequest().toBuilder().setCreateS3BucketRequest(newS3CreateBucketRequest).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        s3CreateBucketRequest = this.getOmRequest().getCreateS3BucketRequest();
        userName = s3CreateBucketRequest.getUserName();
        s3BucketName = s3CreateBucketRequest.getS3Bucketname();
        omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CreateS3Bucket).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumS3BucketCreates();
        omMetadataManager = ozoneManager.getMetadataManager();
        exception = null;
        volumeList = null;
        omVolumeArgs = null;
        omBucketInfo = null;
        volumeCreated = false;
        acquiredVolumeLock = false;
        acquiredUserLock = false;
        acquiredS3Lock = false;
        volumeName = S3BucketCreateRequest.formatOzoneVolumeName(userName);
        try {
            block17: {
                if (ozoneManager.getAclsEnabled()) {
                    this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.S3, IAccessAuthorizer.ACLType.CREATE, null, s3BucketName, null);
                }
                acquiredS3Lock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
                if (omMetadataManager.getS3Table().isExist((Object)s3BucketName)) {
                    throw new OMException("S3Bucket " + s3BucketName + " already exists", OMException.ResultCodes.S3_BUCKET_ALREADY_EXISTS);
                }
                try {
                    acquiredVolumeLock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
                    acquiredUserLock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
                    volumeKey = omMetadataManager.getVolumeKey(volumeName);
                    if (!omMetadataManager.getVolumeTable().isExist((Object)volumeKey)) {
                        omVolumeArgs = this.createOmVolumeArgs(volumeName, userName, s3CreateBucketRequest.getS3CreateVolumeInfo().getCreationTime());
                        volumeList = (OzoneManagerProtocolProtos.VolumeList)omMetadataManager.getUserTable().get((Object)omMetadataManager.getUserKey(userName));
                        volumeList = this.addVolumeToOwnerList(volumeList, volumeName, userName, ozoneManager.getMaxUserVolumeCount());
                        this.createVolume(omMetadataManager, omVolumeArgs, volumeList, volumeKey, omMetadataManager.getUserKey(userName), transactionLogIndex);
                        volumeCreated = true;
                    }
                    if (!acquiredUserLock) break block17;
                }
                catch (Throwable var20_20) {
                    if (acquiredUserLock) {
                        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
                    }
                    if (acquiredVolumeLock) {
                        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
                    }
                    throw var20_20;
                }
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
            }
            if (acquiredVolumeLock) {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
            }
            omBucketInfo = this.createBucket(omMetadataManager, volumeName, s3BucketName, s3CreateBucketRequest.getS3CreateVolumeInfo().getCreationTime(), transactionLogIndex);
            omMetadataManager.getS3Table().addCacheEntry(new CacheKey((Object)s3BucketName), new CacheValue(Optional.of((Object)S3BucketCreateRequest.formatS3MappingName(volumeName, s3BucketName)), transactionLogIndex));
            ** if (!acquiredS3Lock) goto lbl-1000
        }
        catch (IOException ex) {
            try {
                exception = ex;
                ** if (!acquiredS3Lock) goto lbl-1000
            }
            catch (Throwable var21_22) {
                if (acquiredS3Lock) {
                    omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
                }
                throw var21_22;
            }
lbl-1000:
            // 1 sources

            {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
        }
lbl-1000:
        // 2 sources

        {
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.CREATE_S3_BUCKET, this.buildAuditMap(userName, s3BucketName), exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            S3BucketCreateRequest.LOG.debug("S3Bucket is successfully created for userName: {}, s3BucketName {}, volumeName {}", new Object[]{userName, s3BucketName, volumeName});
            omVolumeCreateResponse = null;
            if (volumeCreated) {
                omMetrics.incNumVolumes();
                omVolumeCreateResponse = new OMVolumeCreateResponse(omVolumeArgs, volumeList, omResponse.build());
            }
            omMetrics.incNumBuckets();
            omBucketCreateResponse = new OMBucketCreateResponse(omBucketInfo, omResponse.build());
            omMetrics.incNumS3Buckets();
            return new S3BucketCreateResponse(omVolumeCreateResponse, omBucketCreateResponse, s3BucketName, S3BucketCreateRequest.formatS3MappingName(volumeName, s3BucketName), omResponse.setCreateS3BucketResponse(OzoneManagerProtocolProtos.S3CreateBucketResponse.newBuilder()).build());
        }
        S3BucketCreateRequest.LOG.error("S3Bucket Creation Failed for userName: {}, s3BucketName {}, VolumeName {}", new Object[]{userName, s3BucketName, volumeName});
        omMetrics.incNumS3BucketCreateFails();
        return new S3BucketCreateResponse(null, null, null, null, this.createErrorOMResponse(omResponse, exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OmBucketInfo createBucket(OMMetadataManager omMetadataManager, String volumeName, String s3BucketName, long creationTime, long transactionLogIndex) throws IOException {
        boolean acquireBucketLock = false;
        OmBucketInfo omBucketInfo = null;
        try {
            acquireBucketLock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, s3BucketName});
            String bucketKey = omMetadataManager.getBucketKey(volumeName, s3BucketName);
            if (omMetadataManager.getBucketTable().isExist((Object)bucketKey)) {
                throw new OMException("Bucket " + s3BucketName + " already exists", OMException.ResultCodes.BUCKET_ALREADY_EXISTS);
            }
            omBucketInfo = this.createOmBucketInfo(volumeName, s3BucketName, creationTime);
            omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), new CacheValue(Optional.of((Object)omBucketInfo), transactionLogIndex));
            if (!acquireBucketLock) return omBucketInfo;
        }
        catch (Throwable throwable) {
            if (!acquireBucketLock) throw throwable;
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, s3BucketName});
            throw throwable;
        }
        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, s3BucketName});
        return omBucketInfo;
    }

    @VisibleForTesting
    public static String formatOzoneVolumeName(String userName) {
        return String.format("s3%s", userName);
    }

    @VisibleForTesting
    public static String formatS3MappingName(String volumeName, String bucketName) {
        return String.format("%s/%s", volumeName, bucketName);
    }

    private OmVolumeArgs createOmVolumeArgs(String volumeName, String userName, long creationTime) {
        return OmVolumeArgs.newBuilder().setAdminName(S3_ADMIN_NAME).setVolume(volumeName).setQuotaInBytes(0x1000000000000000L).setOwnerName(userName).setCreationTime(creationTime).build();
    }

    private OmBucketInfo createOmBucketInfo(String volumeName, String s3BucketName, long creationTime) {
        return OmBucketInfo.newBuilder().setVolumeName(volumeName).setBucketName(s3BucketName).setIsVersionEnabled(Boolean.FALSE).setStorageType(StorageType.DEFAULT).setCreationTime(creationTime).build();
    }

    private Map<String, String> buildAuditMap(String userName, String s3BucketName) {
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put(userName, "username");
        auditMap.put(s3BucketName, "s3Bucket");
        return auditMap;
    }
}

