/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3InitiateMultipartUploadResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.UniqueId;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3InitiateMultipartUploadRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(S3InitiateMultipartUploadRequest.class);

    public S3InitiateMultipartUploadRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) {
        OzoneManagerProtocolProtos.MultipartInfoInitiateRequest multipartInfoInitiateRequest = this.getOmRequest().getInitiateMultiPartUploadRequest();
        Preconditions.checkNotNull((Object)multipartInfoInitiateRequest);
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = multipartInfoInitiateRequest.getKeyArgs().toBuilder().setMultipartUploadID(UUID.randomUUID().toString() + "-" + UniqueId.next()).setModificationTime(Time.now());
        return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).setInitiateMultiPartUploadRequest(multipartInfoInitiateRequest.toBuilder().setKeyArgs(newKeyArgs)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        multipartInfoInitiateRequest = this.getOmRequest().getInitiateMultiPartUploadRequest();
        keyArgs = multipartInfoInitiateRequest.getKeyArgs();
        Preconditions.checkNotNull((Object)keyArgs.getMultipartUploadID());
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        keyName = keyArgs.getKeyName();
        omMetadataManager = ozoneManager.getMetadataManager();
        ozoneManager.getMetrics().incNumInitiateMultipartUploads();
        acquiredBucketLock = false;
        exception = null;
        multipartKeyInfo = null;
        omKeyInfo = null;
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, keyName);
            }
            acquiredBucketLock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, keyArgs.getMultipartUploadID());
            multipartKeyInfo = new OmMultipartKeyInfo(keyArgs.getMultipartUploadID(), new HashMap<K, V>());
            omKeyInfo = new OmKeyInfo.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setReplicationType(keyArgs.getType()).setReplicationFactor(keyArgs.getFactor()).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList<E>()))).setAcls(OzoneAclUtil.fromProtobuf((List)keyArgs.getAclsList())).build();
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)omKeyInfo), transactionLogIndex));
            omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)multipartKeyInfo), transactionLogIndex));
            ** if (!acquiredBucketLock) goto lbl-1000
        }
        catch (IOException ex) {
            try {
                exception = ex;
                ** if (!acquiredBucketLock) goto lbl-1000
            }
            catch (Throwable var15_15) {
                if (acquiredBucketLock) {
                    omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var15_15;
            }
lbl-1000:
            // 1 sources

            {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
lbl-1000:
        // 2 sources

        {
        }
        omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.InitiateMultiPartUpload).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, this.buildKeyArgsAuditMap(keyArgs), exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            S3InitiateMultipartUploadRequest.LOG.debug("S3 InitiateMultipart Upload request for Key {} in Volume/Bucket {}/{} is successfully completed", new Object[]{keyName, volumeName, bucketName});
            return new S3InitiateMultipartUploadResponse(multipartKeyInfo, omKeyInfo, omResponse.setInitiateMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartInfoInitiateResponse.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setMultipartUploadID(keyArgs.getMultipartUploadID())).build());
        }
        ozoneManager.getMetrics().incNumInitiateMultipartUploadFails();
        S3InitiateMultipartUploadRequest.LOG.error("S3 InitiateMultipart Upload request for Key {} in Volume/Bucket {}/{} is failed", new Object[]{keyName, volumeName, bucketName, exception});
        return new S3InitiateMultipartUploadResponse(null, null, this.createErrorOMResponse(omResponse, exception));
    }
}

