/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadAbortResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadAbortRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(S3MultipartUploadAbortRequest.class);

    public S3MultipartUploadAbortRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = this.getOmRequest().getAbortMultiPartUploadRequest().getKeyArgs();
        return this.getOmRequest().toBuilder().setAbortMultiPartUploadRequest(this.getOmRequest().getAbortMultiPartUploadRequest().toBuilder().setKeyArgs(keyArgs.toBuilder().setModificationTime(Time.now()))).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        keyArgs = this.getOmRequest().getAbortMultiPartUploadRequest().getKeyArgs();
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        keyName = keyArgs.getKeyName();
        omMetadataManager = ozoneManager.getMetadataManager();
        acquiredLock = false;
        exception = null;
        multipartKeyInfo = null;
        multipartKey = null;
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, keyName);
            }
            acquiredLock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, keyArgs.getMultipartUploadID());
            omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)multipartKey);
            if (omKeyInfo == null) {
                throw new OMException("Abort Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.absent(), transactionLogIndex));
            omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.absent(), transactionLogIndex));
            ** if (!acquiredLock) goto lbl-1000
        }
        catch (IOException ex) {
            try {
                exception = ex;
                ** if (!acquiredLock) goto lbl-1000
            }
            catch (Throwable var14_14) {
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var14_14;
            }
lbl-1000:
            // 1 sources

            {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
lbl-1000:
        // 2 sources

        {
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.ABORT_MULTIPART_UPLOAD, this.buildKeyArgsAuditMap(keyArgs), exception, this.getOmRequest().getUserInfo()));
        omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.AbortMultiPartUpload).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        if (exception == null) {
            S3MultipartUploadAbortRequest.LOG.debug("Abort Multipart request is successfully completed for KeyName {} in VolumeName/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName});
            return new S3MultipartUploadAbortResponse(multipartKey, keyArgs.getModificationTime(), multipartKeyInfo, omResponse.setAbortMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartUploadAbortResponse.newBuilder()).build());
        }
        S3MultipartUploadAbortRequest.LOG.error("Abort Multipart request is failed for KeyName {} in VolumeName/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName, exception});
        return new S3MultipartUploadAbortResponse(multipartKey, keyArgs.getModificationTime(), multipartKeyInfo, this.createErrorOMResponse(omResponse, exception));
    }
}

