/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeSetOwnerResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeSetOwnerRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeSetOwnerRequest.class);

    public OMVolumeSetOwnerRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        IOException exception;
        OmVolumeArgs omVolumeArgs;
        OzoneManagerProtocolProtos.VolumeList newOwnerVolumeList;
        OzoneManagerProtocolProtos.VolumeList oldOwnerVolumeList;
        String oldOwner;
        OMMetadataManager omMetadataManager;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        String newOwner;
        String volume;
        OMMetrics omMetrics;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse;
        block11: {
            OzoneManagerProtocolProtos.SetVolumePropertyRequest setVolumePropertyRequest = this.getOmRequest().getSetVolumePropertyRequest();
            Preconditions.checkNotNull((Object)setVolumePropertyRequest);
            omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetVolumeProperty).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
            if (!setVolumePropertyRequest.hasOwnerName()) {
                omResponse.setStatus(OzoneManagerProtocolProtos.Status.INVALID_REQUEST).setSuccess(false);
                return new OMVolumeSetOwnerResponse(null, null, null, null, omResponse.build());
            }
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumVolumeUpdates();
            volume = setVolumePropertyRequest.getVolumeName();
            newOwner = setVolumePropertyRequest.getOwnerName();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            auditMap = this.buildVolumeAuditMap(volume);
            auditMap.put("owner", newOwner);
            try {
                if (ozoneManager.getAclsEnabled()) {
                    this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, null, null);
                }
            }
            catch (IOException ex) {
                LOG.error("Changing volume ownership failed for user:{} volume:{}", (Object)newOwner, (Object)volume);
                omMetrics.incNumVolumeUpdateFails();
                this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.SET_OWNER, auditMap, ex, userInfo));
                return new OMVolumeSetOwnerResponse(null, null, null, null, this.createErrorOMResponse(omResponse, ex));
            }
            long maxUserVolumeCount = ozoneManager.getMaxUserVolumeCount();
            omMetadataManager = ozoneManager.getMetadataManager();
            String dbVolumeKey = omMetadataManager.getVolumeKey(volume);
            oldOwner = null;
            oldOwnerVolumeList = null;
            newOwnerVolumeList = null;
            omVolumeArgs = null;
            exception = null;
            boolean acquiredUserLocks = false;
            omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            try {
                omVolumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)dbVolumeKey);
                if (omVolumeArgs == null) {
                    LOG.debug("Changing volume ownership failed for user:{} volume:{}", (Object)newOwner, (Object)volume);
                    throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
                }
                oldOwner = omVolumeArgs.getOwnerName();
                acquiredUserLocks = omMetadataManager.getLock().acquireMultiUserLock(newOwner, oldOwner);
                oldOwnerVolumeList = (OzoneManagerProtocolProtos.VolumeList)omMetadataManager.getUserTable().get((Object)oldOwner);
                oldOwnerVolumeList = this.delVolumeFromOwnerList(oldOwnerVolumeList, volume, oldOwner);
                newOwnerVolumeList = (OzoneManagerProtocolProtos.VolumeList)omMetadataManager.getUserTable().get((Object)newOwner);
                newOwnerVolumeList = this.addVolumeToOwnerList(newOwnerVolumeList, volume, newOwner, maxUserVolumeCount);
                omVolumeArgs.setOwnerName(newOwner);
                omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getUserKey(newOwner)), new CacheValue(Optional.of((Object)newOwnerVolumeList), transactionLogIndex));
                omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getUserKey(oldOwner)), new CacheValue(Optional.of((Object)oldOwnerVolumeList), transactionLogIndex));
                omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), new CacheValue(Optional.of((Object)omVolumeArgs), transactionLogIndex));
                if (!acquiredUserLocks) break block11;
            }
            catch (IOException ex) {
                block12: {
                    try {
                        exception = ex;
                        if (!acquiredUserLocks) break block12;
                    }
                    catch (Throwable throwable) {
                        if (acquiredUserLocks) {
                            omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
                        }
                        omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                        throw throwable;
                    }
                    omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
                }
                omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            }
            omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
        }
        omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.SET_OWNER, auditMap, exception, userInfo));
        if (exception == null) {
            LOG.debug("Successfully changed Owner of Volume {} from {} -> {}", new Object[]{volume, oldOwner, newOwner});
            omResponse.setSetVolumePropertyResponse(OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder().build());
            return new OMVolumeSetOwnerResponse(oldOwner, oldOwnerVolumeList, newOwnerVolumeList, omVolumeArgs, omResponse.build());
        }
        LOG.error("Changing volume ownership failed for user:{} volume:{}", new Object[]{newOwner, volume, exception});
        omMetrics.incNumVolumeUpdateFails();
        return new OMVolumeSetOwnerResponse(null, null, null, null, this.createErrorOMResponse(omResponse, exception));
    }
}

