/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.bucket;

import java.io.IOException;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;

public final class OMBucketDeleteResponse
extends OMClientResponse {
    private String volumeName;
    private String bucketName;

    public OMBucketDeleteResponse(String volumeName, String bucketName, OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.volumeName = volumeName;
        this.bucketName = bucketName;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            String dbBucketKey = omMetadataManager.getBucketKey(this.volumeName, this.bucketName);
            omMetadataManager.getBucketTable().deleteWithBatch(batchOperation, (Object)dbBucketKey);
        }
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }
}

