/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.file;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDirectoryCreateResponse
extends OMClientResponse {
    public static final Logger LOG = LoggerFactory.getLogger(OMDirectoryCreateResponse.class);
    private OmKeyInfo dirKeyInfo;

    public OMDirectoryCreateResponse(@Nullable OmKeyInfo dirKeyInfo, OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.dirKeyInfo = dirKeyInfo;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            if (this.dirKeyInfo != null) {
                String dirKey = omMetadataManager.getOzoneKey(this.dirKeyInfo.getVolumeName(), this.dirKeyInfo.getBucketName(), this.dirKeyInfo.getKeyName());
                omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)dirKey, (Object)this.dirKeyInfo);
            } else {
                LOG.debug("Response Status is OK, dirKeyInfo is null in OMDirectoryCreateResponse");
            }
        }
    }
}

