/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;

public class OMKeyDeleteResponse
extends OMClientResponse {
    private OmKeyInfo omKeyInfo;
    private long deleteTimestamp;

    public OMKeyDeleteResponse(OmKeyInfo omKeyInfo, long deletionTime, OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.omKeyInfo = omKeyInfo;
        this.deleteTimestamp = deletionTime;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            String ozoneKey = omMetadataManager.getOzoneKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName());
            omMetadataManager.getKeyTable().deleteWithBatch(batchOperation, (Object)ozoneKey);
            if (!this.isKeyEmpty(this.omKeyInfo)) {
                String deleteKeyName = OmUtils.getDeletedKeyName((String)ozoneKey, (long)this.deleteTimestamp);
                omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)deleteKeyName, (Object)this.omKeyInfo);
            }
        }
    }

    private boolean isKeyEmpty(OmKeyInfo keyInfo) {
        for (OmKeyLocationInfoGroup keyLocationList : keyInfo.getKeyLocationVersions()) {
            if (keyLocationList.getLocationList().size() == 0) continue;
            return false;
        }
        return true;
    }
}

