/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;

public class S3InitiateMultipartUploadResponse
extends OMClientResponse {
    private OmMultipartKeyInfo omMultipartKeyInfo;
    private OmKeyInfo omKeyInfo;

    public S3InitiateMultipartUploadResponse(@Nullable OmMultipartKeyInfo omMultipartKeyInfo, @Nullable OmKeyInfo omKeyInfo, @Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.omMultipartKeyInfo = omMultipartKeyInfo;
        this.omKeyInfo = omKeyInfo;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            String multipartKey = omMetadataManager.getMultipartKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName(), this.omMultipartKeyInfo.getUploadID());
            omMetadataManager.getOpenKeyTable().putWithBatch(batchOperation, (Object)multipartKey, (Object)this.omKeyInfo);
            omMetadataManager.getMultipartInfoTable().putWithBatch(batchOperation, (Object)multipartKey, (Object)this.omMultipartKeyInfo);
        }
    }

    @VisibleForTesting
    public OmMultipartKeyInfo getOmMultipartKeyInfo() {
        return this.omMultipartKeyInfo;
    }

    @VisibleForTesting
    public OmKeyInfo getOmKeyInfo() {
        return this.omKeyInfo;
    }
}

