/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;

public class S3MultipartUploadAbortResponse
extends OMClientResponse {
    private String multipartKey;
    private long timeStamp;
    private OmMultipartKeyInfo omMultipartKeyInfo;

    public S3MultipartUploadAbortResponse(String multipartKey, long timeStamp, OmMultipartKeyInfo omMultipartKeyInfo, OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.multipartKey = multipartKey;
        this.timeStamp = timeStamp;
        this.omMultipartKeyInfo = omMultipartKeyInfo;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            omMetadataManager.getOpenKeyTable().deleteWithBatch(batchOperation, (Object)this.multipartKey);
            omMetadataManager.getMultipartInfoTable().deleteWithBatch(batchOperation, (Object)this.multipartKey);
            TreeMap partKeyInfoMap = this.omMultipartKeyInfo.getPartKeyInfoMap();
            for (Map.Entry partKeyInfoEntry : partKeyInfoMap.entrySet()) {
                OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoEntry.getValue();
                OmKeyInfo currentKeyPartInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
                omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)OmUtils.getDeletedKeyName((String)partKeyInfo.getPartName(), (long)this.timeStamp), (Object)currentKeyPartInfo);
            }
        }
    }
}

