/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import java.io.IOException;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;

public class S3MultipartUploadCommitPartResponse
extends OMClientResponse {
    private String multipartKey;
    private String openKey;
    private long deleteTimeStamp;
    private OmKeyInfo deletePartKeyInfo;
    private OmMultipartKeyInfo omMultipartKeyInfo;
    private OzoneManagerProtocolProtos.PartKeyInfo oldMultipartKeyInfo;

    public S3MultipartUploadCommitPartResponse(String multipartKey, String openKey, long deleteTimeStamp, OmKeyInfo deletePartKeyInfo, OmMultipartKeyInfo omMultipartKeyInfo, OzoneManagerProtocolProtos.PartKeyInfo oldPartKeyInfo, OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.multipartKey = multipartKey;
        this.openKey = openKey;
        this.deleteTimeStamp = deleteTimeStamp;
        this.deletePartKeyInfo = deletePartKeyInfo;
        this.omMultipartKeyInfo = omMultipartKeyInfo;
        this.oldMultipartKeyInfo = oldPartKeyInfo;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
            omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)OmUtils.getDeletedKeyName((String)this.openKey, (long)this.deleteTimeStamp), (Object)this.deletePartKeyInfo);
        }
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            if (this.oldMultipartKeyInfo != null) {
                omMetadataManager.getDeletedTable().putWithBatch(batchOperation, (Object)OmUtils.getDeletedKeyName((String)this.oldMultipartKeyInfo.getPartName(), (long)this.deleteTimeStamp), (Object)OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)this.oldMultipartKeyInfo.getPartKeyInfo()));
            }
            omMetadataManager.getMultipartInfoTable().putWithBatch(batchOperation, (Object)this.multipartKey, (Object)this.omMultipartKeyInfo);
            omMetadataManager.getOpenKeyTable().deleteWithBatch(batchOperation, (Object)this.openKey);
        }
    }
}

