/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.volume;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;

public class OMVolumeCreateResponse
extends OMClientResponse {
    private OzoneManagerProtocolProtos.VolumeList volumeList;
    private OmVolumeArgs omVolumeArgs;

    public OMVolumeCreateResponse(OmVolumeArgs omVolumeArgs, OzoneManagerProtocolProtos.VolumeList volumeList, OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.omVolumeArgs = omVolumeArgs;
        this.volumeList = volumeList;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            String dbVolumeKey = omMetadataManager.getVolumeKey(this.omVolumeArgs.getVolume());
            String dbUserKey = omMetadataManager.getUserKey(this.omVolumeArgs.getOwnerName());
            omMetadataManager.getVolumeTable().putWithBatch(batchOperation, (Object)dbVolumeKey, (Object)this.omVolumeArgs);
            omMetadataManager.getUserTable().putWithBatch(batchOperation, (Object)dbUserKey, (Object)this.volumeList);
        }
    }

    @VisibleForTesting
    public OmVolumeArgs getOmVolumeArgs() {
        return this.omVolumeArgs;
    }
}

