/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.volume;

import java.io.IOException;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;

public class OMVolumeDeleteResponse
extends OMClientResponse {
    private String volume;
    private String owner;
    private OzoneManagerProtocolProtos.VolumeList updatedVolumeList;

    public OMVolumeDeleteResponse(String volume, String owner, OzoneManagerProtocolProtos.VolumeList updatedVolumeList, OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.volume = volume;
        this.owner = owner;
        this.updatedVolumeList = updatedVolumeList;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            String dbUserKey = omMetadataManager.getUserKey(this.owner);
            OzoneManagerProtocolProtos.VolumeList volumeList = this.updatedVolumeList;
            if (this.updatedVolumeList.getVolumeNamesList().size() == 0) {
                omMetadataManager.getUserTable().deleteWithBatch(batchOperation, (Object)dbUserKey);
            } else {
                omMetadataManager.getUserTable().putWithBatch(batchOperation, (Object)dbUserKey, (Object)volumeList);
            }
            omMetadataManager.getVolumeTable().deleteWithBatch(batchOperation, (Object)omMetadataManager.getVolumeKey(this.volume));
        }
    }
}

