/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerDoubleBuffer;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerHARequestHandler;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler;

public class OzoneManagerHARequestHandlerImpl
extends OzoneManagerRequestHandler
implements OzoneManagerHARequestHandler {
    private OzoneManagerDoubleBuffer ozoneManagerDoubleBuffer;

    public OzoneManagerHARequestHandlerImpl(OzoneManager om, OzoneManagerDoubleBuffer ozoneManagerDoubleBuffer) {
        super(om);
        this.ozoneManagerDoubleBuffer = ozoneManagerDoubleBuffer;
    }

    @Override
    public OzoneManagerProtocolProtos.OMResponse handleApplyTransaction(OzoneManagerProtocolProtos.OMRequest omRequest, long transactionLogIndex) {
        LOG.debug("Received OMRequest: {}, ", (Object)omRequest);
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        switch (cmdType) {
            case CreateVolume: 
            case SetVolumeProperty: 
            case DeleteVolume: 
            case CreateBucket: 
            case DeleteBucket: 
            case SetBucketProperty: 
            case AllocateBlock: 
            case CreateKey: 
            case CommitKey: 
            case DeleteKey: 
            case RenameKey: 
            case CreateDirectory: 
            case CreateFile: 
            case PurgeKeys: 
            case CreateS3Bucket: 
            case DeleteS3Bucket: 
            case InitiateMultiPartUpload: 
            case CommitMultiPartUpload: 
            case AbortMultiPartUpload: {
                OMClientRequest omClientRequest = OzoneManagerRatisUtils.createClientRequest(omRequest);
                OMClientResponse omClientResponse = omClientRequest.validateAndUpdateCache(this.getOzoneManager(), transactionLogIndex);
                this.ozoneManagerDoubleBuffer.add(omClientResponse, transactionLogIndex);
                return omClientResponse.getOMResponse();
            }
        }
        return this.handle(omRequest);
    }
}

