/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import io.opentracing.Scope;
import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.NotLeaderException;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler;
import org.apache.hadoop.ozone.protocolPB.RequestHandler;
import org.apache.ratis.protocol.RaftPeerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerProtocolServerSideTranslatorPB
implements OzoneManagerProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerProtocolServerSideTranslatorPB.class);
    private final OzoneManagerRatisServer omRatisServer;
    private final RequestHandler handler;
    private final boolean isRatisEnabled;
    private final OzoneManager ozoneManager;

    public OzoneManagerProtocolServerSideTranslatorPB(OzoneManager impl, OzoneManagerRatisServer ratisServer, boolean enableRatis) {
        this.ozoneManager = impl;
        this.handler = new OzoneManagerRequestHandler(impl);
        this.omRatisServer = ratisServer;
        this.isRatisEnabled = enableRatis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OzoneManagerProtocolProtos.OMResponse submitRequest(RpcController controller, OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope((String)request.getCmdType().name(), (String)request.getTraceID());){
            if (this.isRatisEnabled) {
                if (OmUtils.isReadOnly((OzoneManagerProtocolProtos.OMRequest)request)) {
                    OzoneManagerProtocolProtos.OMResponse oMResponse = this.submitReadRequestToOM(request);
                    return oMResponse;
                }
                if (this.omRatisServer.isLeader()) {
                    try {
                        OMClientRequest omClientRequest = OzoneManagerRatisUtils.createClientRequest(request);
                        if (omClientRequest != null) {
                            request = omClientRequest.preExecute(this.ozoneManager);
                        }
                    }
                    catch (IOException ex) {
                        OzoneManagerProtocolProtos.OMResponse oMResponse = this.createErrorResponse(request, ex);
                        scope.close();
                        return oMResponse;
                    }
                    OzoneManagerProtocolProtos.OMResponse oMResponse = this.submitRequestToRatis(request);
                    return oMResponse;
                }
                throw this.createNotLeaderException();
            }
            OzoneManagerProtocolProtos.OMResponse oMResponse = this.submitRequestDirectlyToOM(request);
            return oMResponse;
        }
    }

    private OzoneManagerProtocolProtos.OMResponse createErrorResponse(OzoneManagerProtocolProtos.OMRequest omRequest, IOException exception) {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        switch (cmdType) {
            case CreateBucket: {
                OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setStatus(OzoneManagerRatisUtils.exceptionToResponseStatus(exception)).setCmdType(cmdType).setSuccess(false);
                if (exception.getMessage() != null) {
                    omResponse.setMessage(exception.getMessage());
                }
                return omResponse.build();
            }
            case DeleteBucket: 
            case SetBucketProperty: {
                return null;
            }
        }
        return null;
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequestToRatis(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        return this.omRatisServer.submitRequest(request);
    }

    private OzoneManagerProtocolProtos.OMResponse submitReadRequestToOM(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        if (this.omRatisServer.isLeader()) {
            return this.handler.handle(request);
        }
        throw this.createNotLeaderException();
    }

    private ServiceException createNotLeaderException() {
        RaftPeerId raftPeerId = this.omRatisServer.getRaftPeerId();
        Optional<RaftPeerId> leaderRaftPeerId = this.omRatisServer.getCachedLeaderPeerId();
        NotLeaderException notLeaderException = leaderRaftPeerId.isPresent() ? new NotLeaderException(raftPeerId.toString()) : new NotLeaderException(raftPeerId.toString(), leaderRaftPeerId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug(notLeaderException.getMessage());
        }
        return new ServiceException((Throwable)notLeaderException);
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequestDirectlyToOM(OzoneManagerProtocolProtos.OMRequest request) {
        return this.handler.handle(request);
    }
}

