/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "Yarn", "Ranger", "Hive", "HBase"})
@InterfaceStability.Evolving
public class OzoneNativeAuthorizer
implements IAccessAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneNativeAuthorizer.class);
    private VolumeManager volumeManager;
    private BucketManager bucketManager;
    private KeyManager keyManager;
    private PrefixManager prefixManager;

    public OzoneNativeAuthorizer() {
    }

    public OzoneNativeAuthorizer(VolumeManager volumeManager, BucketManager bucketManager, KeyManager keyManager, PrefixManager prefixManager) {
        this.volumeManager = volumeManager;
        this.bucketManager = bucketManager;
        this.keyManager = keyManager;
        this.prefixManager = prefixManager;
    }

    public boolean checkAccess(IOzoneObj ozObject, RequestContext context) throws OMException {
        Objects.requireNonNull(ozObject);
        Objects.requireNonNull(context);
        if (!(ozObject instanceof OzoneObjInfo)) {
            throw new OMException("Unexpected input received. OM native acls are configured to work with OzoneObjInfo type only.", OMException.ResultCodes.INVALID_REQUEST);
        }
        OzoneObjInfo objInfo = (OzoneObjInfo)ozObject;
        switch (objInfo.getResourceType()) {
            case VOLUME: {
                LOG.trace("Checking access for volume:" + objInfo);
                return this.volumeManager.checkAccess((OzoneObj)objInfo, context);
            }
            case BUCKET: {
                LOG.trace("Checking access for bucket:" + objInfo);
                return this.bucketManager.checkAccess((OzoneObj)objInfo, context) && this.volumeManager.checkAccess((OzoneObj)objInfo, context);
            }
            case KEY: {
                LOG.trace("Checking access for Key:" + objInfo);
                return this.keyManager.checkAccess((OzoneObj)objInfo, context) && this.prefixManager.checkAccess((OzoneObj)objInfo, context) && this.bucketManager.checkAccess((OzoneObj)objInfo, context) && this.volumeManager.checkAccess((OzoneObj)objInfo, context);
            }
            case PREFIX: {
                LOG.trace("Checking access for Prefix:" + objInfo);
                return this.prefixManager.checkAccess((OzoneObj)objInfo, context) && this.bucketManager.checkAccess((OzoneObj)objInfo, context) && this.volumeManager.checkAccess((OzoneObj)objInfo, context);
            }
        }
        throw new OMException("Unexpected object type:" + objInfo.getResourceType(), OMException.ResultCodes.INVALID_REQUEST);
    }

    public void setVolumeManager(VolumeManager volumeManager) {
        this.volumeManager = volumeManager;
    }

    public void setBucketManager(BucketManager bucketManager) {
        this.bucketManager = bucketManager;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setPrefixManager(PrefixManager prefixManager) {
        this.prefixManager = prefixManager;
    }
}

