/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.bucket;

import java.util.List;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import org.apache.hadoop.ozone.web.utils.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="getacl", description={"List all acls."})
public class GetAclBucketHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume/bucket.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--store", "-s"}, required=false, description={"store type. i.e OZONE or S3"})
    private String storeType;

    @Override
    public Void call() throws Exception {
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureBucketAddress();
        OzoneClient client = address.createClient(this.createOzoneConfiguration());
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        if (this.isVerbose()) {
            System.out.printf("Volume Name : %s%n", volumeName);
            System.out.printf("Bucket Name : %s%n", bucketName);
        }
        OzoneObjInfo obj = OzoneObjInfo.Builder.newBuilder().setBucketName(bucketName).setVolumeName(volumeName).setResType(OzoneObj.ResourceType.BUCKET).setStoreType(this.storeType == null ? OzoneObj.StoreType.OZONE : OzoneObj.StoreType.valueOf((String)this.storeType)).build();
        List result = client.getObjectStore().getAcl((OzoneObj)obj);
        System.out.printf("%s%n", JsonUtils.toJsonStringWithDefaultPrettyPrinter((String)JsonUtils.toJsonString((Object)result)));
        client.close();
        return null;
    }
}

