/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.util.Preconditions;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDeletingService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(KeyDeletingService.class);
    private static final int KEY_DELETING_CORE_POOL_SIZE = 2;
    private final OzoneManager ozoneManager;
    private final ScmBlockLocationProtocol scmClient;
    private final KeyManager manager;
    private ClientId clientId = ClientId.randomId();
    private final int keyLimitPerTask;
    private final AtomicLong deletedKeyCount;
    private final AtomicLong runCount;

    KeyDeletingService(OzoneManager ozoneManager, ScmBlockLocationProtocol scmClient, KeyManager manager, long serviceInterval, long serviceTimeout, Configuration conf) {
        super("KeyDeletingService", serviceInterval, TimeUnit.MILLISECONDS, 2, serviceTimeout);
        this.ozoneManager = ozoneManager;
        this.scmClient = scmClient;
        this.manager = manager;
        this.keyLimitPerTask = conf.getInt("ozone.key.deleting.limit.per.task", 1000);
        this.deletedKeyCount = new AtomicLong(0L);
        this.runCount = new AtomicLong(0L);
    }

    @VisibleForTesting
    public AtomicLong getRunCount() {
        return this.runCount;
    }

    @VisibleForTesting
    public AtomicLong getDeletedKeyCount() {
        return this.deletedKeyCount;
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new KeyDeletingTask());
        return queue;
    }

    private boolean shouldRun() {
        if (this.ozoneManager == null) {
            return true;
        }
        return this.ozoneManager.isLeader();
    }

    private boolean isRatisEnabled() {
        if (this.ozoneManager == null) {
            return false;
        }
        return this.ozoneManager.isRatisEnabled();
    }

    private void addToMap(Map<Pair<String, String>, List<String>> map, String objectKey) {
        String[] split = objectKey.split("/");
        Preconditions.assertTrue((split.length > 3 ? 1 : 0) != 0, (Object)"Volume and/or Bucket Name missing from Key Name.");
        Pair volumeBucketPair = Pair.of((Object)split[1], (Object)split[2]);
        if (!map.containsKey(volumeBucketPair)) {
            map.put((Pair<String, String>)volumeBucketPair, new ArrayList());
        }
        map.get(volumeBucketPair).add(objectKey);
    }

    private class KeyDeletingTask
    implements BackgroundTask<BackgroundTaskResult> {
        private KeyDeletingTask() {
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() throws Exception {
            if (KeyDeletingService.this.shouldRun()) {
                KeyDeletingService.this.runCount.incrementAndGet();
                try {
                    List results;
                    long startTime = Time.monotonicNow();
                    List<BlockGroup> keyBlocksList = KeyDeletingService.this.manager.getPendingDeletionKeys(KeyDeletingService.this.keyLimitPerTask);
                    if (keyBlocksList != null && !keyBlocksList.isEmpty() && (results = KeyDeletingService.this.scmClient.deleteKeyBlocks(keyBlocksList)) != null) {
                        int delCount = KeyDeletingService.this.isRatisEnabled() ? this.submitPurgeKeysRequest(results) : this.deleteAllKeys(results);
                        LOG.debug("Number of keys deleted: {}, elapsed time: {}ms", (Object)delCount, (Object)(Time.monotonicNow() - startTime));
                        KeyDeletingService.this.deletedKeyCount.addAndGet(delCount);
                    }
                }
                catch (IOException e) {
                    LOG.error("Error while running delete keys background task. Will retry at next run.", (Throwable)e);
                }
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }

        private int deleteAllKeys(List<DeleteBlockGroupResult> results) throws RocksDBException, IOException {
            Table deletedTable = KeyDeletingService.this.manager.getMetadataManager().getDeletedTable();
            DBStore store = KeyDeletingService.this.manager.getMetadataManager().getStore();
            int deletedCount = 0;
            try (BatchOperation writeBatch = store.initBatchOperation();){
                for (DeleteBlockGroupResult result : results) {
                    if (!result.isSuccess()) continue;
                    deletedTable.deleteWithBatch(writeBatch, (Object)result.getObjectKey());
                    LOG.debug("Key {} deleted from OM DB", (Object)result.getObjectKey());
                    ++deletedCount;
                }
                store.commitBatchOperation(writeBatch);
            }
            return deletedCount;
        }

        public int submitPurgeKeysRequest(List<DeleteBlockGroupResult> results) {
            HashMap purgeKeysMapPerBucket = new HashMap();
            int deletedCount = 0;
            for (DeleteBlockGroupResult deleteBlockGroupResult : results) {
                if (!deleteBlockGroupResult.isSuccess()) continue;
                String string = deleteBlockGroupResult.getObjectKey();
                KeyDeletingService.this.addToMap(purgeKeysMapPerBucket, string);
                LOG.debug("Key {} set to be purged from OM DB", (Object)string);
                ++deletedCount;
            }
            OzoneManagerProtocolProtos.PurgeKeysRequest.Builder purgeKeysRequest = OzoneManagerProtocolProtos.PurgeKeysRequest.newBuilder();
            for (Map.Entry entry : purgeKeysMapPerBucket.entrySet()) {
                Pair volumeBucketPair = (Pair)entry.getKey();
                OzoneManagerProtocolProtos.DeletedKeys deletedKeysInBucket = OzoneManagerProtocolProtos.DeletedKeys.newBuilder().setVolumeName((String)volumeBucketPair.getLeft()).setBucketName((String)volumeBucketPair.getRight()).addAllKeys((Iterable)entry.getValue()).build();
                purgeKeysRequest.addDeletedKeys(deletedKeysInBucket);
            }
            OzoneManagerProtocolProtos.OMRequest oMRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.PurgeKeys).setPurgeKeysRequest(purgeKeysRequest).setClientId(KeyDeletingService.this.clientId.toString()).build();
            try {
                KeyDeletingService.this.ozoneManager.getOmServerProtocol().submitRequest(null, oMRequest);
            }
            catch (ServiceException serviceException) {
                LOG.error("PurgeKey request failed. Will retry at next run.");
                return 0;
            }
            return deletedCount;
        }
    }
}

