/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.ratis.server.protocol.TermIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDBCheckpointServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(OMDBCheckpointServlet.class);
    private static final long serialVersionUID = 1L;
    private transient OzoneManager om;
    private transient DBStore omDbStore;
    private transient OMMetrics omMetrics;
    private transient DataTransferThrottler throttler = null;

    public void init() throws ServletException {
        this.om = (OzoneManager)this.getServletContext().getAttribute("ozone.om");
        if (this.om == null) {
            LOG.error("Unable to initialize OMDBCheckpointServlet. OM is null");
            return;
        }
        this.omDbStore = this.om.getMetadataManager().getStore();
        this.omMetrics = this.om.getMetrics();
        OzoneConfiguration configuration = this.om.getConfiguration();
        long transferBandwidth = configuration.getLongBytes("ozone.manager.db.checkpoint.transfer.bandwidthPerSec", 0L);
        if (transferBandwidth > 0L) {
            this.throttler = new DataTransferThrottler(transferBandwidth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("Received request to obtain OM DB checkpoint snapshot");
        if (this.omDbStore == null) {
            LOG.error("Unable to process metadata snapshot request. DB Store is null");
            response.setStatus(500);
            return;
        }
        DBCheckpoint checkpoint = null;
        try {
            boolean flush = false;
            String flushParam = request.getParameter("flushBeforeCheckpoint");
            if (StringUtils.isNotEmpty((CharSequence)flushParam)) {
                flush = Boolean.valueOf(flushParam);
            }
            boolean takeRatisSnapshot = false;
            String snapshotBeforeCheckpointParam = request.getParameter("snapshotBeforeCheckpoint");
            if (StringUtils.isNotEmpty((CharSequence)snapshotBeforeCheckpointParam)) {
                takeRatisSnapshot = Boolean.valueOf(snapshotBeforeCheckpointParam);
            }
            if (takeRatisSnapshot) {
                flush = false;
                TermIndex lastAppliedTermIndex = this.om.saveRatisSnapshot();
                response.setHeader("ratisSnapshotIndex", String.valueOf(lastAppliedTermIndex.getIndex()));
                response.setHeader("ratisSnapshotTerm", String.valueOf(lastAppliedTermIndex.getTerm()));
            }
            if ((checkpoint = this.omDbStore.getCheckpoint(flush)) == null || checkpoint.getCheckpointLocation() == null) {
                LOG.error("Unable to process metadata snapshot request. Checkpoint request returned null.");
                response.setStatus(500);
                return;
            }
            this.omMetrics.setLastCheckpointCreationTimeTaken(checkpoint.checkpointCreationTimeTaken());
            Path file = checkpoint.getCheckpointLocation().getFileName();
            if (file == null) {
                return;
            }
            response.setContentType("application/x-tgz");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + file.toString() + ".tgz\"");
            Instant start = Instant.now();
            OmUtils.writeOmDBCheckpointToStream((DBCheckpoint)checkpoint, (OutputStream)response.getOutputStream());
            Instant end = Instant.now();
            long duration = Duration.between(start, end).toMillis();
            LOG.info("Time taken to write the checkpoint to response output stream: {} milliseconds", (Object)duration);
            this.omMetrics.setLastCheckpointStreamingTimeTaken(duration);
            this.omMetrics.incNumCheckpoints();
        }
        catch (Exception e) {
            LOG.error("Unable to process metadata snapshot request. ", (Throwable)e);
            response.setStatus(500);
            this.omMetrics.incNumCheckpointFails();
        }
        finally {
            if (checkpoint != null) {
                try {
                    checkpoint.cleanupCheckpoint();
                }
                catch (IOException e) {
                    LOG.error("Error trying to clean checkpoint at {} .", (Object)checkpoint.getCheckpointLocation().toString());
                }
            }
        }
    }
}

