/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@InterfaceAudience.Private
@Metrics(about="Ozone Manager Metrics", context="dfs")
public class OMMetrics {
    private static final String SOURCE_NAME = OMMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numVolumeOps;
    @Metric
    private MutableCounterLong numBucketOps;
    @Metric
    private MutableCounterLong numKeyOps;
    @Metric
    private MutableCounterLong numFSOps;
    @Metric
    private MutableCounterLong numVolumeCreates;
    @Metric
    private MutableCounterLong numVolumeUpdates;
    @Metric
    private MutableCounterLong numVolumeInfos;
    @Metric
    private MutableCounterLong numVolumeCheckAccesses;
    @Metric
    private MutableCounterLong numBucketCreates;
    @Metric
    private MutableCounterLong numVolumeDeletes;
    @Metric
    private MutableCounterLong numBucketInfos;
    @Metric
    private MutableCounterLong numBucketUpdates;
    @Metric
    private MutableCounterLong numBucketDeletes;
    @Metric
    private MutableCounterLong numKeyAllocate;
    @Metric
    private MutableCounterLong numKeyLookup;
    @Metric
    private MutableCounterLong numKeyRenames;
    @Metric
    private MutableCounterLong numKeyDeletes;
    @Metric
    private MutableCounterLong numBucketLists;
    @Metric
    private MutableCounterLong numKeyLists;
    @Metric
    private MutableCounterLong numTrashKeyLists;
    @Metric
    private MutableCounterLong numVolumeLists;
    @Metric
    private MutableCounterLong numKeyCommits;
    @Metric
    private MutableCounterLong numBlockAllocations;
    @Metric
    private MutableCounterLong numGetServiceLists;
    @Metric
    private MutableCounterLong numBucketS3Lists;
    @Metric
    private MutableCounterLong numInitiateMultipartUploads;
    @Metric
    private MutableCounterLong numCompleteMultipartUploads;
    @Metric
    private MutableCounterLong numGetFileStatus;
    @Metric
    private MutableCounterLong numCreateDirectory;
    @Metric
    private MutableCounterLong numCreateFile;
    @Metric
    private MutableCounterLong numLookupFile;
    @Metric
    private MutableCounterLong numListStatus;
    @Metric
    private MutableCounterLong numVolumeCreateFails;
    @Metric
    private MutableCounterLong numVolumeUpdateFails;
    @Metric
    private MutableCounterLong numVolumeInfoFails;
    @Metric
    private MutableCounterLong numVolumeDeleteFails;
    @Metric
    private MutableCounterLong numBucketCreateFails;
    @Metric
    private MutableCounterLong numVolumeCheckAccessFails;
    @Metric
    private MutableCounterLong numBucketInfoFails;
    @Metric
    private MutableCounterLong numBucketUpdateFails;
    @Metric
    private MutableCounterLong numBucketDeleteFails;
    @Metric
    private MutableCounterLong numKeyAllocateFails;
    @Metric
    private MutableCounterLong numKeyLookupFails;
    @Metric
    private MutableCounterLong numKeyRenameFails;
    @Metric
    private MutableCounterLong numKeyDeleteFails;
    @Metric
    private MutableCounterLong numBucketListFails;
    @Metric
    private MutableCounterLong numKeyListFails;
    @Metric
    private MutableCounterLong numTrashKeyListFails;
    @Metric
    private MutableCounterLong numVolumeListFails;
    @Metric
    private MutableCounterLong numKeyCommitFails;
    @Metric
    private MutableCounterLong numBlockAllocationFails;
    @Metric
    private MutableCounterLong numGetServiceListFails;
    @Metric
    private MutableCounterLong numBucketS3ListFails;
    @Metric
    private MutableCounterLong numInitiateMultipartUploadFails;
    @Metric
    private MutableCounterLong numCommitMultipartUploadParts;
    @Metric
    private MutableCounterLong numCommitMultipartUploadPartFails;
    @Metric
    private MutableCounterLong numCompleteMultipartUploadFails;
    @Metric
    private MutableCounterLong numAbortMultipartUploads;
    @Metric
    private MutableCounterLong numAbortMultipartUploadFails;
    @Metric
    private MutableCounterLong numListMultipartUploadParts;
    @Metric
    private MutableCounterLong numListMultipartUploadPartFails;
    @Metric
    private MutableCounterLong numGetFileStatusFails;
    @Metric
    private MutableCounterLong numCreateDirectoryFails;
    @Metric
    private MutableCounterLong numCreateFileFails;
    @Metric
    private MutableCounterLong numLookupFileFails;
    @Metric
    private MutableCounterLong numListStatusFails;
    @Metric
    private MutableCounterLong numVolumes;
    @Metric
    private MutableCounterLong numBuckets;
    @Metric
    private MutableCounterLong numS3Buckets;
    @Metric
    private MutableCounterLong numKeys;
    @Metric
    private MutableGaugeLong lastCheckpointCreationTimeTaken;
    @Metric
    private MutableGaugeLong lastCheckpointStreamingTimeTaken;
    @Metric
    private MutableCounterLong numCheckpoints;
    @Metric
    private MutableCounterLong numCheckpointFails;
    @Metric
    private MutableCounterLong numBucketS3Creates;
    @Metric
    private MutableCounterLong numBucketS3CreateFails;
    @Metric
    private MutableCounterLong numBucketS3Deletes;
    @Metric
    private MutableCounterLong numBucketS3DeleteFails;
    @Metric
    private MutableCounterLong numListMultipartUploadFails;
    @Metric
    private MutableCounterLong numListMultipartUploads;

    public static OMMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (OMMetrics)ms.register(SOURCE_NAME, "Ozone Manager Metrics", (Object)new OMMetrics());
    }

    public void incNumS3BucketCreates() {
        this.numBucketOps.incr();
        this.numBucketS3Creates.incr();
    }

    public void incNumS3BucketCreateFails() {
        this.numBucketS3CreateFails.incr();
    }

    public void incNumS3BucketDeletes() {
        this.numBucketOps.incr();
        this.numBucketS3Deletes.incr();
    }

    public void incNumS3BucketDeleteFails() {
        this.numBucketOps.incr();
        this.numBucketS3DeleteFails.incr();
    }

    public void incNumS3Buckets() {
        this.numS3Buckets.incr();
    }

    public void decNumS3Buckets() {
        this.numS3Buckets.incr();
    }

    public void incNumVolumes() {
        this.numVolumes.incr();
    }

    public void decNumVolumes() {
        this.numVolumes.incr(-1L);
    }

    public void incNumBuckets() {
        this.numBuckets.incr();
    }

    public void decNumBuckets() {
        this.numBuckets.incr(-1L);
    }

    public void incNumKeys() {
        this.numKeys.incr();
    }

    public void decNumKeys() {
        this.numKeys.incr(-1L);
    }

    public void setNumVolumes(long val) {
        long oldVal = this.numVolumes.value();
        this.numVolumes.incr(val - oldVal);
    }

    public void setNumBuckets(long val) {
        long oldVal = this.numBuckets.value();
        this.numBuckets.incr(val - oldVal);
    }

    public void setNumKeys(long val) {
        long oldVal = this.numKeys.value();
        this.numKeys.incr(val - oldVal);
    }

    public long getNumVolumes() {
        return this.numVolumes.value();
    }

    public long getNumBuckets() {
        return this.numBuckets.value();
    }

    public long getNumKeys() {
        return this.numKeys.value();
    }

    public void incNumVolumeCreates() {
        this.numVolumeOps.incr();
        this.numVolumeCreates.incr();
    }

    public void incNumVolumeUpdates() {
        this.numVolumeOps.incr();
        this.numVolumeUpdates.incr();
    }

    public void incNumVolumeInfos() {
        this.numVolumeOps.incr();
        this.numVolumeInfos.incr();
    }

    public void incNumVolumeDeletes() {
        this.numVolumeOps.incr();
        this.numVolumeDeletes.incr();
    }

    public void incNumVolumeCheckAccesses() {
        this.numVolumeOps.incr();
        this.numVolumeCheckAccesses.incr();
    }

    public void incNumBucketCreates() {
        this.numBucketOps.incr();
        this.numBucketCreates.incr();
    }

    public void incNumBucketInfos() {
        this.numBucketOps.incr();
        this.numBucketInfos.incr();
    }

    public void incNumBucketUpdates() {
        this.numBucketOps.incr();
        this.numBucketUpdates.incr();
    }

    public void incNumBucketDeletes() {
        this.numBucketOps.incr();
        this.numBucketDeletes.incr();
    }

    public void incNumBucketLists() {
        this.numBucketOps.incr();
        this.numBucketLists.incr();
    }

    public void incNumKeyLists() {
        this.numKeyOps.incr();
        this.numKeyLists.incr();
    }

    public void incNumTrashKeyLists() {
        this.numKeyOps.incr();
        this.numTrashKeyLists.incr();
    }

    public void incNumVolumeLists() {
        this.numVolumeOps.incr();
        this.numVolumeLists.incr();
    }

    public void incNumListS3Buckets() {
        this.numBucketOps.incr();
        this.numBucketS3Lists.incr();
    }

    public void incNumListS3BucketsFails() {
        this.numBucketOps.incr();
        this.numBucketS3ListFails.incr();
    }

    public void incNumInitiateMultipartUploads() {
        this.numKeyOps.incr();
        this.numInitiateMultipartUploads.incr();
    }

    public void incNumInitiateMultipartUploadFails() {
        this.numInitiateMultipartUploadFails.incr();
    }

    public void incNumCommitMultipartUploadParts() {
        this.numKeyOps.incr();
        this.numCommitMultipartUploadParts.incr();
    }

    public void incNumCommitMultipartUploadPartFails() {
        this.numCommitMultipartUploadPartFails.incr();
    }

    public void incNumCompleteMultipartUploads() {
        this.numKeyOps.incr();
        this.numCompleteMultipartUploads.incr();
    }

    public void incNumCompleteMultipartUploadFails() {
        this.numCompleteMultipartUploadFails.incr();
    }

    public void incNumAbortMultipartUploads() {
        this.numKeyOps.incr();
        this.numAbortMultipartUploads.incr();
    }

    public void incNumListMultipartUploadFails() {
        this.numListMultipartUploadFails.incr();
    }

    public void incNumListMultipartUploads() {
        this.numKeyOps.incr();
        this.numListMultipartUploads.incr();
    }

    public void incNumAbortMultipartUploadFails() {
        this.numAbortMultipartUploadFails.incr();
    }

    public void incNumListMultipartUploadParts() {
        this.numKeyOps.incr();
        this.numListMultipartUploadParts.incr();
    }

    public void incNumGetFileStatus() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numGetFileStatus.incr();
    }

    public void incNumGetFileStatusFails() {
        this.numGetFileStatusFails.incr();
    }

    public void incNumCreateDirectory() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numCreateDirectory.incr();
    }

    public void incNumCreateDirectoryFails() {
        this.numCreateDirectoryFails.incr();
    }

    public void incNumCreateFile() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numCreateFile.incr();
    }

    public void incNumCreateFileFails() {
        this.numCreateFileFails.incr();
    }

    public void incNumLookupFile() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numLookupFile.incr();
    }

    public void incNumLookupFileFails() {
        this.numLookupFileFails.incr();
    }

    public void incNumListStatus() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numListStatus.incr();
    }

    public void incNumListStatusFails() {
        this.numListStatusFails.incr();
    }

    public void incNumListMultipartUploadPartFails() {
        this.numListMultipartUploadPartFails.incr();
    }

    public void incNumGetServiceLists() {
        this.numGetServiceLists.incr();
    }

    public void incNumVolumeCreateFails() {
        this.numVolumeCreateFails.incr();
    }

    public void incNumVolumeUpdateFails() {
        this.numVolumeUpdateFails.incr();
    }

    public void incNumVolumeInfoFails() {
        this.numVolumeInfoFails.incr();
    }

    public void incNumVolumeDeleteFails() {
        this.numVolumeDeleteFails.incr();
    }

    public void incNumVolumeCheckAccessFails() {
        this.numVolumeCheckAccessFails.incr();
    }

    public void incNumBucketCreateFails() {
        this.numBucketCreateFails.incr();
    }

    public void incNumBucketInfoFails() {
        this.numBucketInfoFails.incr();
    }

    public void incNumBucketUpdateFails() {
        this.numBucketUpdateFails.incr();
    }

    public void incNumBucketDeleteFails() {
        this.numBucketDeleteFails.incr();
    }

    public void incNumKeyAllocates() {
        this.numKeyOps.incr();
        this.numKeyAllocate.incr();
    }

    public void incNumKeyAllocateFails() {
        this.numKeyAllocateFails.incr();
    }

    public void incNumKeyLookups() {
        this.numKeyOps.incr();
        this.numKeyLookup.incr();
    }

    public void incNumKeyLookupFails() {
        this.numKeyLookupFails.incr();
    }

    public void incNumKeyRenames() {
        this.numKeyOps.incr();
        this.numKeyRenames.incr();
    }

    public void incNumKeyRenameFails() {
        this.numKeyOps.incr();
        this.numKeyRenameFails.incr();
    }

    public void incNumKeyDeleteFails() {
        this.numKeyDeleteFails.incr();
    }

    public void incNumKeyDeletes() {
        this.numKeyOps.incr();
        this.numKeyDeletes.incr();
    }

    public void incNumKeyCommits() {
        this.numKeyOps.incr();
        this.numKeyCommits.incr();
    }

    public void incNumKeyCommitFails() {
        this.numKeyCommitFails.incr();
    }

    public void incNumBlockAllocateCalls() {
        this.numBlockAllocations.incr();
    }

    public void incNumBlockAllocateCallFails() {
        this.numBlockAllocationFails.incr();
    }

    public void incNumBucketListFails() {
        this.numBucketListFails.incr();
    }

    public void incNumKeyListFails() {
        this.numKeyListFails.incr();
    }

    public void incNumTrashKeyListFails() {
        this.numTrashKeyListFails.incr();
    }

    public void incNumVolumeListFails() {
        this.numVolumeListFails.incr();
    }

    public void incNumGetServiceListFails() {
        this.numGetServiceListFails.incr();
    }

    public void setLastCheckpointCreationTimeTaken(long val) {
        this.lastCheckpointCreationTimeTaken.set(val);
    }

    public void setLastCheckpointStreamingTimeTaken(long val) {
        this.lastCheckpointStreamingTimeTaken.set(val);
    }

    public void incNumCheckpoints() {
        this.numCheckpoints.incr();
    }

    public void incNumCheckpointFails() {
        this.numCheckpointFails.incr();
    }

    @VisibleForTesting
    public long getNumVolumeCreates() {
        return this.numVolumeCreates.value();
    }

    @VisibleForTesting
    public long getNumVolumeUpdates() {
        return this.numVolumeUpdates.value();
    }

    @VisibleForTesting
    public long getNumVolumeInfos() {
        return this.numVolumeInfos.value();
    }

    @VisibleForTesting
    public long getNumVolumeDeletes() {
        return this.numVolumeDeletes.value();
    }

    @VisibleForTesting
    public long getNumVolumeCheckAccesses() {
        return this.numVolumeCheckAccesses.value();
    }

    @VisibleForTesting
    public long getNumBucketCreates() {
        return this.numBucketCreates.value();
    }

    @VisibleForTesting
    public long getNumBucketInfos() {
        return this.numBucketInfos.value();
    }

    @VisibleForTesting
    public long getNumBucketUpdates() {
        return this.numBucketUpdates.value();
    }

    @VisibleForTesting
    public long getNumBucketDeletes() {
        return this.numBucketDeletes.value();
    }

    @VisibleForTesting
    public long getNumBucketLists() {
        return this.numBucketLists.value();
    }

    @VisibleForTesting
    public long getNumVolumeLists() {
        return this.numVolumeLists.value();
    }

    @VisibleForTesting
    public long getNumKeyLists() {
        return this.numKeyLists.value();
    }

    @VisibleForTesting
    public long getNumTrashKeyLists() {
        return this.numTrashKeyLists.value();
    }

    @VisibleForTesting
    public long getNumGetServiceLists() {
        return this.numGetServiceLists.value();
    }

    @VisibleForTesting
    public long getNumVolumeCreateFails() {
        return this.numVolumeCreateFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeUpdateFails() {
        return this.numVolumeUpdateFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeInfoFails() {
        return this.numVolumeInfoFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeDeleteFails() {
        return this.numVolumeDeleteFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeCheckAccessFails() {
        return this.numVolumeCheckAccessFails.value();
    }

    @VisibleForTesting
    public long getNumBucketCreateFails() {
        return this.numBucketCreateFails.value();
    }

    @VisibleForTesting
    public long getNumBucketInfoFails() {
        return this.numBucketInfoFails.value();
    }

    @VisibleForTesting
    public long getNumBucketUpdateFails() {
        return this.numBucketUpdateFails.value();
    }

    @VisibleForTesting
    public long getNumBucketDeleteFails() {
        return this.numBucketDeleteFails.value();
    }

    @VisibleForTesting
    public long getNumKeyAllocates() {
        return this.numKeyAllocate.value();
    }

    @VisibleForTesting
    public long getNumKeyAllocateFails() {
        return this.numKeyAllocateFails.value();
    }

    @VisibleForTesting
    public long getNumKeyLookups() {
        return this.numKeyLookup.value();
    }

    @VisibleForTesting
    public long getNumKeyLookupFails() {
        return this.numKeyLookupFails.value();
    }

    @VisibleForTesting
    public long getNumKeyRenames() {
        return this.numKeyRenames.value();
    }

    @VisibleForTesting
    public long getNumKeyRenameFails() {
        return this.numKeyRenameFails.value();
    }

    @VisibleForTesting
    public long getNumKeyDeletes() {
        return this.numKeyDeletes.value();
    }

    @VisibleForTesting
    public long getNumKeyDeletesFails() {
        return this.numKeyDeleteFails.value();
    }

    @VisibleForTesting
    public long getNumBucketListFails() {
        return this.numBucketListFails.value();
    }

    @VisibleForTesting
    public long getNumKeyListFails() {
        return this.numKeyListFails.value();
    }

    @VisibleForTesting
    public long getNumTrashKeyListFails() {
        return this.numTrashKeyListFails.value();
    }

    @VisibleForTesting
    public long getNumFSOps() {
        return this.numFSOps.value();
    }

    @VisibleForTesting
    public long getNumGetFileStatus() {
        return this.numGetFileStatus.value();
    }

    @VisibleForTesting
    public long getNumListStatus() {
        return this.numListStatus.value();
    }

    @VisibleForTesting
    public long getNumVolumeListFails() {
        return this.numVolumeListFails.value();
    }

    @VisibleForTesting
    public long getNumKeyCommits() {
        return this.numKeyCommits.value();
    }

    @VisibleForTesting
    public long getNumKeyCommitFails() {
        return this.numKeyCommitFails.value();
    }

    @VisibleForTesting
    public long getNumBlockAllocates() {
        return this.numBlockAllocations.value();
    }

    @VisibleForTesting
    public long getNumBlockAllocateFails() {
        return this.numBlockAllocationFails.value();
    }

    @VisibleForTesting
    public long getNumGetServiceListFails() {
        return this.numGetServiceListFails.value();
    }

    @VisibleForTesting
    public long getNumListS3Buckets() {
        return this.numBucketS3Lists.value();
    }

    @VisibleForTesting
    public long getNumListS3BucketsFails() {
        return this.numBucketS3ListFails.value();
    }

    public long getNumInitiateMultipartUploads() {
        return this.numInitiateMultipartUploads.value();
    }

    public long getNumInitiateMultipartUploadFails() {
        return this.numInitiateMultipartUploadFails.value();
    }

    public long getNumAbortMultipartUploads() {
        return this.numAbortMultipartUploads.value();
    }

    public long getNumAbortMultipartUploadFails() {
        return this.numAbortMultipartUploadFails.value();
    }

    @VisibleForTesting
    public long getLastCheckpointCreationTimeTaken() {
        return this.lastCheckpointCreationTimeTaken.value();
    }

    @VisibleForTesting
    public long getNumCheckpoints() {
        return this.numCheckpoints.value();
    }

    @VisibleForTesting
    public long getLastCheckpointStreamingTimeTaken() {
        return this.lastCheckpointStreamingTimeTaken.value();
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

