/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.RocksDBConfiguration;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.TypedTable;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.hdds.utils.db.cache.TableCacheImpl;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.codec.OmBucketInfoCodec;
import org.apache.hadoop.ozone.om.codec.OmKeyInfoCodec;
import org.apache.hadoop.ozone.om.codec.OmMultipartKeyInfoCodec;
import org.apache.hadoop.ozone.om.codec.OmPrefixInfoCodec;
import org.apache.hadoop.ozone.om.codec.OmVolumeArgsCodec;
import org.apache.hadoop.ozone.om.codec.RepeatedOmKeyInfoCodec;
import org.apache.hadoop.ozone.om.codec.S3SecretValueCodec;
import org.apache.hadoop.ozone.om.codec.TokenIdentifierCodec;
import org.apache.hadoop.ozone.om.codec.UserVolumeInfoCodec;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUpload;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmMetadataManagerImpl
implements OMMetadataManager {
    private static final Logger LOG = LoggerFactory.getLogger(OmMetadataManagerImpl.class);
    public static final String USER_TABLE = "userTable";
    public static final String VOLUME_TABLE = "volumeTable";
    public static final String BUCKET_TABLE = "bucketTable";
    public static final String KEY_TABLE = "keyTable";
    public static final String DELETED_TABLE = "deletedTable";
    public static final String OPEN_KEY_TABLE = "openKeyTable";
    public static final String S3_TABLE = "s3Table";
    public static final String MULTIPARTINFO_TABLE = "multipartInfoTable";
    public static final String S3_SECRET_TABLE = "s3SecretTable";
    public static final String DELEGATION_TOKEN_TABLE = "dTokenTable";
    public static final String PREFIX_TABLE = "prefixTable";
    private DBStore store;
    private final OzoneManagerLock lock;
    private final long openKeyExpireThresholdMS;
    private Table userTable;
    private Table volumeTable;
    private Table bucketTable;
    private Table keyTable;
    private Table deletedTable;
    private Table openKeyTable;
    private Table s3Table;
    private Table<String, OmMultipartKeyInfo> multipartInfoTable;
    private Table s3SecretTable;
    private Table dTokenTable;
    private Table prefixTable;
    private boolean isRatisEnabled;

    public OmMetadataManagerImpl(OzoneConfiguration conf) throws IOException {
        this.lock = new OzoneManagerLock((Configuration)conf);
        this.openKeyExpireThresholdMS = 1000L * (long)conf.getInt("ozone.open.key.expire.threshold", 86400);
        this.isRatisEnabled = conf.getBoolean("ozone.om.ratis.enable", false);
        this.start(conf);
    }

    protected OmMetadataManagerImpl() {
        this.lock = new OzoneManagerLock((Configuration)new OzoneConfiguration());
        this.openKeyExpireThresholdMS = 86400L;
    }

    public Table<String, OzoneManagerProtocolProtos.UserVolumeInfo> getUserTable() {
        return this.userTable;
    }

    public Table<OzoneTokenIdentifier, Long> getDelegationTokenTable() {
        return this.dTokenTable;
    }

    public Table<String, OmVolumeArgs> getVolumeTable() {
        return this.volumeTable;
    }

    public Table<String, OmBucketInfo> getBucketTable() {
        return this.bucketTable;
    }

    public Table<String, OmKeyInfo> getKeyTable() {
        return this.keyTable;
    }

    public Table<String, RepeatedOmKeyInfo> getDeletedTable() {
        return this.deletedTable;
    }

    public Table<String, OmKeyInfo> getOpenKeyTable() {
        return this.openKeyTable;
    }

    public Table<String, String> getS3Table() {
        return this.s3Table;
    }

    public Table<String, OmPrefixInfo> getPrefixTable() {
        return this.prefixTable;
    }

    public Table<String, OmMultipartKeyInfo> getMultipartInfoTable() {
        return this.multipartInfoTable;
    }

    private void checkTableStatus(Table table, String name) throws IOException {
        String logMessage = "Unable to get a reference to %s table. Cannot continue.";
        String errMsg = "Inconsistent DB state, Table - %s. Please check the logsfor more info.";
        if (table == null) {
            LOG.error(String.format(logMessage, name));
            throw new IOException(String.format(errMsg, name));
        }
    }

    public void start(OzoneConfiguration configuration) throws IOException {
        if (this.store == null) {
            File metaDir = OMStorage.getOmDbDir((Configuration)configuration);
            RocksDBConfiguration rocksDBConfiguration = (RocksDBConfiguration)configuration.getObject(RocksDBConfiguration.class);
            if (!this.isRatisEnabled) {
                rocksDBConfiguration.setSyncOption(true);
            }
            DBStoreBuilder dbStoreBuilder = DBStoreBuilder.newBuilder((OzoneConfiguration)configuration, (RocksDBConfiguration)rocksDBConfiguration).setName("om.db").setPath(Paths.get(metaDir.getPath(), new String[0]));
            this.store = this.addOMTablesAndCodecs(dbStoreBuilder).build();
            this.initializeOmTables();
        }
    }

    protected DBStoreBuilder addOMTablesAndCodecs(DBStoreBuilder builder) {
        return builder.addTable(USER_TABLE).addTable(VOLUME_TABLE).addTable(BUCKET_TABLE).addTable(KEY_TABLE).addTable(DELETED_TABLE).addTable(OPEN_KEY_TABLE).addTable(S3_TABLE).addTable(MULTIPARTINFO_TABLE).addTable(DELEGATION_TOKEN_TABLE).addTable(S3_SECRET_TABLE).addTable(PREFIX_TABLE).addCodec(OzoneTokenIdentifier.class, (Codec)new TokenIdentifierCodec()).addCodec(OmKeyInfo.class, (Codec)new OmKeyInfoCodec()).addCodec(RepeatedOmKeyInfo.class, (Codec)new RepeatedOmKeyInfoCodec()).addCodec(OmBucketInfo.class, (Codec)new OmBucketInfoCodec()).addCodec(OmVolumeArgs.class, (Codec)new OmVolumeArgsCodec()).addCodec(OzoneManagerProtocolProtos.UserVolumeInfo.class, (Codec)new UserVolumeInfoCodec()).addCodec(OmMultipartKeyInfo.class, (Codec)new OmMultipartKeyInfoCodec()).addCodec(S3SecretValue.class, (Codec)new S3SecretValueCodec()).addCodec(OmPrefixInfo.class, (Codec)new OmPrefixInfoCodec());
    }

    protected void initializeOmTables() throws IOException {
        this.userTable = this.store.getTable(USER_TABLE, String.class, OzoneManagerProtocolProtos.UserVolumeInfo.class);
        this.checkTableStatus(this.userTable, USER_TABLE);
        TableCacheImpl.CacheCleanupPolicy cleanupPolicy = TableCacheImpl.CacheCleanupPolicy.NEVER;
        this.volumeTable = this.store.getTable(VOLUME_TABLE, String.class, OmVolumeArgs.class, cleanupPolicy);
        this.checkTableStatus(this.volumeTable, VOLUME_TABLE);
        this.bucketTable = this.store.getTable(BUCKET_TABLE, String.class, OmBucketInfo.class, cleanupPolicy);
        this.checkTableStatus(this.bucketTable, BUCKET_TABLE);
        this.keyTable = this.store.getTable(KEY_TABLE, String.class, OmKeyInfo.class);
        this.checkTableStatus(this.keyTable, KEY_TABLE);
        this.deletedTable = this.store.getTable(DELETED_TABLE, String.class, RepeatedOmKeyInfo.class);
        this.checkTableStatus(this.deletedTable, DELETED_TABLE);
        this.openKeyTable = this.store.getTable(OPEN_KEY_TABLE, String.class, OmKeyInfo.class);
        this.checkTableStatus(this.openKeyTable, OPEN_KEY_TABLE);
        this.s3Table = this.store.getTable(S3_TABLE, String.class, String.class);
        this.checkTableStatus(this.s3Table, S3_TABLE);
        this.multipartInfoTable = this.store.getTable(MULTIPARTINFO_TABLE, String.class, OmMultipartKeyInfo.class);
        this.checkTableStatus(this.multipartInfoTable, MULTIPARTINFO_TABLE);
        this.dTokenTable = this.store.getTable(DELEGATION_TOKEN_TABLE, OzoneTokenIdentifier.class, Long.class);
        this.checkTableStatus(this.dTokenTable, DELEGATION_TOKEN_TABLE);
        this.s3SecretTable = this.store.getTable(S3_SECRET_TABLE, String.class, S3SecretValue.class);
        this.checkTableStatus(this.s3SecretTable, S3_SECRET_TABLE);
        this.prefixTable = this.store.getTable(PREFIX_TABLE, String.class, OmPrefixInfo.class);
        this.checkTableStatus(this.prefixTable, PREFIX_TABLE);
    }

    public void stop() throws Exception {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @VisibleForTesting
    public DBStore getStore() {
        return this.store;
    }

    public String getVolumeKey(String volume) {
        return "/" + volume;
    }

    public String getUserKey(String user) {
        return user;
    }

    public String getBucketKey(String volume, String bucket) {
        StringBuilder builder = new StringBuilder().append("/").append(volume);
        if (StringUtils.isNotBlank((CharSequence)bucket)) {
            builder.append("/").append(bucket);
        }
        return builder.toString();
    }

    public String getOzoneKey(String volume, String bucket, String key) {
        StringBuilder builder = new StringBuilder().append("/").append(volume);
        builder.append("/").append(bucket);
        if (StringUtil.isNotBlank((String)key)) {
            builder.append("/");
            if (!key.equals("/")) {
                builder.append(key);
            }
        }
        return builder.toString();
    }

    public String getOzoneDirKey(String volume, String bucket, String key) {
        key = OzoneFSUtils.addTrailingSlashIfNeeded((String)key);
        return this.getOzoneKey(volume, bucket, key);
    }

    public String getOpenKey(String volume, String bucket, String key, long id) {
        String openKey = "/" + volume + "/" + bucket + "/" + key + "/" + id;
        return openKey;
    }

    public String getMultipartKey(String volume, String bucket, String key, String uploadId) {
        return OmMultipartUpload.getDbKey((String)volume, (String)bucket, (String)key, (String)uploadId);
    }

    public OzoneManagerLock getLock() {
        return this.lock;
    }

    private boolean startsWith(byte[] firstArray, byte[] secondArray) {
        if (firstArray == null) {
            return secondArray == null;
        }
        if (secondArray != null) {
            if (secondArray.length > firstArray.length) {
                return false;
            }
            for (int ndx = 0; ndx < secondArray.length; ++ndx) {
                if (firstArray[ndx] == secondArray[ndx]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isVolumeEmpty(String volume) throws IOException {
        String volumePrefix = this.getVolumeKey(volume + "/");
        Iterator iterator = ((TypedTable)this.bucketTable).cacheIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)((CacheKey)entry.getKey()).getCacheKey();
            OmBucketInfo omBucketInfo = (OmBucketInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (!key.startsWith(volumePrefix) || omBucketInfo == null) continue;
            return false;
        }
        try (TableIterator bucketIter = this.bucketTable.iterator();){
            Table.KeyValue kv = (Table.KeyValue)bucketIter.seek((Object)volumePrefix);
            if (kv != null) {
                CacheValue cacheValue = this.bucketTable.getCacheValue(new CacheKey(kv.getKey()));
                if (cacheValue != null) {
                    if (((String)kv.getKey()).startsWith(volumePrefix) && cacheValue.getCacheValue() != null) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (((String)kv.getKey()).startsWith(volumePrefix)) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    public boolean isBucketEmpty(String volume, String bucket) throws IOException {
        String keyPrefix = this.getBucketKey(volume, bucket);
        Iterator iterator = ((TypedTable)this.keyTable).cacheIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)((CacheKey)entry.getKey()).getCacheKey();
            OmKeyInfo omKeyInfo = (OmKeyInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (!key.startsWith(keyPrefix) || omKeyInfo == null) continue;
            return false;
        }
        try (TableIterator keyIter = this.keyTable.iterator();){
            Table.KeyValue kv = (Table.KeyValue)keyIter.seek((Object)keyPrefix);
            if (kv != null) {
                CacheValue cacheValue = this.keyTable.getCacheValue(new CacheKey(kv.getKey()));
                if (cacheValue != null) {
                    if (((String)kv.getKey()).startsWith(keyPrefix) && cacheValue.getCacheValue() != null) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (((String)kv.getKey()).startsWith(keyPrefix)) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    public List<OmBucketInfo> listBuckets(String volumeName, String startBucket, String bucketPrefix, int maxNumOfBuckets) throws IOException {
        String startKey;
        ArrayList<OmBucketInfo> result = new ArrayList<OmBucketInfo>();
        if (Strings.isNullOrEmpty((String)volumeName)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        String volumeNameBytes = this.getVolumeKey(volumeName);
        if (this.volumeTable.get((Object)volumeNameBytes) == null) {
            throw new OMException("Volume " + volumeName + " not found.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        boolean skipStartKey = false;
        if (StringUtil.isNotBlank((String)startBucket)) {
            startKey = this.getBucketKey(volumeName, startBucket);
            skipStartKey = true;
        } else {
            startKey = this.getBucketKey(volumeName, bucketPrefix);
        }
        String seekPrefix = StringUtil.isNotBlank((String)bucketPrefix) ? this.getBucketKey(volumeName, bucketPrefix) : this.getVolumeKey(volumeName + "/");
        int currentCount = 0;
        Iterator iterator = this.bucketTable.cacheIterator();
        while (currentCount < maxNumOfBuckets && iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)((CacheKey)entry.getKey()).getCacheKey();
            OmBucketInfo omBucketInfo = (OmBucketInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (omBucketInfo == null || key.equals(startKey) && skipStartKey || !key.startsWith(seekPrefix) || key.compareTo(startKey) <= 0) continue;
            result.add(omBucketInfo);
            ++currentCount;
        }
        return result;
    }

    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        Object key;
        String seekKey;
        ArrayList<OmKeyInfo> result = new ArrayList<OmKeyInfo>();
        if (maxKeys <= 0) {
            return result;
        }
        if (Strings.isNullOrEmpty((String)volumeName)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)bucketName)) {
            throw new OMException("Bucket name is required.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        String bucketNameBytes = this.getBucketKey(volumeName, bucketName);
        if (this.getBucketTable().get((Object)bucketNameBytes) == null) {
            throw new OMException("Bucket " + bucketName + " not found.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        boolean skipStartKey = false;
        if (StringUtil.isNotBlank((String)startKey)) {
            seekKey = this.getOzoneKey(volumeName, bucketName, startKey);
            skipStartKey = true;
        } else {
            seekKey = this.getOzoneKey(volumeName, bucketName, keyPrefix);
        }
        String seekPrefix = StringUtil.isNotBlank((String)keyPrefix) ? this.getOzoneKey(volumeName, bucketName, keyPrefix) : this.getBucketKey(volumeName, bucketName + "/");
        int currentCount = 0;
        TreeMap<Object, Object> cacheKeyMap = new TreeMap<Object, Object>();
        TreeSet<Object> deletedKeySet = new TreeSet<Object>();
        Iterator iterator = this.keyTable.cacheIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            key = (String)((CacheKey)entry.getKey()).getCacheKey();
            OmKeyInfo omKeyInfo = (OmKeyInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (omKeyInfo != null) {
                if (!((String)key).startsWith(seekPrefix) || ((String)key).compareTo(seekKey) < 0) continue;
                cacheKeyMap.put(key, omKeyInfo);
                continue;
            }
            deletedKeySet.add(key);
        }
        TableIterator keyIter = this.getKeyTable().iterator();
        key = null;
        try {
            Table.KeyValue kv;
            keyIter.seek((Object)seekKey);
            while (currentCount < maxKeys + 1 && keyIter.hasNext() && (kv = (Table.KeyValue)keyIter.next()) != null && ((String)kv.getKey()).startsWith(seekPrefix)) {
                if (deletedKeySet.contains(kv.getKey())) continue;
                cacheKeyMap.put(kv.getKey(), kv.getValue());
                ++currentCount;
            }
        }
        catch (Throwable throwable) {
            key = throwable;
            throw throwable;
        }
        finally {
            if (keyIter != null) {
                if (key != null) {
                    try {
                        keyIter.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)key).addSuppressed(throwable);
                    }
                } else {
                    keyIter.close();
                }
            }
        }
        currentCount = 0;
        for (Map.Entry cacheKey : cacheKeyMap.entrySet()) {
            if (((String)cacheKey.getKey()).equals(seekKey) && skipStartKey) continue;
            result.add((OmKeyInfo)cacheKey.getValue());
            if (++currentCount != maxKeys) continue;
            break;
        }
        cacheKeyMap.clear();
        deletedKeySet.clear();
        return result;
    }

    public List<RepeatedOmKeyInfo> listTrash(String volumeName, String bucketName, String startKeyName, String keyPrefix, int maxKeys) throws IOException {
        ArrayList<RepeatedOmKeyInfo> deletedKeys = new ArrayList<RepeatedOmKeyInfo>();
        return deletedKeys;
    }

    public List<OmVolumeArgs> listVolumes(String userName, String prefix, String startKey, int maxKeys) throws IOException {
        String startChar;
        if (StringUtil.isBlank((String)userName)) {
            throw new OMException("User name is required to list Volumes.", OMException.ResultCodes.USER_NOT_FOUND);
        }
        ArrayList result = Lists.newArrayList();
        List volumes = this.getVolumesByUser(userName).getVolumeNamesList();
        int index = 0;
        if (!Strings.isNullOrEmpty((String)startKey)) {
            index = volumes.indexOf(startKey.startsWith("/") ? startKey.substring(1) : startKey);
            index = index != -1 ? index + 1 : index;
        }
        String string = startChar = prefix == null ? "" : prefix;
        while (index != -1 && index < volumes.size() && result.size() < maxKeys) {
            String volumeName = (String)volumes.get(index);
            if (volumeName.startsWith(startChar)) {
                OmVolumeArgs volumeArgs = (OmVolumeArgs)this.getVolumeTable().get((Object)this.getVolumeKey(volumeName));
                if (volumeArgs == null) {
                    throw new OMException("Volume info not found for " + volumeName, OMException.ResultCodes.VOLUME_NOT_FOUND);
                }
                result.add(volumeArgs);
            }
            ++index;
        }
        return result;
    }

    private OzoneManagerProtocolProtos.UserVolumeInfo getVolumesByUser(String userNameKey) throws OMException {
        try {
            OzoneManagerProtocolProtos.UserVolumeInfo userVolInfo = (OzoneManagerProtocolProtos.UserVolumeInfo)this.getUserTable().get((Object)userNameKey);
            if (userVolInfo == null) {
                return OzoneManagerProtocolProtos.UserVolumeInfo.newBuilder().build();
            }
            return userVolInfo;
        }
        catch (IOException e) {
            throw new OMException("Unable to get volumes info by the given user, metadata might be corrupted", (Throwable)e, OMException.ResultCodes.METADATA_ERROR);
        }
    }

    public List<BlockGroup> getPendingDeletionKeys(int keyCount) throws IOException {
        ArrayList keyBlocksList = Lists.newArrayList();
        try (TableIterator keyIter = this.getDeletedTable().iterator();){
            int currentCount = 0;
            while (keyIter.hasNext() && currentCount < keyCount) {
                Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                if (kv == null) continue;
                RepeatedOmKeyInfo infoList = (RepeatedOmKeyInfo)kv.getValue();
                for (OmKeyInfo info : infoList.getOmKeyInfoList()) {
                    OmKeyLocationInfoGroup latest = info.getLatestVersionLocations();
                    List item = latest.getLocationList().stream().map(b -> new BlockID(b.getContainerID(), b.getLocalID())).collect(Collectors.toList());
                    BlockGroup keyBlocks = BlockGroup.newBuilder().setKeyName((String)kv.getKey()).addAllBlockIDs(item).build();
                    keyBlocksList.add(keyBlocks);
                    ++currentCount;
                }
            }
        }
        return keyBlocksList;
    }

    public List<BlockGroup> getExpiredOpenKeys() throws IOException {
        ArrayList keyBlocksList = Lists.newArrayList();
        return keyBlocksList;
    }

    public <KEY, VALUE> long countRowsInTable(Table<KEY, VALUE> table) throws IOException {
        long count = 0L;
        if (table != null) {
            try (TableIterator keyValueTableIterator = table.iterator();){
                while (keyValueTableIterator.hasNext()) {
                    keyValueTableIterator.next();
                    ++count;
                }
            }
        }
        return count;
    }

    public <KEY, VALUE> long countEstimatedRowsInTable(Table<KEY, VALUE> table) throws IOException {
        long count = 0L;
        if (table != null) {
            count = table.getEstimatedKeyCount();
        }
        return count;
    }

    public Set<String> getMultipartUploadKeys(String volumeName, String bucketName, String prefix) throws IOException {
        Table.KeyValue entry;
        TreeSet<String> response = new TreeSet<String>();
        TreeSet<Object> aborted = new TreeSet<Object>();
        Iterator cacheIterator = this.getMultipartInfoTable().cacheIterator();
        String prefixKey = OmMultipartUpload.getDbKey((String)volumeName, (String)bucketName, (String)prefix);
        while (cacheIterator.hasNext()) {
            Map.Entry cacheEntry = (Map.Entry)cacheIterator.next();
            if (!((String)((CacheKey)cacheEntry.getKey()).getCacheKey()).startsWith(prefixKey)) continue;
            if (((CacheValue)cacheEntry.getValue()).getCacheValue() != null) {
                response.add((String)((CacheKey)cacheEntry.getKey()).getCacheKey());
                continue;
            }
            aborted.add(((CacheKey)cacheEntry.getKey()).getCacheKey());
        }
        TableIterator iterator = this.getMultipartInfoTable().iterator();
        iterator.seek((Object)prefixKey);
        while (iterator.hasNext() && ((String)(entry = (Table.KeyValue)iterator.next()).getKey()).startsWith(prefixKey)) {
            if (aborted.contains(entry.getKey())) continue;
            response.add((String)entry.getKey());
        }
        return response;
    }

    public Table<String, S3SecretValue> getS3SecretTable() {
        return this.s3SecretTable;
    }

    protected void setStore(DBStore store) {
        this.store = store;
    }
}

