/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.BlockingService;
import com.google.protobuf.ProtocolMessageEnum;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import javax.net.SocketFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.OMCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.security.x509.certificates.utils.CertificateSignRequest;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.server.ServiceRuntimeInfoImpl;
import org.apache.hadoop.hdds.server.http.RatisDropwizardExports;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.hdds.utils.RetriableTask;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBUpdatesWrapper;
import org.apache.hadoop.hdds.utils.db.SequenceNumberNotFoundException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.BucketManagerImpl;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.KeyManagerImpl;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OMMXBean;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMPolicyProvider;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmMetricsInfo;
import org.apache.hadoop.ozone.om.OzoneManagerHttpServer;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.PrefixManagerImpl;
import org.apache.hadoop.ozone.om.S3BucketManager;
import org.apache.hadoop.ozone.om.S3BucketManagerImpl;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.S3SecretManagerImpl;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.VolumeManagerImpl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.ha.OMFailoverProxyProvider;
import org.apache.hadoop.ozone.om.ha.OMHANodeDetails;
import org.apache.hadoop.ozone.om.ha.OMNodeDetails;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerServerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OMRatisSnapshotInfo;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.snapshot.OzoneManagerSnapshotProvider;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerProtocolServerSideTranslatorPB;
import org.apache.hadoop.ozone.security.OzoneBlockTokenSecretManager;
import org.apache.hadoop.ozone.security.OzoneDelegationTokenSecretManager;
import org.apache.hadoop.ozone.security.OzoneSecurityException;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneNativeAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.ozone.util.OzoneVersionInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.KMSUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricsReporting;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.LifeCycle;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "CBLOCK", "OZONE", "HBASE"})
public final class OzoneManager
extends ServiceRuntimeInfoImpl
implements OzoneManagerServerProtocol,
OMMXBean,
Auditor {
    public static final Logger LOG = LoggerFactory.getLogger(OzoneManager.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.OMLOGGER);
    private static final String OM_DAEMON = "om";
    private static boolean securityEnabled = false;
    private OzoneDelegationTokenSecretManager delegationTokenMgr;
    private OzoneBlockTokenSecretManager blockTokenMgr;
    private CertificateClient certClient;
    private String caCertPem = null;
    private static boolean testSecureOmFlag = false;
    private final Text omRpcAddressTxt;
    private final OzoneConfiguration configuration;
    private RPC.Server omRpcServer;
    private InetSocketAddress omRpcAddress;
    private String omId;
    private OMMetadataManager metadataManager;
    private VolumeManager volumeManager;
    private BucketManager bucketManager;
    private KeyManager keyManager;
    private PrefixManagerImpl prefixManager;
    private S3BucketManager s3BucketManager;
    private final OMMetrics metrics;
    private final ProtocolMessageMetrics omClientProtocolMetrics;
    private OzoneManagerHttpServer httpServer;
    private final OMStorage omStorage;
    private final ScmBlockLocationProtocol scmBlockClient;
    private final StorageContainerLocationProtocol scmContainerClient;
    private ObjectName omInfoBeanName;
    private Timer metricsTimer;
    private ScheduleOMMetricsWriteTask scheduleOMMetricsWriteTask;
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private static final ObjectReader READER = new ObjectMapper().readerFor(OmMetricsInfo.class);
    private static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private final Runnable shutdownHook;
    private final File omMetaDir;
    private final boolean isAclEnabled;
    private IAccessAuthorizer accessAuthorizer;
    private JvmPauseMonitor jvmPauseMonitor;
    private final SecurityConfig secConfig;
    private S3SecretManager s3SecretManager;
    private volatile boolean isOmRpcServerRunning = false;
    private String omComponent;
    private OzoneManagerProtocolServerSideTranslatorPB omServerProtocol;
    private boolean isRatisEnabled;
    private OzoneManagerRatisServer omRatisServer;
    private OzoneManagerSnapshotProvider omSnapshotProvider;
    private OMNodeDetails omNodeDetails;
    private List<OMNodeDetails> peerNodes;
    private File omRatisSnapshotDir;
    private final OMRatisSnapshotInfo omRatisSnapshotInfo;
    private final Collection<String> ozAdmins;
    private KeyProviderCryptoExtension kmsProvider = null;
    private static String keyProviderUriKeyName = "hadoop.security.key.provider.path";
    private long maxUserVolumeCount;
    private final ScmClient scmClient;
    private final long scmBlockSize;
    private final int preallocateBlocksMax;
    private final boolean grpcBlockTokenEnabled;
    private final boolean useRatisForReplication;
    private boolean isNativeAuthorizerEnabled;
    private boolean createPrefixDirectories;

    private OzoneManager(OzoneConfiguration conf) throws IOException, AuthenticationException {
        super(OzoneVersionInfo.OZONE_VERSION_INFO);
        ScmInfo scmInfo;
        Preconditions.checkNotNull((Object)conf);
        this.configuration = conf;
        OMHANodeDetails omhaNodeDetails = OMHANodeDetails.loadOMHAConfig(this.configuration);
        this.peerNodes = omhaNodeDetails.getPeerNodeDetails();
        this.omNodeDetails = omhaNodeDetails.getLocalNodeDetails();
        this.omStorage = new OMStorage(conf);
        this.omId = this.omStorage.getOmId();
        if (this.omNodeDetails.getOMNodeId() == null) {
            this.omNodeDetails = OMHANodeDetails.getOMNodeDetails(conf, this.omNodeDetails.getOMServiceId(), this.omStorage.getOmId(), this.omNodeDetails.getRpcAddress(), this.omNodeDetails.getRatisPort());
        }
        OzoneManager.loginOMUserIfSecurityEnabled(conf);
        this.maxUserVolumeCount = conf.getInt("ozone.om.user.max.volume", 1024);
        Preconditions.checkArgument((this.maxUserVolumeCount > 0L ? 1 : 0) != 0, (Object)"ozone.om.user.max.volume value should be greater than zero");
        if (this.omStorage.getState() != Storage.StorageState.INITIALIZED) {
            throw new OMException("OM not initialized, current OM storage state: " + this.omStorage.getState().name() + ". Please ensure 'ozone om --init' command is executed once before starting the OM service.", OMException.ResultCodes.OM_NOT_INITIALIZED);
        }
        this.ozAdmins = conf.getTrimmedStringCollection("ozone.administrators");
        String omSPN = UserGroupInformation.getCurrentUser().getUserName();
        if (!this.ozAdmins.contains(omSPN)) {
            this.ozAdmins.add(omSPN);
        }
        this.omMetaDir = OMStorage.getOmDbDir((Configuration)this.configuration);
        this.isAclEnabled = conf.getBoolean("ozone.acl.enabled", false);
        this.scmBlockSize = (long)conf.getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
        this.preallocateBlocksMax = conf.getInt("ozone.key.preallocation.max.blocks", 64);
        this.grpcBlockTokenEnabled = conf.getBoolean("hdds.block.token.enabled", false);
        this.useRatisForReplication = conf.getBoolean("dfs.container.ratis.enabled", false);
        this.isRatisEnabled = this.configuration.getBoolean("ozone.om.ratis.enable", false);
        this.createPrefixDirectories = conf.getBoolean("ozone.manager.fs.prefix.create", OMConfigKeys.OZONE_FS_CREATE_PREFIX_DIRECTORIES_DEFAULT.booleanValue());
        InetSocketAddress omNodeRpcAddr = this.omNodeDetails.getRpcAddress();
        this.omRpcAddressTxt = new Text(this.omNodeDetails.getRpcAddressString());
        this.scmContainerClient = OzoneManager.getScmContainerClient(this.configuration);
        this.scmBlockClient = OzoneManager.getScmBlockClient(this.configuration);
        this.scmClient = new ScmClient(this.scmBlockClient, this.scmContainerClient);
        if (!(testSecureOmFlag || (scmInfo = OzoneManager.getScmInfo(this.configuration)).getClusterId().equals(this.omStorage.getClusterID()) && scmInfo.getScmId().equals(this.omStorage.getScmId()))) {
            throw new OMException("SCM version info mismatch.", OMException.ResultCodes.SCM_VERSION_MISMATCH_ERROR);
        }
        RPC.setProtocolEngine((Configuration)this.configuration, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        this.secConfig = new SecurityConfig((Configuration)this.configuration);
        try {
            this.kmsProvider = this.createKeyProviderExt(this.configuration);
        }
        catch (IOException ioe) {
            this.kmsProvider = null;
            LOG.error("Fail to create Key Provider");
        }
        if (this.secConfig.isSecurityEnabled()) {
            this.omComponent = "om-" + this.omId;
            if (this.omStorage.getOmCertSerialId() == null) {
                throw new RuntimeException("OzoneManager started in secure mode but doesn't have SCM signed certificate.");
            }
            this.certClient = new OMCertificateClient(new SecurityConfig((Configuration)conf), this.omStorage.getOmCertSerialId());
        }
        if (this.secConfig.isBlockTokenEnabled()) {
            this.blockTokenMgr = this.createBlockTokenSecretManager(this.configuration);
        }
        this.instantiateServices();
        this.omRatisSnapshotInfo = new OMRatisSnapshotInfo(this.omStorage.getCurrentDir());
        this.initializeRatisServer();
        if (this.isRatisEnabled) {
            String omRatisDirectory = OzoneManagerRatisServer.getOMRatisDirectory((Configuration)this.configuration);
            if (omRatisDirectory == null || omRatisDirectory.isEmpty()) {
                throw new IllegalArgumentException("ozone.metadata.dirs must be defined.");
            }
            OmUtils.createOMDir((String)omRatisDirectory);
            this.omRatisSnapshotDir = OmUtils.createOMDir((String)OzoneManagerRatisServer.getOMRatisSnapshotDirectory((Configuration)this.configuration));
            if (this.peerNodes != null && !this.peerNodes.isEmpty()) {
                this.omSnapshotProvider = new OzoneManagerSnapshotProvider((Configuration)this.configuration, this.omRatisSnapshotDir, this.peerNodes);
            }
        }
        this.metrics = OMMetrics.create();
        this.omClientProtocolMetrics = ProtocolMessageMetrics.create((String)"OmClientProtocol", (String)"Ozone Manager RPC endpoint", (ProtocolMessageEnum[])OzoneManagerProtocolProtos.Type.values());
        this.omRpcServer = this.getRpcServer(this.configuration);
        this.omRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)this.configuration, (String)"ozone.om.address", (InetSocketAddress)omNodeRpcAddr, (RPC.Server)this.omRpcServer);
        this.shutdownHook = () -> this.saveOmMetrics();
        ShutdownHookManager.get().addShutdownHook(this.shutdownHook, 30);
    }

    public boolean createPrefixEntries() {
        return this.createPrefixDirectories;
    }

    private void instantiateServices() throws IOException {
        this.metadataManager = new OmMetadataManagerImpl(this.configuration);
        this.volumeManager = new VolumeManagerImpl(this.metadataManager, this.configuration);
        this.bucketManager = new BucketManagerImpl(this.metadataManager, this.getKmsProvider(), this.isRatisEnabled);
        this.s3BucketManager = new S3BucketManagerImpl(this.configuration, this.metadataManager, this.volumeManager, this.bucketManager);
        if (this.secConfig.isSecurityEnabled()) {
            this.s3SecretManager = new S3SecretManagerImpl(this.configuration, this.metadataManager);
            this.delegationTokenMgr = this.createDelegationTokenSecretManager(this.configuration);
        }
        this.prefixManager = new PrefixManagerImpl(this.metadataManager, this.isRatisEnabled);
        this.keyManager = new KeyManagerImpl(this, this.scmClient, this.configuration, this.omStorage.getOmId());
        if (this.isAclEnabled) {
            this.accessAuthorizer = this.getACLAuthorizerInstance(this.configuration);
            if (this.accessAuthorizer instanceof OzoneNativeAuthorizer) {
                OzoneNativeAuthorizer authorizer = (OzoneNativeAuthorizer)this.accessAuthorizer;
                this.isNativeAuthorizerEnabled = true;
                authorizer.setVolumeManager(this.volumeManager);
                authorizer.setBucketManager(this.bucketManager);
                authorizer.setKeyManager(this.keyManager);
                authorizer.setPrefixManager(this.prefixManager);
            }
        } else {
            this.accessAuthorizer = null;
        }
    }

    public boolean shouldUseRatis() {
        return this.useRatisForReplication;
    }

    public ScmClient getScmClient() {
        return this.scmClient;
    }

    public OzoneBlockTokenSecretManager getBlockTokenSecretManager() {
        return this.blockTokenMgr;
    }

    public long getScmBlockSize() {
        return this.scmBlockSize;
    }

    public int getPreallocateBlocksMax() {
        return this.preallocateBlocksMax;
    }

    public boolean isGrpcBlockTokenEnabled() {
        return this.grpcBlockTokenEnabled;
    }

    private KeyProviderCryptoExtension createKeyProviderExt(OzoneConfiguration conf) throws IOException {
        KeyProvider keyProvider = KMSUtil.createKeyProvider((Configuration)conf, (String)keyProviderUriKeyName);
        if (keyProvider == null) {
            return null;
        }
        KeyProviderCryptoExtension cryptoProvider = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
        return cryptoProvider;
    }

    private IAccessAuthorizer getACLAuthorizerInstance(OzoneConfiguration conf) {
        Class clazz = conf.getClass("ozone.acl.authorizer.class", OzoneAccessAuthorizer.class, IAccessAuthorizer.class);
        return (IAccessAuthorizer)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
    }

    public void close() throws IOException {
        this.stop();
    }

    private void saveOmMetrics() {
        try {
            boolean success;
            Files.createDirectories(this.getTempMetricsStorageFile().getParentFile().toPath(), new FileAttribute[0]);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getTempMetricsStorageFile()), "UTF-8"));){
                OmMetricsInfo metricsInfo = new OmMetricsInfo();
                metricsInfo.setNumKeys(this.metrics.getNumKeys());
                WRITER.writeValue((Writer)writer, (Object)metricsInfo);
                success = true;
            }
            if (success) {
                Files.move(this.getTempMetricsStorageFile().toPath(), this.getMetricsStorageFile().toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            LOG.error("Unable to write the om Metrics file", (Throwable)ex);
        }
    }

    private File getTempMetricsStorageFile() {
        return new File(this.omMetaDir, "omMetrics.tmp");
    }

    private File getMetricsStorageFile() {
        return new File(this.omMetaDir, "omMetrics");
    }

    private OzoneDelegationTokenSecretManager createDelegationTokenSecretManager(OzoneConfiguration conf) throws IOException {
        long tokenRemoverScanInterval = conf.getTimeDuration("ozone.manager.delegation.remover.scan.interval", 3600000L, TimeUnit.MILLISECONDS);
        long tokenMaxLifetime = conf.getTimeDuration("ozone.manager.delegation.token.max-lifetime", 604800000L, TimeUnit.MILLISECONDS);
        long tokenRenewInterval = conf.getTimeDuration("ozone.manager.delegation.token.renew-interval", 86400000L, TimeUnit.MILLISECONDS);
        return new OzoneDelegationTokenSecretManager(conf, tokenMaxLifetime, tokenRenewInterval, tokenRemoverScanInterval, this.omRpcAddressTxt, this.s3SecretManager, this.certClient);
    }

    private OzoneBlockTokenSecretManager createBlockTokenSecretManager(OzoneConfiguration conf) {
        long expiryTime = conf.getTimeDuration("hdds.block.token.expiry.time", "1d", TimeUnit.MILLISECONDS);
        if (testSecureOmFlag) {
            return new OzoneBlockTokenSecretManager(this.secConfig, expiryTime, "1");
        }
        Objects.requireNonNull(this.certClient);
        return new OzoneBlockTokenSecretManager(this.secConfig, expiryTime, this.certClient.getCertificate().getSerialNumber().toString());
    }

    private void stopSecretManager() {
        if (this.blockTokenMgr != null) {
            LOG.info("Stopping OM block token manager.");
            try {
                this.blockTokenMgr.stop();
            }
            catch (IOException e) {
                LOG.error("Failed to stop block token manager", (Throwable)e);
            }
        }
        if (this.delegationTokenMgr != null) {
            LOG.info("Stopping OM delegation token secret manager.");
            try {
                this.delegationTokenMgr.stop();
            }
            catch (IOException e) {
                LOG.error("Failed to stop delegation token manager", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public void startSecretManager() {
        try {
            this.readKeyPair();
        }
        catch (OzoneSecurityException e) {
            LOG.error("Unable to read key pair for OM.", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (this.secConfig.isBlockTokenEnabled() && this.blockTokenMgr != null) {
            try {
                LOG.info("Starting OM block token secret manager");
                this.blockTokenMgr.start(this.certClient);
            }
            catch (IOException e) {
                LOG.error("Error starting block token secret manager.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (this.delegationTokenMgr != null) {
            try {
                LOG.info("Starting OM delegation token secret manager");
                this.delegationTokenMgr.start(this.certClient);
            }
            catch (IOException e) {
                LOG.error("Error starting delegation token secret manager.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void setCertClient(CertificateClient certClient) {
        this.certClient = certClient;
    }

    private void readKeyPair() throws OzoneSecurityException {
        try {
            LOG.info("Reading keypair and certificate from file system.");
            PublicKey pubKey = this.certClient.getPublicKey();
            PrivateKey pvtKey = this.certClient.getPrivateKey();
            Objects.requireNonNull(pubKey);
            Objects.requireNonNull(pvtKey);
            Objects.requireNonNull(this.certClient.getCertificate());
        }
        catch (Exception e) {
            throw new OzoneSecurityException("Error reading keypair & certificate OzoneManager.", (Throwable)e, OzoneSecurityException.ResultCodes.OM_PUBLIC_PRIVATE_KEY_FILE_NOT_EXIST);
        }
    }

    private static void loginOMUser(OzoneConfiguration conf) throws IOException, AuthenticationException {
        if (SecurityUtil.getAuthenticationMethod((Configuration)conf).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ozone security is enabled. Attempting login for OM user. Principal: {}, keytab: {}", (Object)conf.get("ozone.om.kerberos.principal"), (Object)conf.get("ozone.om.kerberos.keytab.file"));
            }
        } else {
            throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)conf) + " authentication method not supported. OM user login failed.");
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        InetSocketAddress socAddr = OmUtils.getOmAddress((Configuration)conf);
        SecurityUtil.login((Configuration)conf, (String)"ozone.om.kerberos.keytab.file", (String)"ozone.om.kerberos.principal", (String)socAddr.getHostName());
        LOG.info("Ozone Manager login successful.");
    }

    private static ScmBlockLocationProtocol getScmBlockClient(OzoneConfiguration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ScmBlockLocationProtocolPB.class, ProtobufRpcEngine.class);
        long scmVersion = RPC.getProtocolVersion(ScmBlockLocationProtocolPB.class);
        InetSocketAddress scmBlockAddress = HddsUtils.getScmAddressForBlockClients((Configuration)conf);
        ScmBlockLocationProtocolClientSideTranslatorPB scmBlockLocationClient = new ScmBlockLocationProtocolClientSideTranslatorPB((ScmBlockLocationProtocolPB)RPC.getProxy(ScmBlockLocationProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmBlockAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        return (ScmBlockLocationProtocol)TracingUtil.createProxy((Object)scmBlockLocationClient, ScmBlockLocationProtocol.class, (Configuration)conf);
    }

    private static StorageContainerLocationProtocol getScmContainerClient(OzoneConfiguration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        long scmVersion = RPC.getProtocolVersion(StorageContainerLocationProtocolPB.class);
        InetSocketAddress scmAddr = HddsUtils.getScmAddressForClients((Configuration)conf);
        StorageContainerLocationProtocol scmContainerClient = (StorageContainerLocationProtocol)TracingUtil.createProxy((Object)new StorageContainerLocationProtocolClientSideTranslatorPB((StorageContainerLocationProtocolPB)RPC.getProxy(StorageContainerLocationProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmAddr, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf))), StorageContainerLocationProtocol.class, (Configuration)conf);
        return scmContainerClient;
    }

    private RPC.Server startRpcServer(OzoneConfiguration conf, InetSocketAddress addr, Class<?> protocol, BlockingService instance, int handlerCount) throws IOException {
        RPC.Server rpcServer = new RPC.Builder((Configuration)conf).setProtocol(protocol).setInstance((Object)instance).setBindAddress(addr.getHostString()).setPort(addr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager((SecretManager)this.delegationTokenMgr).build();
        DFSUtil.addPBProtocol((Configuration)conf, protocol, (BlockingService)instance, (RPC.Server)rpcServer);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            rpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)OMPolicyProvider.getInstance());
        }
        return rpcServer;
    }

    private static boolean isOzoneSecurityEnabled() {
        return securityEnabled;
    }

    public static OzoneManager createOm(OzoneConfiguration conf) throws IOException, AuthenticationException {
        return new OzoneManager(conf);
    }

    private static void loginOMUserIfSecurityEnabled(OzoneConfiguration conf) throws IOException, AuthenticationException {
        securityEnabled = OzoneSecurityUtil.isSecurityEnabled((Configuration)conf);
        if (securityEnabled) {
            OzoneManager.loginOMUser(conf);
        }
    }

    @VisibleForTesting
    public static boolean omInit(OzoneConfiguration conf) throws IOException, AuthenticationException {
        OMHANodeDetails.loadOMHAConfig(conf);
        OzoneManager.loginOMUserIfSecurityEnabled(conf);
        OMStorage omStorage = new OMStorage(conf);
        Storage.StorageState state = omStorage.getState();
        if (state != Storage.StorageState.INITIALIZED) {
            try {
                ScmInfo scmInfo = OzoneManager.getScmInfo(conf);
                String clusterId = scmInfo.getClusterId();
                String scmId = scmInfo.getScmId();
                if (clusterId == null || clusterId.isEmpty()) {
                    throw new IOException("Invalid Cluster ID");
                }
                if (scmId == null || scmId.isEmpty()) {
                    throw new IOException("Invalid SCM ID");
                }
                omStorage.setClusterId(clusterId);
                omStorage.setScmId(scmId);
                if (OzoneSecurityUtil.isSecurityEnabled((Configuration)conf)) {
                    OzoneManager.initializeSecurity(conf, omStorage);
                }
                omStorage.initialize();
                System.out.println("OM initialization succeeded.Current cluster id for sd=" + omStorage.getStorageDir() + ";cid=" + omStorage.getClusterID());
                return true;
            }
            catch (IOException ioe) {
                LOG.error("Could not initialize OM version file", (Throwable)ioe);
                return false;
            }
        }
        if (OzoneSecurityUtil.isSecurityEnabled((Configuration)conf) && omStorage.getOmCertSerialId() == null) {
            LOG.info("OM storage is already initialized. Initializing security");
            OzoneManager.initializeSecurity(conf, omStorage);
            omStorage.persistCurrentState();
        }
        System.out.println("OM already initialized.Reusing existing cluster id for sd=" + omStorage.getStorageDir() + ";cid=" + omStorage.getClusterID());
        return true;
    }

    @VisibleForTesting
    public static void initializeSecurity(OzoneConfiguration conf, OMStorage omStore) throws IOException {
        LOG.info("Initializing secure OzoneManager.");
        OMCertificateClient certClient = new OMCertificateClient(new SecurityConfig((Configuration)conf), omStore.getOmCertSerialId());
        CertificateClient.InitResponse response = certClient.init();
        LOG.info("Init response: {}", (Object)response);
        switch (response) {
            case SUCCESS: {
                LOG.info("Initialization successful.");
                break;
            }
            case GETCERT: {
                OzoneManager.getSCMSignedCert((CertificateClient)certClient, conf, omStore);
                LOG.info("Successfully stored SCM signed certificate.");
                break;
            }
            case FAILURE: {
                LOG.error("OM security initialization failed.");
                throw new RuntimeException("OM security initialization failed.");
            }
            case RECOVER: {
                LOG.error("OM security initialization failed. OM certificate is missing.");
                throw new RuntimeException("OM security initialization failed.");
            }
            default: {
                LOG.error("OM security initialization failed. Init response: {}", (Object)response);
                throw new RuntimeException("OM security initialization failed.");
            }
        }
    }

    private static ScmInfo getScmInfo(OzoneConfiguration conf) throws IOException {
        try {
            RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)10, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            RetriableTask retriable = new RetriableTask(retryPolicy, "OM#getScmInfo", () -> OzoneManager.getScmBlockClient(conf).getScmInfo());
            return (ScmInfo)retriable.call();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to get SCM info", e);
        }
    }

    private static String buildRpcServerStartMessage(String description, InetSocketAddress addr) {
        return addr != null ? String.format("%s is listening at %s", description, addr.toString()) : String.format("%s not started", description);
    }

    @VisibleForTesting
    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    @VisibleForTesting
    public ScmInfo getScmInfo() throws IOException {
        return this.scmBlockClient.getScmInfo();
    }

    @VisibleForTesting
    public OMStorage getOmStorage() {
        return this.omStorage;
    }

    @VisibleForTesting
    public OzoneManagerRatisServer getOmRatisServer() {
        return this.omRatisServer;
    }

    @VisibleForTesting
    public OzoneManagerSnapshotProvider getOmSnapshotProvider() {
        return this.omSnapshotProvider;
    }

    @VisibleForTesting
    public InetSocketAddress getOmRpcServerAddr() {
        return this.omRpcAddress;
    }

    @VisibleForTesting
    public LifeCycle.State getOmRatisServerState() {
        if (this.omRatisServer == null) {
            return null;
        }
        return this.omRatisServer.getServerState();
    }

    @VisibleForTesting
    public KeyProviderCryptoExtension getKmsProvider() {
        return this.kmsProvider;
    }

    public PrefixManager getPrefixManager() {
        return this.prefixManager;
    }

    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public OzoneBlockTokenSecretManager getBlockTokenMgr() {
        return this.blockTokenMgr;
    }

    public OzoneManagerProtocolServerSideTranslatorPB getOmServerProtocol() {
        return this.omServerProtocol;
    }

    public OMMetrics getMetrics() {
        return this.metrics;
    }

    public void start() throws IOException {
        this.omClientProtocolMetrics.register();
        HddsServerUtil.initializeMetrics((OzoneConfiguration)this.configuration, (String)"OzoneManager");
        if (this.configuration.getBoolean("ozone.om.ratis.enable", false)) {
            MetricRegistries.global().addReporterRegistration(MetricsReporting.jmxReporter());
            MetricRegistries.global().addReporterRegistration(registry -> CollectorRegistry.defaultRegistry.register((Collector)new RatisDropwizardExports(registry.getDropWizardMetricRegistry())));
        }
        LOG.info(OzoneManager.buildRpcServerStartMessage("OzoneManager RPC server", this.omRpcAddress));
        if (this.omRatisServer != null) {
            this.omRatisServer.start();
        }
        this.metadataManager.start(this.configuration);
        this.startSecretManagerIfNecessary();
        if (this.certClient != null) {
            this.caCertPem = CertificateCodec.getPEMEncodedString((X509Certificate)this.certClient.getCACertificate());
        }
        this.metrics.setNumVolumes(this.metadataManager.countRowsInTable(this.metadataManager.getVolumeTable()));
        this.metrics.setNumBuckets(this.metadataManager.countRowsInTable(this.metadataManager.getBucketTable()));
        if (this.getMetricsStorageFile().exists()) {
            OmMetricsInfo metricsInfo = (OmMetricsInfo)READER.readValue(this.getMetricsStorageFile());
            this.metrics.setNumKeys(metricsInfo.getNumKeys());
        }
        long period = this.configuration.getTimeDuration("ozone.om.save.metrics.interval", "5m", TimeUnit.MILLISECONDS);
        this.scheduleOMMetricsWriteTask = new ScheduleOMMetricsWriteTask();
        this.metricsTimer = new Timer();
        this.metricsTimer.schedule((TimerTask)this.scheduleOMMetricsWriteTask, 0L, period);
        this.keyManager.start(this.configuration);
        this.omRpcServer.start();
        this.isOmRpcServerRunning = true;
        try {
            this.httpServer = new OzoneManagerHttpServer((Configuration)this.configuration, this);
            this.httpServer.start();
        }
        catch (Exception ex) {
            LOG.error("OM HttpServer failed to start.", (Throwable)ex);
        }
        this.registerMXBean();
        this.setStartTime();
    }

    public void restart() throws IOException {
        LOG.info(OzoneManager.buildRpcServerStartMessage("OzoneManager RPC server", this.omRpcAddress));
        HddsServerUtil.initializeMetrics((OzoneConfiguration)this.configuration, (String)"OzoneManager");
        this.instantiateServices();
        this.startSecretManagerIfNecessary();
        this.metrics.setNumVolumes(this.metadataManager.countRowsInTable(this.metadataManager.getVolumeTable()));
        this.metrics.setNumBuckets(this.metadataManager.countRowsInTable(this.metadataManager.getBucketTable()));
        if (this.getMetricsStorageFile().exists()) {
            OmMetricsInfo metricsInfo = (OmMetricsInfo)READER.readValue(this.getMetricsStorageFile());
            this.metrics.setNumKeys(metricsInfo.getNumKeys());
        }
        long period = this.configuration.getTimeDuration("ozone.om.save.metrics.interval", "5m", TimeUnit.MILLISECONDS);
        this.scheduleOMMetricsWriteTask = new ScheduleOMMetricsWriteTask();
        this.metricsTimer = new Timer();
        this.metricsTimer.schedule((TimerTask)this.scheduleOMMetricsWriteTask, 0L, period);
        this.omRpcServer = this.getRpcServer(this.configuration);
        this.omRpcServer.start();
        this.isOmRpcServerRunning = true;
        this.initializeRatisServer();
        if (this.omRatisServer != null) {
            this.omRatisServer.start();
        }
        try {
            this.httpServer = new OzoneManagerHttpServer((Configuration)this.configuration, this);
            this.httpServer.start();
        }
        catch (Exception ex) {
            LOG.error("OM HttpServer failed to start.", (Throwable)ex);
        }
        this.registerMXBean();
        this.jvmPauseMonitor = new JvmPauseMonitor();
        this.jvmPauseMonitor.init((Configuration)this.configuration);
        this.jvmPauseMonitor.start();
        this.setStartTime();
    }

    private RPC.Server getRpcServer(OzoneConfiguration conf) throws IOException {
        if (this.isOmRpcServerRunning) {
            return this.omRpcServer;
        }
        InetSocketAddress omNodeRpcAddr = OmUtils.getOmAddress((Configuration)conf);
        int handlerCount = conf.getInt("ozone.om.handler.count.key", 20);
        RPC.setProtocolEngine((Configuration)this.configuration, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        this.omServerProtocol = new OzoneManagerProtocolServerSideTranslatorPB(this, this.omRatisServer, this.omClientProtocolMetrics, this.isRatisEnabled);
        BlockingService omService = OzoneManagerProtocolProtos.OzoneManagerService.newReflectiveBlockingService((OzoneManagerProtocolProtos.OzoneManagerService.BlockingInterface)this.omServerProtocol);
        return this.startRpcServer(this.configuration, omNodeRpcAddr, OzoneManagerProtocolPB.class, omService, handlerCount);
    }

    private void initializeRatisServer() throws IOException {
        if (this.isRatisEnabled) {
            if (this.omRatisServer == null) {
                this.omRatisServer = OzoneManagerRatisServer.newOMRatisServer((Configuration)this.configuration, this, this.omNodeDetails, this.peerNodes);
            }
            LOG.info("OzoneManager Ratis server initialized at port {}", (Object)this.omRatisServer.getServerPort());
        } else {
            this.omRatisServer = null;
        }
    }

    public OMRatisSnapshotInfo getSnapshotInfo() {
        return this.omRatisSnapshotInfo;
    }

    @VisibleForTesting
    public long getRatisSnapshotIndex() {
        return this.omRatisSnapshotInfo.getIndex();
    }

    public TermIndex saveRatisSnapshot() throws IOException {
        TermIndex snapshotIndex = this.omRatisServer.getLastAppliedTermIndex();
        this.metadataManager.getStore().flush();
        this.omRatisSnapshotInfo.saveRatisSnapshotToDisk(snapshotIndex);
        return snapshotIndex;
    }

    public void stop() {
        try {
            if (this.metricsTimer != null) {
                this.metricsTimer.cancel();
                this.metricsTimer = null;
                this.scheduleOMMetricsWriteTask = null;
            }
            this.omRpcServer.stop();
            if (!this.isRatisEnabled) {
                this.omServerProtocol.stop();
            }
            if (this.omRatisServer != null) {
                this.omRatisServer.stop();
                this.omRatisServer = null;
            }
            this.isOmRpcServerRunning = false;
            this.keyManager.stop();
            this.stopSecretManager();
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
            this.metadataManager.stop();
            this.metrics.unRegister();
            this.omClientProtocolMetrics.unregister();
            this.unregisterMXBean();
            if (this.jvmPauseMonitor != null) {
                this.jvmPauseMonitor.stop();
            }
        }
        catch (Exception e) {
            LOG.error("OzoneManager stop failed.", (Throwable)e);
        }
    }

    public void join() {
        try {
            this.omRpcServer.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during OzoneManager join.", (Throwable)e);
        }
    }

    private void startSecretManagerIfNecessary() {
        boolean shouldRun = OzoneManager.isOzoneSecurityEnabled();
        if (shouldRun) {
            boolean running;
            boolean bl = running = this.delegationTokenMgr.isRunning() && this.blockTokenMgr.isRunning();
            if (!running) {
                this.startSecretManager();
            }
        }
    }

    private static void getSCMSignedCert(CertificateClient client, OzoneConfiguration config, OMStorage omStore) throws IOException {
        CertificateSignRequest.Builder builder = client.getCSRBuilder();
        KeyPair keyPair = new KeyPair(client.getPublicKey(), client.getPrivateKey());
        InetSocketAddress omRpcAdd = OmUtils.getOmAddress((Configuration)config);
        if (omRpcAdd == null || omRpcAdd.getAddress() == null) {
            LOG.error("Incorrect om rpc address. omRpcAdd:{}", (Object)omRpcAdd);
            throw new RuntimeException("Can't get SCM signed certificate. omRpcAdd: " + omRpcAdd);
        }
        String hostname = omRpcAdd.getAddress().getHostName();
        String ip = omRpcAdd.getAddress().getHostAddress();
        String subject = UserGroupInformation.getCurrentUser().getShortUserName() + "@" + hostname;
        builder.setCA(Boolean.valueOf(false)).setKey(keyPair).setConfiguration((Configuration)config).setScmID(omStore.getScmId()).setClusterID(omStore.getClusterID()).setSubject(subject).addIpAddress(ip);
        OMHANodeDetails haOMHANodeDetails = OMHANodeDetails.loadOMHAConfig(config);
        String serviceName = haOMHANodeDetails.getLocalNodeDetails().getOMServiceId();
        if (!StringUtils.isEmpty((CharSequence)serviceName)) {
            builder.addServiceName(serviceName);
        }
        LOG.info("Creating csr for OM->dns:{},ip:{},scmId:{},clusterId:{},subject:{}", new Object[]{hostname, ip, omStore.getScmId(), omStore.getClusterID(), subject});
        HddsProtos.OzoneManagerDetailsProto.Builder omDetailsProtoBuilder = HddsProtos.OzoneManagerDetailsProto.newBuilder().setHostName(omRpcAdd.getHostName()).setIpAddress(ip).setUuid(omStore.getOmId()).addPorts(HddsProtos.Port.newBuilder().setName("RPC").setValue(omRpcAdd.getPort()).build());
        PKCS10CertificationRequest csr = builder.build();
        HddsProtos.OzoneManagerDetailsProto omDetailsProto = omDetailsProtoBuilder.build();
        LOG.info("OzoneManager ports added:{}", (Object)omDetailsProto.getPortsList());
        SCMSecurityProtocolClientSideTranslatorPB secureScmClient = HddsServerUtil.getScmSecurityClient((OzoneConfiguration)config);
        SCMSecurityProtocolProtos.SCMGetCertResponseProto response = secureScmClient.getOMCertChain(omDetailsProto, CertificateSignRequest.getEncodedString((PKCS10CertificationRequest)csr));
        String pemEncodedCert = response.getX509Certificate();
        try {
            if (!response.hasX509CACertificate()) {
                throw new RuntimeException("Unable to retrieve OM certificate chain");
            }
            String pemEncodedRootCert = response.getX509CACertificate();
            client.storeCertificate(pemEncodedRootCert, true, true);
            client.storeCertificate(pemEncodedCert, true);
            omStore.setOmCertSerialId(CertificateCodec.getX509Certificate((String)pemEncodedCert).getSerialNumber().toString());
        }
        catch (IOException | CertificateException e) {
            LOG.error("Error while storing SCM signed certificate.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = OzoneManager.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws OMException {
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new OMException("Delegation Token can be issued only with kerberos or web authentication", OMException.ResultCodes.INVALID_AUTH_METHOD);
            }
            if (this.delegationTokenMgr == null || !this.delegationTokenMgr.isRunning()) {
                LOG.warn("trying to get DT with no secret manager running in OM.");
                return null;
            }
            UserGroupInformation ugi = OzoneManager.getRemoteUser();
            String user = ugi.getUserName();
            Text owner = new Text(user);
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            return this.delegationTokenMgr.createToken(owner, renewer, realUser);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            LOG.error("Get Delegation token failed, cause: {}", (Object)ex.getMessage());
            throw new OMException("Get Delegation token failed.", (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        long expiryTime;
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new OMException("Delegation Token can be renewed only with kerberos or web authentication", OMException.ResultCodes.INVALID_AUTH_METHOD);
            }
            String renewer = OzoneManager.getRemoteUser().getShortUserName();
            expiryTime = this.delegationTokenMgr.renewToken(token, renewer);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            OzoneTokenIdentifier id = null;
            try {
                id = OzoneTokenIdentifier.readProtoBuf((byte[])token.getIdentifier());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOG.error("Delegation token renewal failed for dt id: {}, cause: {}", (Object)id, (Object)ex.getMessage());
            throw new OMException("Delegation token renewal failed for dt: " + token, (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
        return expiryTime;
    }

    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        OzoneTokenIdentifier id = null;
        try {
            String canceller = OzoneManager.getRemoteUser().getUserName();
            id = this.delegationTokenMgr.cancelToken(token, canceller);
            LOG.trace("Delegation token cancelled for dt: {}", (Object)id);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            LOG.error("Delegation token cancellation failed for dt id: {}, cause: {}", id, (Object)ex.getMessage());
            throw new OMException("Delegation token renewal failed for dt: " + token, (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    public void createVolume(OmVolumeArgs args) throws IOException {
        try {
            this.metrics.incNumVolumeCreates();
            this.checkAdmin();
            this.volumeManager.createVolume(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_VOLUME, args == null ? null : args.toAuditMap()));
            this.metrics.incNumVolumes();
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeCreateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_VOLUME, args == null ? null : args.toAuditMap(), ex));
            throw ex;
        }
    }

    private void checkAcls(OzoneObj.ResourceType resType, OzoneObj.StoreType store, IAccessAuthorizer.ACLType acl, String vol, String bucket, String key) throws OMException {
        this.checkAcls(resType, store, acl, vol, bucket, key, ProtobufRpcEngine.Server.getRemoteUser(), ProtobufRpcEngine.Server.getRemoteIp(), ProtobufRpcEngine.Server.getRemoteIp().getHostName());
    }

    public void checkAcls(OzoneObj.ResourceType resType, OzoneObj.StoreType storeType, IAccessAuthorizer.ACLType aclType, String vol, String bucket, String key, UserGroupInformation ugi, InetAddress remoteAddress, String hostName) throws OMException {
        RequestContext context;
        OzoneObjInfo obj = OzoneObjInfo.Builder.newBuilder().setResType(resType).setStoreType(storeType).setVolumeName(vol).setBucketName(bucket).setKeyName(key).build();
        if (!this.accessAuthorizer.checkAccess((IOzoneObj)obj, context = RequestContext.newBuilder().setClientUgi(ugi).setIp(remoteAddress).setHost(hostName).setAclType(IAccessAuthorizer.ACLIdentityType.USER).setAclRights(aclType).build())) {
            LOG.warn("User {} doesn't have {} permission to access {} /{}/{}/{}", new Object[]{ugi.getUserName(), aclType, resType, vol, bucket, key});
            throw new OMException("User " + ugi.getUserName() + " doesn't have " + aclType + " permission to access " + resType, OMException.ResultCodes.PERMISSION_DENIED);
        }
    }

    public boolean getAclsEnabled() {
        return this.isAclEnabled;
    }

    public void setOwner(String volume, String owner) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, null, null);
        }
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("owner", owner);
        try {
            this.metrics.incNumVolumeUpdates();
            this.volumeManager.setOwner(volume, owner);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.SET_OWNER, auditMap));
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeUpdateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.SET_OWNER, auditMap, ex));
            throw ex;
        }
    }

    public void setQuota(String volume, long quota) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volume, null, null);
        }
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("quota", String.valueOf(quota));
        try {
            this.metrics.incNumVolumeUpdates();
            this.volumeManager.setQuota(volume, quota);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.SET_QUOTA, auditMap));
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeUpdateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.SET_QUOTA, auditMap, ex));
            throw ex;
        }
    }

    public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volume, null, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("userAcl", userAcl == null ? null : userAcl.getName());
        try {
            this.metrics.incNumVolumeCheckAccesses();
            boolean bl = this.volumeManager.checkVolumeAccess(volume, userAcl);
            return bl;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeCheckAccessFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CHECK_VOLUME_ACCESS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CHECK_VOLUME_ACCESS, auditMap));
            }
        }
    }

    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volume, null, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        try {
            this.metrics.incNumVolumeInfos();
            OmVolumeArgs omVolumeArgs = this.volumeManager.getVolumeInfo(volume);
            return omVolumeArgs;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeInfoFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_VOLUME, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_VOLUME, auditMap));
            }
        }
    }

    public void deleteVolume(String volume) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, volume, null, null);
            }
            this.metrics.incNumVolumeDeletes();
            this.volumeManager.deleteVolume(volume);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_VOLUME, this.buildAuditMap(volume)));
            this.metrics.decNumVolumes();
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_VOLUME, this.buildAuditMap(volume), ex));
            throw ex;
        }
    }

    public List<OmVolumeArgs> listVolumeByUser(String userName, String prefix, String prevKey, int maxKeys) throws IOException {
        UserGroupInformation remoteUserUgi;
        if (this.isAclEnabled && (remoteUserUgi = ProtobufRpcEngine.Server.getRemoteUser()) == null) {
            LOG.error("Rpc user UGI is null. Authorization failed.");
            throw new OMException("Rpc user UGI is null. Authorization failed.", OMException.ResultCodes.PERMISSION_DENIED);
        }
        boolean auditSuccess = true;
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("prevKey", prevKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("username", userName);
        try {
            this.metrics.incNumVolumeLists();
            List<OmVolumeArgs> list = this.volumeManager.listVolumes(userName, prefix, prevKey, maxKeys);
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_VOLUMES, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_VOLUMES, auditMap));
            }
        }
    }

    public List<OmVolumeArgs> listAllVolumes(String prefix, String prevKey, int maxKeys) throws IOException {
        boolean auditSuccess = true;
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("prevKey", prevKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("username", null);
        try {
            this.metrics.incNumVolumeLists();
            this.checkAdmin();
            List<OmVolumeArgs> list = this.volumeManager.listVolumes(null, prefix, prevKey, maxKeys);
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_VOLUMES, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_VOLUMES, auditMap));
            }
        }
    }

    private void checkAdmin() throws OMException {
        if (this.isAclEnabled && !this.ozAdmins.contains("*") && !this.ozAdmins.contains(ProtobufRpcEngine.Server.getRemoteUser().getUserName())) {
            LOG.error("Only admin users are authorized to create or list Ozone volumes. User :{} is not an admin.", (Object)ProtobufRpcEngine.Server.getRemoteUser().getUserName());
            throw new OMException("Only admin users are authorized to create or list Ozone volumes.", OMException.ResultCodes.PERMISSION_DENIED);
        }
    }

    public void createBucket(OmBucketInfo bucketInfo) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, bucketInfo.getVolumeName(), bucketInfo.getBucketName(), null);
            }
            this.metrics.incNumBucketCreates();
            this.bucketManager.createBucket(bucketInfo);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_BUCKET, bucketInfo == null ? null : bucketInfo.toAuditMap()));
            this.metrics.incNumBuckets();
        }
        catch (Exception ex) {
            this.metrics.incNumBucketCreateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_BUCKET, bucketInfo == null ? null : bucketInfo.toAuditMap(), ex));
            throw ex;
        }
    }

    public List<OmBucketInfo> listBuckets(String volumeName, String startKey, String prefix, int maxNumOfBuckets) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeName, null, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("startKey", startKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxNumOfBuckets", String.valueOf(maxNumOfBuckets));
        try {
            this.metrics.incNumBucketLists();
            List<OmBucketInfo> list = this.bucketManager.listBuckets(volumeName, startKey, prefix, maxNumOfBuckets);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumBucketListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_BUCKETS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_BUCKETS, auditMap));
            }
        }
    }

    public OmBucketInfo getBucketInfo(String volume, String bucket) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volume, bucket, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("bucket", bucket);
        try {
            this.metrics.incNumBucketInfos();
            OmBucketInfo omBucketInfo = this.bucketManager.getBucketInfo(volume, bucket);
            return omBucketInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumBucketInfoFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_BUCKET, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_BUCKET, auditMap));
            }
        }
    }

    public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        OpenKeySession openKeySession;
        block9: {
            if (this.isAclEnabled) {
                try {
                    this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
                }
                catch (OMException ex) {
                    if (ex.getResult().equals((Object)OMException.ResultCodes.KEY_NOT_FOUND)) {
                        this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
                    }
                    throw ex;
                }
            }
            boolean auditSuccess = true;
            try {
                this.metrics.incNumKeyAllocates();
                openKeySession = this.keyManager.openKey(args);
                if (!auditSuccess) break block9;
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.ALLOCATE_KEY, args == null ? null : args.toAuditMap()));
            }
            catch (Exception ex) {
                try {
                    this.metrics.incNumKeyAllocateFails();
                    auditSuccess = false;
                    AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.ALLOCATE_KEY, args == null ? null : args.toAuditMap(), ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.ALLOCATE_KEY, args == null ? null : args.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return openKeySession;
    }

    public void commitKey(OmKeyArgs args, long clientID) throws IOException {
        if (this.isAclEnabled) {
            try {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
            }
            catch (OMException ex) {
                if (ex.getResult().equals((Object)OMException.ResultCodes.KEY_NOT_FOUND)) {
                    this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
                }
                throw ex;
            }
        }
        Map<String, String> auditMap = args == null ? new LinkedHashMap() : args.toAuditMap();
        auditMap.put("clientID", String.valueOf(clientID));
        try {
            this.metrics.incNumKeyCommits();
            this.keyManager.commitKey(args, clientID);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMMIT_KEY, auditMap));
            if (args != null && args.getLocationInfoList() != null && args.getLocationInfoList().size() > 0 && args.getLocationInfoList().get(0) != null && ((OmKeyLocationInfo)args.getLocationInfoList().get(0)).getCreateVersion() == 0L) {
                this.metrics.incNumKeys();
            }
        }
        catch (Exception ex) {
            this.metrics.incNumKeyCommitFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.COMMIT_KEY, auditMap, ex));
            throw ex;
        }
    }

    public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientID, ExcludeList excludeList) throws IOException {
        if (this.isAclEnabled) {
            try {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
            }
            catch (OMException ex) {
                if (ex.getResult().equals((Object)OMException.ResultCodes.KEY_NOT_FOUND)) {
                    this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
                }
                throw ex;
            }
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = args == null ? new LinkedHashMap() : args.toAuditMap();
        auditMap.put("clientID", String.valueOf(clientID));
        try {
            this.metrics.incNumBlockAllocateCalls();
            OmKeyLocationInfo omKeyLocationInfo = this.keyManager.allocateBlock(args, clientID, excludeList);
            return omKeyLocationInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumBlockAllocateCallFails();
            auditSuccess = false;
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap));
            }
        }
    }

    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        OmKeyInfo omKeyInfo;
        block6: {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, args.getVolumeName(), args.getBucketName(), args.getKeyName());
            }
            boolean auditSuccess = true;
            try {
                this.metrics.incNumKeyLookups();
                omKeyInfo = this.keyManager.lookupKey(args, OzoneManager.getClientAddress());
                if (!auditSuccess) break block6;
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_KEY, args == null ? null : args.toAuditMap()));
            }
            catch (Exception ex) {
                try {
                    this.metrics.incNumKeyLookupFails();
                    auditSuccess = false;
                    AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_KEY, args == null ? null : args.toAuditMap(), ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_KEY, args == null ? null : args.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return omKeyInfo;
    }

    public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
        }
        Map<String, String> auditMap = args == null ? new LinkedHashMap() : args.toAuditMap();
        auditMap.put("toKeyName", toKeyName);
        try {
            this.metrics.incNumKeyRenames();
            this.keyManager.renameKey(args, toKeyName);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.RENAME_KEY, auditMap));
        }
        catch (IOException e) {
            this.metrics.incNumKeyRenameFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.RENAME_KEY, auditMap, e));
            throw e;
        }
    }

    public void deleteKey(OmKeyArgs args) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
            }
            this.metrics.incNumKeyDeletes();
            this.keyManager.deleteKey(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_KEY, args == null ? null : args.toAuditMap()));
            this.metrics.decNumKeys();
        }
        catch (Exception ex) {
            this.metrics.incNumKeyDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_KEY, args == null ? null : args.toAuditMap(), ex));
            throw ex;
        }
    }

    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeName, bucketName, keyPrefix);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("bucket", bucketName);
        auditMap.put("startKey", startKey);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("keyPrefix", keyPrefix);
        try {
            this.metrics.incNumKeyLists();
            List<OmKeyInfo> list = this.keyManager.listKeys(volumeName, bucketName, startKey, keyPrefix, maxKeys);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumKeyListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_KEYS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_KEYS, auditMap));
            }
        }
    }

    public List<RepeatedOmKeyInfo> listTrash(String volumeName, String bucketName, String startKeyName, String keyPrefix, int maxKeys) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeName, bucketName, keyPrefix);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("bucket", bucketName);
        auditMap.put("startKey", startKeyName);
        auditMap.put("keyPrefix", keyPrefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        try {
            this.metrics.incNumTrashKeyLists();
            List<RepeatedOmKeyInfo> list = this.keyManager.listTrash(volumeName, bucketName, startKeyName, keyPrefix, maxKeys);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumTrashKeyListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_TRASH, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_TRASH, auditMap));
            }
        }
    }

    public boolean recoverTrash(String volumeName, String bucketName, String keyName, String destinationBucket) throws IOException {
        boolean recoverOperation = true;
        return recoverOperation;
    }

    public void setBucketProperty(OmBucketArgs args) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), null);
        }
        try {
            this.metrics.incNumBucketUpdates();
            this.bucketManager.setBucketProperty(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.UPDATE_BUCKET, args == null ? null : args.toAuditMap()));
        }
        catch (Exception ex) {
            this.metrics.incNumBucketUpdateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.UPDATE_BUCKET, args == null ? null : args.toAuditMap(), ex));
            throw ex;
        }
    }

    public void deleteBucket(String volume, String bucket) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volume, bucket, null);
        }
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("bucket", bucket);
        try {
            this.metrics.incNumBucketDeletes();
            this.bucketManager.deleteBucket(volume, bucket);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_BUCKET, auditMap));
            this.metrics.decNumBuckets();
        }
        catch (Exception ex) {
            this.metrics.incNumBucketDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_BUCKET, auditMap, ex));
            throw ex;
        }
    }

    private Map<String, String> buildAuditMap(String volume) {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", volume);
        return auditMap;
    }

    public AuditLogger getAuditLogger() {
        return AUDIT;
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.SUCCESS).build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.FAILURE).withException(throwable).build();
    }

    private void registerMXBean() {
        HashMap<String, String> jmxProperties = new HashMap<String, String>();
        jmxProperties.put("component", "ServerRuntime");
        this.omInfoBeanName = HddsUtils.registerWithJmxProperties((String)"OzoneManager", (String)"OzoneManagerInfo", jmxProperties, (Object)this);
    }

    private void unregisterMXBean() {
        if (this.omInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.omInfoBeanName);
            this.omInfoBeanName = null;
        }
    }

    private static String getClientAddress() {
        String clientMachine = Server.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    @Override
    public String getRpcPort() {
        return "" + this.omRpcAddress.getPort();
    }

    @VisibleForTesting
    public OzoneManagerHttpServer getHttpServer() {
        return this.httpServer;
    }

    public List<ServiceInfo> getServiceList() throws IOException {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        ServiceInfo.Builder omServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.OM).setHostname(this.omRpcAddress.getHostName()).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(this.omRpcAddress.getPort()).build());
        if (this.httpServer.getHttpAddress() != null) {
            omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTP).setValue(this.httpServer.getHttpAddress().getPort()).build());
        }
        if (this.httpServer.getHttpsAddress() != null) {
            omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTPS).setValue(this.httpServer.getHttpsAddress().getPort()).build());
        }
        OzoneManagerProtocolProtos.OMRoleInfo omRole = OzoneManagerProtocolProtos.OMRoleInfo.newBuilder().setNodeId(this.getOMNodeId()).setServerRole(RaftProtos.RaftPeerRole.LEADER.name()).build();
        omServiceInfoBuilder.setOmRoleInfo(omRole);
        if (this.isRatisEnabled) {
            if (this.omRatisServer != null) {
                omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RATIS).setValue(this.omNodeDetails.getRatisPort()).build());
            }
            for (OMNodeDetails peerNode : this.peerNodes) {
                ServiceInfo.Builder peerOmServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.OM).setHostname(peerNode.getAddress().getHostName()).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(peerNode.getRpcPort()).build());
                OzoneManagerProtocolProtos.OMRoleInfo peerOmRole = OzoneManagerProtocolProtos.OMRoleInfo.newBuilder().setNodeId(peerNode.getOMNodeId()).setServerRole(RaftProtos.RaftPeerRole.FOLLOWER.name()).build();
                peerOmServiceInfoBuilder.setOmRoleInfo(peerOmRole);
                services.add(peerOmServiceInfoBuilder.build());
            }
        }
        services.add(omServiceInfoBuilder.build());
        InetSocketAddress scmAddr = HddsUtils.getScmAddressForClients((Configuration)this.configuration);
        ServiceInfo.Builder scmServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.SCM).setHostname(scmAddr.getHostName()).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(scmAddr.getPort()).build());
        services.add(scmServiceInfoBuilder.build());
        List nodes = this.scmContainerClient.queryNode(HddsProtos.NodeState.HEALTHY, HddsProtos.QueryScope.CLUSTER, "");
        for (HddsProtos.Node node : nodes) {
            HddsProtos.DatanodeDetailsProto datanode = node.getNodeID();
            ServiceInfo.Builder dnServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.DATANODE).setHostname(datanode.getHostName());
            if (DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)datanode).getPort(DatanodeDetails.Port.Name.REST) != null) {
                dnServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTP).setValue(DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)datanode).getPort(DatanodeDetails.Port.Name.REST).getValue().intValue()).build());
            }
            services.add(dnServiceInfoBuilder.build());
        }
        this.metrics.incNumGetServiceLists();
        return services;
    }

    public ServiceInfoEx getServiceInfo() throws IOException {
        return new ServiceInfoEx(this.getServiceList(), this.caCertPem);
    }

    public void createS3Bucket(String userName, String s3BucketName) throws IOException {
        boolean acquiredS3Lock;
        block10: {
            acquiredS3Lock = false;
            boolean acquiredVolumeLock = false;
            try {
                this.metrics.incNumBucketCreates();
                acquiredS3Lock = this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
                try {
                    acquiredVolumeLock = this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{this.s3BucketManager.formatOzoneVolumeName(userName)});
                    boolean newVolumeCreate = this.s3BucketManager.createOzoneVolumeIfNeeded(userName);
                    if (newVolumeCreate) {
                        this.metrics.incNumVolumeCreates();
                        this.metrics.incNumVolumes();
                    }
                }
                catch (IOException ex) {
                    this.metrics.incNumVolumeCreates();
                    this.metrics.incNumVolumeCreateFails();
                    throw ex;
                }
                this.s3BucketManager.createS3Bucket(userName, s3BucketName);
                this.metrics.incNumBuckets();
                if (!acquiredVolumeLock) break block10;
            }
            catch (IOException ex) {
                try {
                    this.metrics.incNumBucketCreateFails();
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (acquiredVolumeLock) {
                        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{this.s3BucketManager.formatOzoneVolumeName(userName)});
                    }
                    if (acquiredS3Lock) {
                        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
                    }
                    throw throwable;
                }
            }
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{this.s3BucketManager.formatOzoneVolumeName(userName)});
        }
        if (acquiredS3Lock) {
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
        }
    }

    public void deleteS3Bucket(String s3BucketName) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.S3, IAccessAuthorizer.ACLType.DELETE, this.getS3VolumeName(), s3BucketName, null);
            }
            this.metrics.incNumBucketDeletes();
            this.s3BucketManager.deleteS3Bucket(s3BucketName);
            this.metrics.decNumBuckets();
        }
        catch (IOException ex) {
            this.metrics.incNumBucketDeleteFails();
        }
    }

    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        UserGroupInformation user = ProtobufRpcEngine.Server.getRemoteUser();
        if (!user.getUserName().equals(kerberosID)) {
            throw new OMException("User mismatch. Requested user name is mismatched " + kerberosID + ", with current user " + user.getUserName(), OMException.ResultCodes.USER_MISMATCH);
        }
        return this.s3SecretManager.getS3Secret(kerberosID);
    }

    public String getOzoneBucketMapping(String s3BucketName) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.S3, IAccessAuthorizer.ACLType.READ, this.getS3VolumeName(), s3BucketName, null);
        }
        return this.s3BucketManager.getOzoneBucketMapping(s3BucketName);
    }

    private String getS3VolumeName() {
        return this.s3BucketManager.formatOzoneVolumeName(DigestUtils.md5Hex((String)ProtobufRpcEngine.Server.getRemoteUser().getUserName().toLowerCase()));
    }

    public List<OmBucketInfo> listS3Buckets(String userName, String startKey, String prefix, int maxNumOfBuckets) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.S3, IAccessAuthorizer.ACLType.LIST, this.s3BucketManager.getOzoneVolumeNameForUser(userName), null, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(userName);
        auditMap.put("startKey", startKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxNumOfBuckets", String.valueOf(maxNumOfBuckets));
        try {
            this.metrics.incNumListS3Buckets();
            String volumeName = this.s3BucketManager.getOzoneVolumeNameForUser(userName);
            List<OmBucketInfo> list = this.bucketManager.listBuckets(volumeName, startKey, prefix, maxNumOfBuckets);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumListS3BucketsFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_S3BUCKETS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_S3BUCKETS, auditMap));
            }
        }
    }

    public OmMultipartInfo initiateMultipartUpload(OmKeyArgs keyArgs) throws IOException {
        OmMultipartInfo multipartInfo;
        this.metrics.incNumInitiateMultipartUploads();
        try {
            multipartInfo = this.keyManager.initiateMultipartUpload(keyArgs);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, keyArgs == null ? null : keyArgs.toAuditMap()));
        }
        catch (IOException ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, keyArgs == null ? null : keyArgs.toAuditMap(), ex));
            this.metrics.incNumInitiateMultipartUploadFails();
            throw ex;
        }
        return multipartInfo;
    }

    public OmMultipartCommitUploadPartInfo commitMultipartUploadPart(OmKeyArgs keyArgs, long clientID) throws IOException {
        OmMultipartCommitUploadPartInfo commitUploadPartInfo;
        block5: {
            boolean auditSuccess = false;
            this.metrics.incNumCommitMultipartUploadParts();
            try {
                commitUploadPartInfo = this.keyManager.commitMultipartUploadPart(keyArgs, clientID);
                auditSuccess = true;
                if (!auditSuccess) break block5;
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMMIT_MULTIPART_UPLOAD_PARTKEY, keyArgs == null ? null : keyArgs.toAuditMap()));
            }
            catch (IOException ex) {
                try {
                    AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, keyArgs == null ? null : keyArgs.toAuditMap(), ex));
                    this.metrics.incNumCommitMultipartUploadPartFails();
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMMIT_MULTIPART_UPLOAD_PARTKEY, keyArgs == null ? null : keyArgs.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return commitUploadPartInfo;
    }

    public OmMultipartUploadCompleteInfo completeMultipartUpload(OmKeyArgs omKeyArgs, OmMultipartUploadCompleteList multipartUploadList) throws IOException {
        this.metrics.incNumCompleteMultipartUploads();
        Map<String, String> auditMap = omKeyArgs == null ? new LinkedHashMap() : omKeyArgs.toAuditMap();
        auditMap.put("multipartList", multipartUploadList.getMultipartMap().toString());
        try {
            OmMultipartUploadCompleteInfo omMultipartUploadCompleteInfo = this.keyManager.completeMultipartUpload(omKeyArgs, multipartUploadList);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap));
            return omMultipartUploadCompleteInfo;
        }
        catch (IOException ex) {
            this.metrics.incNumCompleteMultipartUploadFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap, ex));
            throw ex;
        }
    }

    public void abortMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        LinkedHashMap<String, String> auditMap = omKeyArgs == null ? new LinkedHashMap() : omKeyArgs.toAuditMap();
        this.metrics.incNumAbortMultipartUploads();
        try {
            this.keyManager.abortMultipartUpload(omKeyArgs);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap));
        }
        catch (IOException ex) {
            this.metrics.incNumAbortMultipartUploadFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap, ex));
            throw ex;
        }
    }

    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put("volume", volumeName);
        auditMap.put("bucket", bucketName);
        auditMap.put("key", keyName);
        auditMap.put("uploadID", uploadID);
        auditMap.put("partNumberMarker", Integer.toString(partNumberMarker));
        auditMap.put("maxParts", Integer.toString(maxParts));
        this.metrics.incNumListMultipartUploadParts();
        try {
            OmMultipartUploadListParts omMultipartUploadListParts = this.keyManager.listParts(volumeName, bucketName, keyName, uploadID, partNumberMarker, maxParts);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_MULTIPART_UPLOAD_PARTS, auditMap));
            return omMultipartUploadListParts;
        }
        catch (IOException ex) {
            this.metrics.incNumListMultipartUploadPartFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_MULTIPART_UPLOAD_PARTS, auditMap, ex));
            throw ex;
        }
    }

    public OmMultipartUploadList listMultipartUploads(String volumeName, String bucketName, String prefix) throws IOException {
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put("volume", volumeName);
        auditMap.put("bucket", bucketName);
        auditMap.put("prefix", prefix);
        this.metrics.incNumListMultipartUploads();
        try {
            OmMultipartUploadList omMultipartUploadList = this.keyManager.listMultipartUploads(volumeName, bucketName, prefix);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_MULTIPART_UPLOADS, auditMap));
            return omMultipartUploadList;
        }
        catch (IOException ex) {
            this.metrics.incNumListMultipartUploadFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_MULTIPART_UPLOADS, auditMap, ex));
            throw ex;
        }
    }

    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        OzoneFileStatus ozoneFileStatus;
        block6: {
            if (this.isAclEnabled) {
                this.checkAcls(this.getResourceType(args), OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, args.getVolumeName(), args.getBucketName(), args.getKeyName());
            }
            boolean auditSuccess = true;
            try {
                this.metrics.incNumGetFileStatus();
                ozoneFileStatus = this.keyManager.getFileStatus(args);
                if (!auditSuccess) break block6;
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.GET_FILE_STATUS, args == null ? null : args.toAuditMap()));
            }
            catch (IOException ex) {
                try {
                    this.metrics.incNumGetFileStatusFails();
                    auditSuccess = false;
                    AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.GET_FILE_STATUS, args == null ? null : args.toAuditMap(), ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.GET_FILE_STATUS, args == null ? null : args.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return ozoneFileStatus;
    }

    private OzoneObj.ResourceType getResourceType(OmKeyArgs args) {
        if (args.getKeyName() == null || args.getKeyName().length() == 0) {
            return OzoneObj.ResourceType.BUCKET;
        }
        return OzoneObj.ResourceType.KEY;
    }

    public void createDirectory(OmKeyArgs args) throws IOException {
        block6: {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
            }
            boolean auditSuccess = true;
            try {
                this.metrics.incNumCreateDirectory();
                this.keyManager.createDirectory(args);
                if (!auditSuccess) break block6;
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_DIRECTORY, args == null ? null : args.toAuditMap()));
            }
            catch (IOException ex) {
                try {
                    this.metrics.incNumCreateDirectoryFails();
                    auditSuccess = false;
                    AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_DIRECTORY, args == null ? null : args.toAuditMap(), ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_DIRECTORY, args == null ? null : args.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
    }

    public OpenKeySession createFile(OmKeyArgs args, boolean overWrite, boolean recursive) throws IOException {
        OpenKeySession openKeySession;
        block6: {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), null);
            }
            boolean auditSuccess = true;
            try {
                this.metrics.incNumCreateFile();
                openKeySession = this.keyManager.createFile(args, overWrite, recursive);
                if (!auditSuccess) break block6;
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_FILE, args == null ? null : args.toAuditMap()));
            }
            catch (Exception ex) {
                try {
                    this.metrics.incNumCreateFileFails();
                    auditSuccess = false;
                    AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_FILE, args == null ? null : args.toAuditMap(), ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_FILE, args == null ? null : args.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return openKeySession;
    }

    public OmKeyInfo lookupFile(OmKeyArgs args) throws IOException {
        OmKeyInfo omKeyInfo;
        block6: {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, args.getVolumeName(), args.getBucketName(), args.getKeyName());
            }
            boolean auditSuccess = true;
            try {
                this.metrics.incNumLookupFile();
                omKeyInfo = this.keyManager.lookupFile(args, OzoneManager.getClientAddress());
                if (!auditSuccess) break block6;
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LOOKUP_FILE, args == null ? null : args.toAuditMap()));
            }
            catch (Exception ex) {
                try {
                    this.metrics.incNumLookupFileFails();
                    auditSuccess = false;
                    AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LOOKUP_FILE, args == null ? null : args.toAuditMap(), ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LOOKUP_FILE, args == null ? null : args.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return omKeyInfo;
    }

    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries) throws IOException {
        List<OzoneFileStatus> list;
        block6: {
            if (this.isAclEnabled) {
                this.checkAcls(this.getResourceType(args), OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, args.getVolumeName(), args.getBucketName(), args.getKeyName());
            }
            boolean auditSuccess = true;
            try {
                this.metrics.incNumListStatus();
                list = this.keyManager.listStatus(args, recursive, startKey, numEntries);
                if (!auditSuccess) break block6;
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_STATUS, args == null ? null : args.toAuditMap()));
            }
            catch (Exception ex) {
                try {
                    this.metrics.incNumListStatusFails();
                    auditSuccess = false;
                    AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_STATUS, args == null ? null : args.toAuditMap(), ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_STATUS, args == null ? null : args.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return list;
    }

    private void auditAcl(OzoneObj ozoneObj, List<OzoneAcl> ozoneAcl, OMAction omAction, Exception ex) {
        Map auditMap = ozoneObj.toAuditMap();
        if (ozoneAcl != null) {
            auditMap.put("acl", ozoneAcl.toString());
        }
        if (ex == null) {
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)omAction, auditMap));
        } else {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)omAction, auditMap, ex));
        }
    }

    /*
     * Exception decompiling
     */
    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        boolean auditSuccess = true;
        try {
            if (this.isAclEnabled) {
                this.checkAcls(obj.getResourceType(), obj.getStoreType(), IAccessAuthorizer.ACLType.WRITE_ACL, obj.getVolumeName(), obj.getBucketName(), obj.getKeyName());
            }
            switch (obj.getResourceType()) {
                case VOLUME: {
                    boolean bl = this.volumeManager.setAcl(obj, acls);
                    return bl;
                }
                case BUCKET: {
                    boolean bl = this.bucketManager.setAcl(obj, acls);
                    return bl;
                }
                case KEY: {
                    boolean bl = this.keyManager.setAcl(obj, acls);
                    return bl;
                }
                case PREFIX: {
                    boolean bl = this.prefixManager.setAcl(obj, acls);
                    return bl;
                }
            }
            try {
                throw new OMException("Unexpected resource type: " + obj.getResourceType(), OMException.ResultCodes.INVALID_REQUEST);
            }
            catch (Exception ex) {
                auditSuccess = false;
                this.auditAcl(obj, acls, OMAction.SET_ACL, ex);
                throw ex;
            }
        }
        finally {
            if (auditSuccess) {
                this.auditAcl(obj, acls, OMAction.SET_ACL, null);
            }
        }
    }

    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        boolean auditSuccess = true;
        try {
            if (this.isAclEnabled) {
                this.checkAcls(obj.getResourceType(), obj.getStoreType(), IAccessAuthorizer.ACLType.READ_ACL, obj.getVolumeName(), obj.getBucketName(), obj.getKeyName());
            }
            switch (obj.getResourceType()) {
                case VOLUME: {
                    List<OzoneAcl> list = this.volumeManager.getAcl(obj);
                    return list;
                }
                case BUCKET: {
                    List<OzoneAcl> list = this.bucketManager.getAcl(obj);
                    return list;
                }
                case KEY: {
                    List<OzoneAcl> list = this.keyManager.getAcl(obj);
                    return list;
                }
                case PREFIX: {
                    List<OzoneAcl> list = this.prefixManager.getAcl(obj);
                    return list;
                }
            }
            try {
                throw new OMException("Unexpected resource type: " + obj.getResourceType(), OMException.ResultCodes.INVALID_REQUEST);
            }
            catch (Exception ex) {
                auditSuccess = false;
                this.auditAcl(obj, null, OMAction.GET_ACL, ex);
                throw ex;
            }
        }
        finally {
            if (auditSuccess) {
                this.auditAcl(obj, null, OMAction.GET_ACL, null);
            }
        }
    }

    public TermIndex installSnapshot(String leaderId) {
        File dbBackup;
        if (this.omSnapshotProvider == null) {
            LOG.error("OM Snapshot Provider is not configured as there are no peer nodes.");
            return null;
        }
        DBCheckpoint omDBcheckpoint = this.getDBCheckpointFromLeader(leaderId);
        Path newDBlocation = omDBcheckpoint.getCheckpointLocation();
        long lastAppliedIndex = this.omRatisServer.getLastAppliedTermIndex().getIndex();
        long checkpointSnapshotIndex = omDBcheckpoint.getRatisSnapshotIndex();
        long checkpointSnapshotTermIndex = omDBcheckpoint.getRatisSnapshotTerm();
        if (checkpointSnapshotIndex <= lastAppliedIndex) {
            LOG.error("Failed to install checkpoint from OM leader: {}. The last applied index: {} is greater than or equal to the checkpoint's snapshot index: {}. Deleting the downloaded checkpoint {}", new Object[]{leaderId, lastAppliedIndex, checkpointSnapshotIndex, newDBlocation});
            try {
                FileUtils.deleteFully((Path)newDBlocation);
            }
            catch (IOException e) {
                LOG.error("Failed to fully delete the downloaded DB checkpoint {} from OM leader {}.", new Object[]{newDBlocation, leaderId, e});
            }
            return null;
        }
        this.omRatisServer.getOmStateMachine().pause();
        try {
            dbBackup = this.replaceOMDBWithCheckpoint(lastAppliedIndex, newDBlocation);
        }
        catch (Exception e) {
            LOG.error("OM DB checkpoint replacement with new downloaded checkpoint failed.", (Throwable)e);
            return null;
        }
        try {
            this.reloadOMState(checkpointSnapshotIndex, checkpointSnapshotTermIndex);
            this.omRatisServer.getOmStateMachine().unpause(checkpointSnapshotIndex, checkpointSnapshotTermIndex);
        }
        catch (IOException e) {
            LOG.error("Failed to reload OM state with new DB checkpoint.", (Throwable)e);
            return null;
        }
        try {
            FileUtils.deleteFully((File)dbBackup);
        }
        catch (IOException e) {
            LOG.error("Failed to delete the backup of the original DB {}", (Object)dbBackup);
        }
        TermIndex newTermIndex = TermIndex.newTermIndex((long)checkpointSnapshotTermIndex, (long)checkpointSnapshotIndex);
        return newTermIndex;
    }

    private DBCheckpoint getDBCheckpointFromLeader(String leaderId) {
        LOG.info("Downloading checkpoint from leader OM {} and reloading state from the checkpoint.", (Object)leaderId);
        try {
            return this.omSnapshotProvider.getOzoneManagerDBSnapshot(leaderId);
        }
        catch (IOException e) {
            LOG.error("Failed to download checkpoint from OM leader {}", (Object)leaderId, (Object)e);
            return null;
        }
    }

    File replaceOMDBWithCheckpoint(long lastAppliedIndex, Path checkpointPath) throws Exception {
        DBStore store = this.metadataManager.getStore();
        store.close();
        File db = store.getDbLocation();
        String dbBackupName = "om.db.backup." + lastAppliedIndex + "_" + System.currentTimeMillis();
        File dbBackup = new File(db.getParentFile(), dbBackupName);
        try {
            Files.move(db.toPath(), dbBackup.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            LOG.error("Failed to create a backup of the current DB. Aborting snapshot installation.");
            throw e;
        }
        try {
            Files.move(checkpointPath, db.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            LOG.error("Failed to move downloaded DB checkpoint {} to metadata directory {}. Resetting to original DB.", (Object)checkpointPath, (Object)db.toPath());
            Files.move(dbBackup.toPath(), db.toPath(), new CopyOption[0]);
            throw e;
        }
        return dbBackup;
    }

    void reloadOMState(long newSnapshotIndex, long newSnapShotTermIndex) throws IOException {
        this.instantiateServices();
        this.metadataManager.start(this.configuration);
        this.keyManager.start(this.configuration);
        this.metrics.setNumVolumes(this.metadataManager.countRowsInTable(this.metadataManager.getVolumeTable()));
        this.metrics.setNumBuckets(this.metadataManager.countRowsInTable(this.metadataManager.getBucketTable()));
        this.metrics.setNumKeys(this.metadataManager.countEstimatedRowsInTable(this.metadataManager.getKeyTable()));
        Files.deleteIfExists(this.getMetricsStorageFile().toPath());
        this.saveOmMetrics();
        this.omRatisSnapshotInfo.saveRatisSnapshotToDisk(TermIndex.newTermIndex((long)newSnapShotTermIndex, (long)newSnapshotIndex));
    }

    public static Logger getLogger() {
        return LOG;
    }

    public OzoneConfiguration getConfiguration() {
        return this.configuration;
    }

    public static void setTestSecureOmFlag(boolean testSecureOmFlag) {
        OzoneManager.testSecureOmFlag = testSecureOmFlag;
    }

    public String getOMNodeId() {
        return this.omNodeDetails.getOMNodeId();
    }

    public String getOMServiceId() {
        return this.omNodeDetails.getOMServiceId();
    }

    @VisibleForTesting
    public List<OMNodeDetails> getPeerNodes() {
        return this.peerNodes;
    }

    @VisibleForTesting
    public CertificateClient getCertificateClient() {
        return this.certClient;
    }

    public String getComponent() {
        return this.omComponent;
    }

    public OMFailoverProxyProvider getOMFailoverProxyProvider() {
        return null;
    }

    public long getMaxUserVolumeCount() {
        return this.maxUserVolumeCount;
    }

    public boolean isLeader() {
        return this.isRatisEnabled ? this.omRatisServer.isLeader() : true;
    }

    public boolean isRatisEnabled() {
        return this.isRatisEnabled;
    }

    public DBUpdatesWrapper getDBUpdates(OzoneManagerProtocolProtos.DBUpdatesRequest dbUpdatesRequest) throws SequenceNumberNotFoundException {
        return this.metadataManager.getStore().getUpdatesSince(dbUpdatesRequest.getSequenceNumber());
    }

    public OzoneDelegationTokenSecretManager getDelegationTokenMgr() {
        return this.delegationTokenMgr;
    }

    public Collection<String> getOzoneAdmins() {
        return this.ozAdmins;
    }

    public boolean isNativeAuthorizerEnabled() {
        return this.isNativeAuthorizerEnabled;
    }

    private class ScheduleOMMetricsWriteTask
    extends TimerTask {
        private ScheduleOMMetricsWriteTask() {
        }

        @Override
        public void run() {
            OzoneManager.this.saveOmMetrics();
        }
    }
}

