/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.server.http.BaseHttpServer;
import org.apache.hadoop.ozone.om.OMDBCheckpointServlet;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ServiceListJSONServlet;

public class OzoneManagerHttpServer
extends BaseHttpServer {
    public OzoneManagerHttpServer(Configuration conf, OzoneManager om) throws IOException {
        super(conf, "ozoneManager");
        this.addServlet("serviceList", "/serviceList", ServiceListJSONServlet.class);
        this.addServlet("dbCheckpoint", "/dbCheckpoint", OMDBCheckpointServlet.class);
        this.getWebAppContext().setAttribute("ozone.om", (Object)om);
    }

    protected String getHttpAddressKey() {
        return "ozone.om.http-address";
    }

    protected String getHttpBindHostKey() {
        return "ozone.om.http-bind-host";
    }

    protected String getHttpsAddressKey() {
        return "ozone.om.https-address";
    }

    protected String getHttpsBindHostKey() {
        return "ozone.om.https-bind-host";
    }

    protected String getBindHostDefault() {
        return "0.0.0.0";
    }

    protected int getHttpBindPortDefault() {
        return 9874;
    }

    protected int getHttpsBindPortDefault() {
        return 9875;
    }

    protected String getKeytabFile() {
        return "ozone.om.http.kerberos.keytab";
    }

    protected String getSpnegoPrincipal() {
        return "ozone.om.http.kerberos.principal";
    }

    protected String getEnabledKey() {
        return "ozone.om.http.enabled";
    }
}

