/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeManagerImpl
implements VolumeManager {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeManagerImpl.class);
    private final OMMetadataManager metadataManager;
    private final int maxUserVolumeCount;
    private final boolean aclEnabled;

    public VolumeManagerImpl(OMMetadataManager metadataManager, OzoneConfiguration conf) {
        this.metadataManager = metadataManager;
        this.maxUserVolumeCount = conf.getInt("ozone.om.user.max.volume", 1024);
        this.aclEnabled = conf.getBoolean("ozone.acl.enabled", false);
    }

    private OzoneManagerProtocolProtos.UserVolumeInfo addVolumeToOwnerList(String volume, String owner) throws IOException {
        String dbUserKey = this.metadataManager.getUserKey(owner);
        OzoneManagerProtocolProtos.UserVolumeInfo volumeList = (OzoneManagerProtocolProtos.UserVolumeInfo)this.metadataManager.getUserTable().get((Object)dbUserKey);
        ArrayList<String> prevVolList = new ArrayList<String>();
        if (volumeList != null) {
            prevVolList.addAll(volumeList.getVolumeNamesList());
        }
        if (prevVolList.size() >= this.maxUserVolumeCount) {
            LOG.debug("Too many volumes for user:{}", (Object)owner);
            throw new OMException("Too many volumes for user:" + owner, OMException.ResultCodes.USER_TOO_MANY_VOLUMES);
        }
        prevVolList.add(volume);
        OzoneManagerProtocolProtos.UserVolumeInfo newVolList = OzoneManagerProtocolProtos.UserVolumeInfo.newBuilder().addAllVolumeNames(prevVolList).build();
        return newVolList;
    }

    private OzoneManagerProtocolProtos.UserVolumeInfo delVolumeFromOwnerList(String volume, String owner) throws IOException {
        OzoneManagerProtocolProtos.UserVolumeInfo volumeList = (OzoneManagerProtocolProtos.UserVolumeInfo)this.metadataManager.getUserTable().get((Object)owner);
        ArrayList prevVolList = new ArrayList();
        if (volumeList == null) {
            LOG.debug("volume:{} not found for user:{}", (Object)volume, (Object)owner);
            throw new OMException(OMException.ResultCodes.USER_NOT_FOUND);
        }
        prevVolList.addAll(volumeList.getVolumeNamesList());
        prevVolList.remove(volume);
        OzoneManagerProtocolProtos.UserVolumeInfo newVolList = OzoneManagerProtocolProtos.UserVolumeInfo.newBuilder().addAllVolumeNames(prevVolList).build();
        return newVolList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createVolume(OmVolumeArgs omVolumeArgs) throws IOException {
        block6: {
            Preconditions.checkNotNull((Object)omVolumeArgs);
            boolean acquiredUserLock = false;
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{omVolumeArgs.getVolume()});
            try {
                acquiredUserLock = this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{omVolumeArgs.getOwnerName()});
                String dbVolumeKey = this.metadataManager.getVolumeKey(omVolumeArgs.getVolume());
                String dbUserKey = this.metadataManager.getUserKey(omVolumeArgs.getOwnerName());
                OmVolumeArgs volumeInfo = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
                if (volumeInfo != null) {
                    LOG.debug("volume:{} already exists", (Object)omVolumeArgs.getVolume());
                    throw new OMException(OMException.ResultCodes.VOLUME_ALREADY_EXISTS);
                }
                OzoneManagerProtocolProtos.UserVolumeInfo volumeList = this.addVolumeToOwnerList(omVolumeArgs.getVolume(), omVolumeArgs.getOwnerName());
                omVolumeArgs.setCreationTime(System.currentTimeMillis());
                this.createVolumeCommitToDB(omVolumeArgs, volumeList, dbVolumeKey, dbUserKey);
                LOG.debug("created volume:{} user:{}", (Object)omVolumeArgs.getVolume(), (Object)omVolumeArgs.getOwnerName());
                if (!acquiredUserLock) break block6;
            }
            catch (IOException ex) {
                try {
                    if (ex instanceof OMException) throw ex;
                    LOG.error("Volume creation failed for user:{} volume:{}", new Object[]{omVolumeArgs.getOwnerName(), omVolumeArgs.getVolume(), ex});
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (acquiredUserLock) {
                        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{omVolumeArgs.getOwnerName()});
                    }
                    this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{omVolumeArgs.getVolume()});
                    throw throwable;
                }
            }
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{omVolumeArgs.getOwnerName()});
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{omVolumeArgs.getVolume()});
    }

    private void createVolumeCommitToDB(OmVolumeArgs omVolumeArgs, OzoneManagerProtocolProtos.UserVolumeInfo volumeList, String dbVolumeKey, String dbUserKey) throws IOException {
        try (BatchOperation batch = this.metadataManager.getStore().initBatchOperation();){
            this.metadataManager.getVolumeTable().putWithBatch(batch, (Object)dbVolumeKey, (Object)omVolumeArgs);
            this.metadataManager.getUserTable().putWithBatch(batch, (Object)dbUserKey, (Object)volumeList);
            this.metadataManager.getStore().commitBatchOperation(batch);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setOwner(String volume, String owner) throws IOException {
        block6: {
            Preconditions.checkNotNull((Object)volume);
            Preconditions.checkNotNull((Object)owner);
            boolean acquiredUsersLock = false;
            String actualOwner = null;
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            try {
                String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
                OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
                if (volumeArgs == null) {
                    LOG.debug("Changing volume ownership failed for user:{} volume:{}", (Object)owner, (Object)volume);
                    throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
                }
                Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
                actualOwner = volumeArgs.getOwnerName();
                String originalOwner = this.metadataManager.getUserKey(actualOwner);
                acquiredUsersLock = this.metadataManager.getLock().acquireMultiUserLock(owner, originalOwner);
                OzoneManagerProtocolProtos.UserVolumeInfo oldOwnerVolumeList = this.delVolumeFromOwnerList(volume, originalOwner);
                String newOwner = this.metadataManager.getUserKey(owner);
                OzoneManagerProtocolProtos.UserVolumeInfo newOwnerVolumeList = this.addVolumeToOwnerList(volume, newOwner);
                volumeArgs.setOwnerName(owner);
                this.setOwnerCommitToDB(oldOwnerVolumeList, newOwnerVolumeList, volumeArgs, owner);
                if (!acquiredUsersLock) break block6;
            }
            catch (IOException ex) {
                try {
                    if (ex instanceof OMException) throw ex;
                    LOG.error("Changing volume ownership failed for user:{} volume:{}", new Object[]{owner, volume, ex});
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (acquiredUsersLock) {
                        this.metadataManager.getLock().releaseMultiUserLock(owner, actualOwner);
                    }
                    this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                    throw throwable;
                }
            }
            this.metadataManager.getLock().releaseMultiUserLock(owner, actualOwner);
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
    }

    private void setOwnerCommitToDB(OzoneManagerProtocolProtos.UserVolumeInfo oldOwnerVolumeList, OzoneManagerProtocolProtos.UserVolumeInfo newOwnerVolumeList, OmVolumeArgs newOwnerVolumeArgs, String oldOwner) throws IOException {
        try (BatchOperation batch = this.metadataManager.getStore().initBatchOperation();){
            if (oldOwnerVolumeList.getVolumeNamesList().size() == 0) {
                this.metadataManager.getUserTable().deleteWithBatch(batch, (Object)oldOwner);
            } else {
                this.metadataManager.getUserTable().putWithBatch(batch, (Object)oldOwner, (Object)oldOwnerVolumeList);
            }
            this.metadataManager.getUserTable().putWithBatch(batch, (Object)newOwnerVolumeArgs.getOwnerName(), (Object)newOwnerVolumeList);
            String dbVolumeKey = this.metadataManager.getVolumeKey(newOwnerVolumeArgs.getVolume());
            this.metadataManager.getVolumeTable().putWithBatch(batch, (Object)dbVolumeKey, (Object)newOwnerVolumeArgs);
            this.metadataManager.getStore().commitBatchOperation(batch);
        }
    }

    @Override
    public void setQuota(String volume, long quota) throws IOException {
        Preconditions.checkNotNull((Object)volume);
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException(OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            volumeArgs.setQuotaInBytes(quota);
            this.metadataManager.getVolumeTable().put((Object)dbVolumeKey, (Object)volumeArgs);
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Changing volume quota failed for volume:{} quota:{}", new Object[]{volume, quota, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
    }

    @Override
    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        OmVolumeArgs omVolumeArgs;
        Preconditions.checkNotNull((Object)volume);
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            omVolumeArgs = volumeArgs;
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.warn("Info volume failed for volume:{}", (Object)volume, (Object)ex);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return omVolumeArgs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteVolume(String volume) throws IOException {
        block7: {
            Preconditions.checkNotNull((Object)volume);
            String owner = null;
            boolean acquiredUserLock = false;
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            try {
                owner = this.getVolumeInfo(volume).getOwnerName();
                acquiredUserLock = this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
                OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
                if (volumeArgs == null) {
                    LOG.debug("volume:{} does not exist", (Object)volume);
                    throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
                }
                if (!this.metadataManager.isVolumeEmpty(volume)) {
                    LOG.debug("volume:{} is not empty", (Object)volume);
                    throw new OMException(OMException.ResultCodes.VOLUME_NOT_EMPTY);
                }
                Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
                OzoneManagerProtocolProtos.UserVolumeInfo newVolumeList = this.delVolumeFromOwnerList(volume, volumeArgs.getOwnerName());
                this.deleteVolumeCommitToDB(newVolumeList, volume, owner);
                if (!acquiredUserLock) break block7;
            }
            catch (IOException ex) {
                try {
                    if (ex instanceof OMException) throw ex;
                    LOG.error("Delete volume failed for volume:{}", (Object)volume, (Object)ex);
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (acquiredUserLock) {
                        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                    }
                    this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                    throw throwable;
                }
            }
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
    }

    private void deleteVolumeCommitToDB(OzoneManagerProtocolProtos.UserVolumeInfo newVolumeList, String volume, String owner) throws IOException {
        try (BatchOperation batch = this.metadataManager.getStore().initBatchOperation();){
            String dbUserKey = this.metadataManager.getUserKey(owner);
            if (newVolumeList.getVolumeNamesList().size() == 0) {
                this.metadataManager.getUserTable().deleteWithBatch(batch, (Object)dbUserKey);
            } else {
                this.metadataManager.getUserTable().putWithBatch(batch, (Object)dbUserKey, (Object)newVolumeList);
            }
            this.metadataManager.getVolumeTable().deleteWithBatch(batch, (Object)this.metadataManager.getVolumeKey(volume));
            this.metadataManager.getStore().commitBatchOperation(batch);
        }
    }

    @Override
    public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        boolean bl;
        Preconditions.checkNotNull((Object)volume);
        Preconditions.checkNotNull((Object)userAcl);
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            bl = volumeArgs.getAclMap().hasAccess(userAcl);
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Check volume access failed for volume:{} user:{} rights:{}", new Object[]{volume, userAcl.getName(), userAcl.getRights().toString(), ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OmVolumeArgs> listVolumes(String userName, String prefix, String startKey, int maxKeys) throws IOException {
        List<OmVolumeArgs> filteredVolumes;
        UserGroupInformation userUgi;
        List volumes;
        block3: {
            List list;
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
            try {
                volumes = this.metadataManager.listVolumes(userName, prefix, startKey, maxKeys);
                userUgi = ProtobufRpcEngine.Server.getRemoteUser();
                if (userUgi != null && this.aclEnabled) break block3;
                list = volumes;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
                throw throwable;
            }
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
            return list;
        }
        List<OmVolumeArgs> list = filteredVolumes = volumes.stream().filter(v -> v.getAclMap().hasAccess(IAccessAuthorizer.ACLType.LIST, userUgi)).collect(Collectors.toList());
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
        return list;
    }

    @Override
    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(acl);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.VOLUME)) {
            throw new IllegalArgumentException("Unexpected argument passed to VolumeManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
        OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
        if (volumeArgs == null) {
            LOG.debug("volume:{} does not exist", (Object)volume);
            throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        try {
            volumeArgs.addAcl(acl);
        }
        catch (OMException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Add acl failed.", (Throwable)ex);
            }
            boolean bl = false;
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            return bl;
        }
        try {
            this.metadataManager.getVolumeTable().put((Object)dbVolumeKey, (Object)volumeArgs);
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Add acl operation failed for volume:{} acl:{}", new Object[]{volume, acl, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return true;
    }

    @Override
    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(acl);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.VOLUME)) {
            throw new IllegalArgumentException("Unexpected argument passed to VolumeManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
        OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
        if (volumeArgs == null) {
            LOG.debug("volume:{} does not exist", (Object)volume);
            throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        try {
            volumeArgs.removeAcl(acl);
        }
        catch (OMException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Remove acl failed.", (Throwable)ex);
            }
            boolean bl = false;
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            return bl;
        }
        try {
            this.metadataManager.getVolumeTable().put((Object)dbVolumeKey, (Object)volumeArgs);
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Remove acl operation failed for volume:{} acl:{}", new Object[]{volume, acl, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return true;
    }

    @Override
    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(acls);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.VOLUME)) {
            throw new IllegalArgumentException("Unexpected argument passed to VolumeManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            volumeArgs.setAcls(acls);
            this.metadataManager.getVolumeTable().put((Object)dbVolumeKey, (Object)volumeArgs);
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Set acl operation failed for volume:{} acls:{}", new Object[]{volume, acls, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return true;
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        List list;
        Objects.requireNonNull(obj);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.VOLUME)) {
            throw new IllegalArgumentException("Unexpected argument passed to VolumeManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            list = volumeArgs.getAclMap().getAcl();
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Get acl operation failed for volume:{}", (Object)volume, (Object)ex);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return list;
    }

    @Override
    public boolean checkAccess(OzoneObj ozObject, RequestContext context) throws OMException {
        boolean bl;
        Objects.requireNonNull(ozObject);
        Objects.requireNonNull(context);
        String volume = ozObject.getVolumeName();
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            boolean hasAccess = volumeArgs.getAclMap().hasAccess(context.getAclRights(), context.getClientUgi());
            if (LOG.isDebugEnabled()) {
                LOG.debug("user:{} has access rights for volume:{} :{} ", new Object[]{context.getClientUgi(), ozObject.getVolumeName(), hasAccess});
            }
            bl = hasAccess;
        }
        catch (IOException ex) {
            try {
                if (ex instanceof OMException) {
                    throw (OMException)((Object)ex);
                }
                LOG.error("Check access operation failed for volume:{}", (Object)volume, (Object)ex);
                throw new OMException("Check access operation failed for volume:" + volume, (Throwable)ex, OMException.ResultCodes.INTERNAL_ERROR);
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        return bl;
    }
}

