/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ha;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneIllegalArgumentException;
import org.apache.hadoop.ozone.om.ha.OMNodeDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMHANodeDetails {
    private static String[] genericConfigKeys = new String[]{"ozone.om.http-address", "ozone.om.https-address", "ozone.om.http-bind-host", "ozone.om.https-bind-host", "ozone.om.db.dirs", "ozone.om.address"};
    public static final Logger LOG = LoggerFactory.getLogger(OMHANodeDetails.class);
    private final OMNodeDetails localNodeDetails;
    private final List<OMNodeDetails> peerNodeDetails;

    public OMHANodeDetails(OMNodeDetails localNodeDetails, List<OMNodeDetails> peerNodeDetails) {
        this.localNodeDetails = localNodeDetails;
        this.peerNodeDetails = peerNodeDetails;
    }

    public OMNodeDetails getLocalNodeDetails() {
        return this.localNodeDetails;
    }

    public List<OMNodeDetails> getPeerNodeDetails() {
        return this.peerNodeDetails;
    }

    public static OMHANodeDetails loadOMHAConfig(OzoneConfiguration conf) {
        Collection<String> omServiceIds;
        InetSocketAddress localRpcAddress = null;
        String localOMServiceId = null;
        String localOMNodeId = null;
        int localRatisPort = 0;
        localOMServiceId = conf.getTrimmed("ozone.om.internal.service.id");
        if (localOMServiceId == null) {
            LOG.info("{} is not defined, falling back to {} to find serviceID for OzoneManager if it is HA enabled cluster", (Object)"ozone.om.internal.service.id", (Object)"ozone.om.service.ids");
            omServiceIds = conf.getTrimmedStringCollection("ozone.om.service.ids");
        } else {
            LOG.info("ServiceID for OzoneManager is {}", (Object)localOMServiceId);
            omServiceIds = Collections.singletonList(localOMServiceId);
        }
        String knownOMNodeId = conf.get("ozone.om.node.id");
        int found = 0;
        boolean isOMAddressSet = false;
        for (String serviceId : omServiceIds) {
            Collection omNodeIds = OmUtils.getOMNodeIds((Configuration)conf, (String)serviceId);
            if (omNodeIds.size() == 0) {
                String msg = "Configuration does not have any value set for ozone.om.nodes for service ID " + serviceId + ". List of OM Node ID's should be specified for the service ID";
                throw new OzoneIllegalArgumentException(msg);
            }
            ArrayList<OMNodeDetails> peerNodesList = new ArrayList<OMNodeDetails>();
            for (String nodeId : omNodeIds) {
                boolean isPeer = knownOMNodeId != null && !knownOMNodeId.equals(nodeId);
                String rpcAddrKey = OmUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{serviceId, nodeId});
                String rpcAddrStr = OmUtils.getOmRpcAddress((Configuration)conf, (String)rpcAddrKey);
                if (rpcAddrStr == null || rpcAddrStr.isEmpty()) {
                    String msg = "Configuration does not have any value set for " + rpcAddrKey + ".OM Rpc Address should be set for all node IDs for a service ID.";
                    throw new OzoneIllegalArgumentException(msg);
                }
                isOMAddressSet = true;
                String ratisPortKey = OmUtils.addKeySuffixes((String)"ozone.om.ratis.port", (String[])new String[]{serviceId, nodeId});
                int ratisPort = conf.getInt(ratisPortKey, 9872);
                InetSocketAddress addr = null;
                try {
                    addr = NetUtils.createSocketAddr((String)rpcAddrStr);
                }
                catch (Exception e) {
                    LOG.warn("Exception in creating socket address " + addr, (Throwable)e);
                    continue;
                }
                if (addr.isUnresolved()) continue;
                if (!isPeer && OmUtils.isAddressLocal((InetSocketAddress)addr)) {
                    localRpcAddress = addr;
                    localOMServiceId = serviceId;
                    localOMNodeId = nodeId;
                    localRatisPort = ratisPort;
                    ++found;
                    continue;
                }
                peerNodesList.add(OMHANodeDetails.getHAOMNodeDetails(conf, serviceId, nodeId, addr, ratisPort));
            }
            if (found == 1) {
                LOG.debug("Found one matching OM address with service ID: {} and node ID: {}", (Object)localOMServiceId, localOMNodeId);
                LOG.info("Found matching OM address with OMServiceId: {}, OMNodeId: {}, RPC Address: {} and Ratis port: {}", new Object[]{localOMServiceId, localOMNodeId, NetUtils.getHostPortString(localRpcAddress), localRatisPort});
                OMHANodeDetails.setOMNodeSpecificConfigs(conf, localOMServiceId, localOMNodeId);
                return new OMHANodeDetails(OMHANodeDetails.getHAOMNodeDetails(conf, localOMServiceId, localOMNodeId, localRpcAddress, localRatisPort), peerNodesList);
            }
            if (found <= true) continue;
            String msg = "Configuration has multiple ozone.om.address addresses that match local node's address. Please configure the system with ozone.om.service.ids and ozone.om.address";
            throw new OzoneIllegalArgumentException(msg);
        }
        if (!isOMAddressSet) {
            InetSocketAddress omAddress = OmUtils.getOmAddress((Configuration)conf);
            int ratisPort = conf.getInt("ozone.om.ratis.port", 9872);
            LOG.info("Configuration either no {} set. Falling back to the default OM address {}", (Object)"ozone.om.address", (Object)omAddress);
            return new OMHANodeDetails(OMHANodeDetails.getOMNodeDetails(conf, null, null, omAddress, ratisPort), new ArrayList<OMNodeDetails>());
        }
        String msg = "Configuration has no ozone.om.address address that matches local node's address. Please configure the system with ozone.om.address";
        LOG.info(msg);
        throw new OzoneIllegalArgumentException(msg);
    }

    public static OMNodeDetails getOMNodeDetails(OzoneConfiguration conf, String serviceId, String nodeId, InetSocketAddress rpcAddress, int ratisPort) {
        if (serviceId == null) {
            serviceId = "omServiceIdDefault";
            LOG.info("OM Service ID is not set. Setting it to the default ID: {}", (Object)serviceId);
        }
        String httpAddr = OmUtils.getHttpAddressForOMPeerNode((Configuration)conf, null, null, (String)rpcAddress.getHostName());
        String httpsAddr = OmUtils.getHttpsAddressForOMPeerNode((Configuration)conf, null, null, (String)rpcAddress.getHostName());
        return new OMNodeDetails.Builder().setOMServiceId(serviceId).setOMNodeId(nodeId).setRpcAddress(rpcAddress).setRatisPort(ratisPort).setHttpAddress(httpAddr).setHttpsAddress(httpsAddr).build();
    }

    public static OMNodeDetails getHAOMNodeDetails(OzoneConfiguration conf, String serviceId, String nodeId, InetSocketAddress rpcAddress, int ratisPort) {
        Preconditions.checkNotNull((Object)serviceId);
        Preconditions.checkNotNull((Object)nodeId);
        String httpAddr = OmUtils.getHttpAddressForOMPeerNode((Configuration)conf, (String)serviceId, (String)nodeId, (String)rpcAddress.getHostName());
        String httpsAddr = OmUtils.getHttpsAddressForOMPeerNode((Configuration)conf, (String)serviceId, (String)nodeId, (String)rpcAddress.getHostName());
        return new OMNodeDetails.Builder().setOMServiceId(serviceId).setOMNodeId(nodeId).setRpcAddress(rpcAddress).setRatisPort(ratisPort).setHttpAddress(httpAddr).setHttpsAddress(httpsAddr).build();
    }

    private static void setOMNodeSpecificConfigs(OzoneConfiguration ozoneConfiguration, String omServiceId, String omNodeId) {
        for (String confKey : genericConfigKeys) {
            String confValue = OmUtils.getConfSuffixedWithOMNodeId((Configuration)ozoneConfiguration, (String)confKey, (String)omServiceId, (String)omNodeId);
            if (confValue == null) continue;
            LOG.info("Setting configuration key {} with value of key {}: {}", new Object[]{confKey, OmUtils.addKeySuffixes((String)confKey, (String[])new String[]{omNodeId}), confValue});
            ozoneConfiguration.set(confKey, confValue);
        }
    }
}

