/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class OMRatisSnapshotInfo
implements SnapshotInfo {
    static final Logger LOG = LoggerFactory.getLogger(OMRatisSnapshotInfo.class);
    private volatile long term = 0L;
    private volatile long snapshotIndex = -1L;
    private final File ratisSnapshotFile;

    public OMRatisSnapshotInfo(File ratisDir) throws IOException {
        this.ratisSnapshotFile = new File(ratisDir, "ratisSnapshotIndex");
        this.loadRatisSnapshotIndex();
    }

    public void updateTerm(long newTerm) {
        this.term = newTerm;
    }

    private void updateTermIndex(long newTerm, long newIndex) {
        this.term = newTerm;
        this.snapshotIndex = newIndex;
    }

    private void loadRatisSnapshotIndex() throws IOException {
        if (this.ratisSnapshotFile.exists()) {
            RatisSnapshotYaml ratisSnapshotYaml = this.readRatisSnapshotYaml();
            this.updateTermIndex(ratisSnapshotYaml.term, ratisSnapshotYaml.snapshotIndex);
        }
    }

    private RatisSnapshotYaml readRatisSnapshotYaml() throws IOException {
        Throwable throwable = null;
        try (FileInputStream inputFileStream = new FileInputStream(this.ratisSnapshotFile);){
            Yaml yaml = new Yaml();
            try {
                RatisSnapshotYaml ratisSnapshotYaml = (RatisSnapshotYaml)yaml.loadAs((InputStream)inputFileStream, RatisSnapshotYaml.class);
                return ratisSnapshotYaml;
            }
            catch (Exception e) {
                try {
                    throw new IOException("Unable to parse RatisSnapshot yaml file.", e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public void saveRatisSnapshotToDisk(TermIndex lastAppliedTermIndex) throws IOException {
        this.updateTermIndex(lastAppliedTermIndex.getTerm(), lastAppliedTermIndex.getIndex());
        this.writeRatisSnapshotYaml();
        LOG.info("Saved Ratis Snapshot on the OM with snapshotIndex {}", (Object)lastAppliedTermIndex);
    }

    private void writeRatisSnapshotYaml() throws IOException {
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        Yaml yaml = new Yaml(options);
        RatisSnapshotYaml ratisSnapshotYaml = new RatisSnapshotYaml(this.term, this.snapshotIndex);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.ratisSnapshotFile), "UTF-8");){
            yaml.dump((Object)ratisSnapshotYaml, (Writer)writer);
        }
    }

    public TermIndex getTermIndex() {
        return TermIndex.newTermIndex((long)this.term, (long)this.snapshotIndex);
    }

    public long getTerm() {
        return this.term;
    }

    public long getIndex() {
        return this.snapshotIndex;
    }

    public List<FileInfo> getFiles() {
        return null;
    }

    public static class RatisSnapshotYaml {
        private long term;
        private long snapshotIndex;

        public RatisSnapshotYaml() {
        }

        RatisSnapshotYaml(long term, long snapshotIndex) {
            this.term = term;
            this.snapshotIndex = snapshotIndex;
        }

        public void setTerm(long term) {
            this.term = term;
        }

        public long getTerm() {
            return this.term;
        }

        public void setSnapshotIndex(long index) {
            this.snapshotIndex = index;
        }

        public long getSnapshotIndex() {
            return this.snapshotIndex;
        }
    }
}

