/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisSnapshot;
import org.apache.hadoop.ozone.om.ratis.helpers.DoubleBufferEntry;
import org.apache.hadoop.ozone.om.ratis.metrics.OzoneManagerDoubleBufferMetrics;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerDoubleBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerDoubleBuffer.class);
    private Queue<DoubleBufferEntry<OMClientResponse>> currentBuffer;
    private Queue<DoubleBufferEntry<OMClientResponse>> readyBuffer;
    private volatile Queue<CompletableFuture<Void>> currentFutureQueue;
    private volatile Queue<CompletableFuture<Void>> readyFutureQueue;
    private Daemon daemon;
    private final OMMetadataManager omMetadataManager;
    private final AtomicLong flushedTransactionCount = new AtomicLong(0L);
    private final AtomicLong flushIterations = new AtomicLong(0L);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private OzoneManagerDoubleBufferMetrics ozoneManagerDoubleBufferMetrics;
    private long maxFlushedTransactionsInOneIteration;
    private final OzoneManagerRatisSnapshot ozoneManagerRatisSnapShot;
    private final boolean isRatisEnabled;

    public OzoneManagerDoubleBuffer(OMMetadataManager omMetadataManager, OzoneManagerRatisSnapshot ozoneManagerRatisSnapShot) {
        this(omMetadataManager, ozoneManagerRatisSnapShot, true);
    }

    public OzoneManagerDoubleBuffer(OMMetadataManager omMetadataManager, OzoneManagerRatisSnapshot ozoneManagerRatisSnapShot, boolean isRatisEnabled) {
        this.currentBuffer = new ConcurrentLinkedQueue<DoubleBufferEntry<OMClientResponse>>();
        this.readyBuffer = new ConcurrentLinkedQueue<DoubleBufferEntry<OMClientResponse>>();
        this.isRatisEnabled = isRatisEnabled;
        if (!isRatisEnabled) {
            this.currentFutureQueue = new ConcurrentLinkedQueue<CompletableFuture<Void>>();
            this.readyFutureQueue = new ConcurrentLinkedQueue<CompletableFuture<Void>>();
        } else {
            this.currentFutureQueue = null;
            this.readyFutureQueue = null;
        }
        this.omMetadataManager = omMetadataManager;
        this.ozoneManagerRatisSnapShot = ozoneManagerRatisSnapShot;
        this.ozoneManagerDoubleBufferMetrics = OzoneManagerDoubleBufferMetrics.create();
        this.isRunning.set(true);
        this.daemon = new Daemon(this::flushTransactions);
        this.daemon.setName("OMDoubleBufferFlushThread");
        this.daemon.start();
    }

    private void flushTransactions() {
        while (this.isRunning.get()) {
            try {
                if (!this.canFlush()) continue;
                this.setReadyBuffer();
                try (BatchOperation batchOperation = this.omMetadataManager.getStore().initBatchOperation();){
                    this.readyBuffer.iterator().forEachRemaining(entry -> {
                        try {
                            ((OMClientResponse)entry.getResponse()).checkAndUpdateDB(this.omMetadataManager, batchOperation);
                        }
                        catch (IOException ex) {
                            this.terminate(ex);
                        }
                    });
                    long startTime = Time.monotonicNowNanos();
                    this.omMetadataManager.getStore().commitBatchOperation(batchOperation);
                    this.ozoneManagerDoubleBufferMetrics.updateFlushTime(Time.monotonicNowNanos() - startTime);
                }
                if (!this.isRatisEnabled) {
                    this.readyFutureQueue.iterator().forEachRemaining(entry -> entry.complete(null));
                    this.readyFutureQueue.clear();
                }
                int flushedTransactionsSize = this.readyBuffer.size();
                this.flushedTransactionCount.addAndGet(flushedTransactionsSize);
                this.flushIterations.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sync Iteration {} flushed transactions in this iteration{}", (Object)this.flushIterations.get(), (Object)flushedTransactionsSize);
                }
                long lastRatisTransactionIndex = this.readyBuffer.stream().map(DoubleBufferEntry::getTrxLogIndex).max(Long::compareTo).get();
                List<Long> flushedEpochs = this.readyBuffer.stream().map(DoubleBufferEntry::getTrxLogIndex).sorted().collect(Collectors.toList());
                this.cleanupCache(flushedEpochs);
                this.readyBuffer.clear();
                this.ozoneManagerRatisSnapShot.updateLastAppliedIndex(flushedEpochs);
                this.updateMetrics(flushedTransactionsSize);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                if (this.isRunning.get()) {
                    String message = "OMDoubleBuffer flush thread " + Thread.currentThread().getName() + " encountered Interrupted exception while running";
                    ExitUtils.terminate((int)1, (String)message, (Throwable)ex, (Logger)LOG);
                    continue;
                }
                LOG.info("OMDoubleBuffer flush thread {} is interrupted and will exit. {}", (Object)Thread.currentThread().getName(), (Object)Thread.currentThread().getName());
            }
            catch (IOException ex) {
                this.terminate(ex);
            }
            catch (Throwable t) {
                String s = "OMDoubleBuffer flush thread" + Thread.currentThread().getName() + "encountered Throwable error";
                ExitUtils.terminate((int)2, (String)s, (Throwable)t, (Logger)LOG);
            }
        }
    }

    private void cleanupCache(List<Long> lastRatisTransactionIndex) {
        this.omMetadataManager.getBucketTable().cleanupCache(lastRatisTransactionIndex);
        this.omMetadataManager.getVolumeTable().cleanupCache(lastRatisTransactionIndex);
        this.omMetadataManager.getUserTable().cleanupCache(lastRatisTransactionIndex);
        this.omMetadataManager.getOpenKeyTable().cleanupCache(lastRatisTransactionIndex);
        this.omMetadataManager.getKeyTable().cleanupCache(lastRatisTransactionIndex);
        this.omMetadataManager.getDeletedTable().cleanupCache(lastRatisTransactionIndex);
        this.omMetadataManager.getS3Table().cleanupCache(lastRatisTransactionIndex);
        this.omMetadataManager.getMultipartInfoTable().cleanupCache(lastRatisTransactionIndex);
        this.omMetadataManager.getS3SecretTable().cleanupCache(lastRatisTransactionIndex);
        this.omMetadataManager.getDelegationTokenTable().cleanupCache(lastRatisTransactionIndex);
        this.omMetadataManager.getPrefixTable().cleanupCache(lastRatisTransactionIndex);
    }

    private void updateMetrics(long flushedTransactionsSize) {
        this.ozoneManagerDoubleBufferMetrics.incrTotalNumOfFlushOperations();
        this.ozoneManagerDoubleBufferMetrics.incrTotalSizeOfFlushedTransactions(flushedTransactionsSize);
        this.ozoneManagerDoubleBufferMetrics.setAvgFlushTransactionsInOneIteration((float)this.ozoneManagerDoubleBufferMetrics.getTotalNumOfFlushedTransactions() / (float)this.ozoneManagerDoubleBufferMetrics.getTotalNumOfFlushOperations());
        if (this.maxFlushedTransactionsInOneIteration < flushedTransactionsSize) {
            this.maxFlushedTransactionsInOneIteration = flushedTransactionsSize;
            this.ozoneManagerDoubleBufferMetrics.setMaxNumberOfTransactionsFlushedInOneIteration(flushedTransactionsSize);
        }
    }

    public void stop() {
        if (this.isRunning.compareAndSet(true, false)) {
            LOG.info("Stopping OMDoubleBuffer flush thread");
            this.daemon.interrupt();
            try {
                this.daemon.join();
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for daemon to exit.");
            }
            this.ozoneManagerDoubleBufferMetrics.unRegister();
        } else {
            LOG.info("OMDoubleBuffer flush thread is not running.");
        }
    }

    private void terminate(IOException ex) {
        String message = "During flush to DB encountered error in OMDoubleBuffer flush thread " + Thread.currentThread().getName();
        ExitUtils.terminate((int)1, (String)message, (Throwable)ex, (Logger)LOG);
    }

    public long getFlushedTransactionCount() {
        return this.flushedTransactionCount.get();
    }

    public long getFlushIterations() {
        return this.flushIterations.get();
    }

    public synchronized CompletableFuture<Void> add(OMClientResponse response, long transactionIndex) {
        this.currentBuffer.add(new DoubleBufferEntry<OMClientResponse>(transactionIndex, response));
        this.notify();
        if (!this.isRatisEnabled) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.currentFutureQueue.add(future);
            return future;
        }
        return null;
    }

    private synchronized boolean canFlush() throws InterruptedException {
        while (this.currentBuffer.size() == 0) {
            this.wait(Long.MAX_VALUE);
        }
        return true;
    }

    private synchronized void setReadyBuffer() {
        Queue<DoubleBufferEntry<OMClientResponse>> temp = this.currentBuffer;
        this.currentBuffer = this.readyBuffer;
        this.readyBuffer = temp;
        if (!this.isRatisEnabled) {
            Queue<CompletableFuture<Void>> tempFuture = this.currentFutureQueue;
            this.currentFutureQueue = this.readyFutureQueue;
            this.readyFutureQueue = tempFuture;
        }
    }

    @VisibleForTesting
    public OzoneManagerDoubleBufferMetrics getOzoneManagerDoubleBufferMetrics() {
        return this.ozoneManagerDoubleBufferMetrics;
    }
}

