/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketCreateRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketCreateRequest.class);

    public OMBucketCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.CreateBucketRequest createBucketRequest = this.getOmRequest().getCreateBucketRequest();
        OzoneManagerProtocolProtos.BucketInfo bucketInfo = createBucketRequest.getBucketInfo();
        KeyProviderCryptoExtension kmsProvider = ozoneManager.getKmsProvider();
        OzoneManagerProtocolProtos.CreateBucketRequest.Builder newCreateBucketRequest = createBucketRequest.toBuilder();
        OzoneManagerProtocolProtos.BucketInfo.Builder newBucketInfo = bucketInfo.toBuilder();
        newBucketInfo.setCreationTime(Time.now());
        if (bucketInfo.hasBeinfo()) {
            newBucketInfo.setBeinfo(this.getBeinfo(kmsProvider, bucketInfo));
        }
        newCreateBucketRequest.setBucketInfo(newBucketInfo.build());
        return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).setCreateBucketRequest(newCreateBucketRequest.build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        block16: {
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBucketCreates();
            metadataManager = ozoneManager.getMetadataManager();
            createBucketRequest = this.getOmRequest().getCreateBucketRequest();
            bucketInfo = createBucketRequest.getBucketInfo();
            volumeName = bucketInfo.getVolumeName();
            bucketName = bucketInfo.getBucketName();
            omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CreateBucket).setStatus(OzoneManagerProtocolProtos.Status.OK);
            omBucketInfo = OmBucketInfo.getFromProtobuf((OzoneManagerProtocolProtos.BucketInfo)bucketInfo);
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            volumeKey = metadataManager.getVolumeKey(volumeName);
            bucketKey = metadataManager.getBucketKey(volumeName, bucketName);
            exception = null;
            acquiredBucketLock = false;
            acquiredVolumeLock = false;
            omClientResponse = null;
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, volumeName, bucketName, null);
            }
            acquiredVolumeLock = metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
            acquiredBucketLock = metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            omVolumeArgs = (OmVolumeArgs)metadataManager.getVolumeTable().get((Object)volumeKey);
            if (omVolumeArgs == null) {
                OMBucketCreateRequest.LOG.debug("volume: {} not found ", (Object)volumeName);
                throw new OMException("Volume doesn't exist", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            dbBucketInfo = (OmBucketInfo)metadataManager.getBucketTable().get((Object)bucketKey);
            if (dbBucketInfo == null) ** GOTO lbl42
            if (!this.isReplay(ozoneManager, (WithObjectID)dbBucketInfo, transactionLogIndex)) break block16;
            OMBucketCreateRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)transactionLogIndex, (Object)createBucketRequest);
            var23_23 = new OMBucketCreateResponse(this.createReplayOMResponse(omResponse));
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
            if (acquiredVolumeLock) {
                metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
            }
            return var23_23;
        }
        try {
            OMBucketCreateRequest.LOG.debug("bucket: {} already exists ", (Object)bucketName);
            throw new OMException("Bucket already exist", OMException.ResultCodes.BUCKET_ALREADY_EXISTS);
lbl42:
            // 1 sources

            omBucketInfo.setObjectID(OMFileRequest.getObjIDFromTxId(transactionLogIndex));
            omBucketInfo.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
            this.addDefaultAcls(omBucketInfo, omVolumeArgs);
            metadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), new CacheValue(Optional.of((Object)omBucketInfo), transactionLogIndex));
            omResponse.setCreateBucketResponse(OzoneManagerProtocolProtos.CreateBucketResponse.newBuilder().build());
            omClientResponse = new OMBucketCreateResponse(omResponse.build(), omBucketInfo);
        }
        catch (IOException ex) {
            try {
                exception = ex;
                omClientResponse = new OMBucketCreateResponse(this.createErrorOMResponse(omResponse, exception), omBucketInfo);
            }
            catch (Throwable var24_24) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredBucketLock) {
                    metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                if (acquiredVolumeLock) {
                    metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
                }
                throw var24_24;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
            if (acquiredVolumeLock) {
                metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
            } else {
                ** GOTO lbl72
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (acquiredBucketLock) {
            metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        if (acquiredVolumeLock) {
            metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.CREATE_BUCKET, omBucketInfo.toAuditMap(), exception, userInfo));
        if (exception == null) {
            OMBucketCreateRequest.LOG.debug("created bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
            omMetrics.incNumBuckets();
            return omClientResponse;
        }
        omMetrics.incNumBucketCreateFails();
        OMBucketCreateRequest.LOG.error("Bucket creation failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        return omClientResponse;
    }

    private void addDefaultAcls(OmBucketInfo omBucketInfo, OmVolumeArgs omVolumeArgs) {
        ArrayList acls = new ArrayList();
        if (omBucketInfo.getAcls() != null) {
            acls.addAll(omBucketInfo.getAcls());
        }
        List defaultVolumeAclList = omVolumeArgs.getAclMap().getDefaultAclList().stream().map(OzoneAcl::fromProtobuf).collect(Collectors.toList());
        OzoneAclUtil.inheritDefaultAcls(acls, defaultVolumeAclList);
        omBucketInfo.setAcls(acls);
    }

    private OzoneManagerProtocolProtos.BucketEncryptionInfoProto getBeinfo(KeyProviderCryptoExtension kmsProvider, OzoneManagerProtocolProtos.BucketInfo bucketInfo) throws IOException {
        OzoneManagerProtocolProtos.BucketEncryptionInfoProto bek = bucketInfo.getBeinfo();
        OzoneManagerProtocolProtos.BucketEncryptionInfoProto.Builder bekb = null;
        if (kmsProvider == null) {
            throw new OMException("Invalid KMS provider, check configuration hadoop.security.key.provider.path", OMException.ResultCodes.INVALID_KMS_PROVIDER);
        }
        if (bek.getKeyName() == null) {
            throw new OMException("Bucket encryption key needed.", OMException.ResultCodes.BUCKET_ENCRYPTION_KEY_NOT_FOUND);
        }
        KeyProvider.Metadata metadata = kmsProvider.getMetadata(bek.getKeyName());
        if (metadata == null) {
            throw new OMException("Bucket encryption key " + bek.getKeyName() + " doesn't exist.", OMException.ResultCodes.BUCKET_ENCRYPTION_KEY_NOT_FOUND);
        }
        kmsProvider.warmUpEncryptedKeys(new String[]{bek.getKeyName()});
        bekb = OzoneManagerProtocolProtos.BucketEncryptionInfoProto.newBuilder().setKeyName(bek.getKeyName()).setCryptoProtocolVersion(OzoneManagerProtocolProtos.CryptoProtocolVersionProto.ENCRYPTION_ZONES).setSuite(OMPBHelper.convert((CipherSuite)CipherSuite.convert((String)metadata.getCipher())));
        return bekb.build();
    }
}

