/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketSetPropertyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketSetPropertyRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketSetPropertyRequest.class);

    public OMBucketSetPropertyRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        block18: {
            setBucketPropertyRequest = this.getOmRequest().getSetBucketPropertyRequest();
            Preconditions.checkNotNull((Object)setBucketPropertyRequest);
            omMetadataManager = ozoneManager.getMetadataManager();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBucketUpdates();
            bucketArgs = setBucketPropertyRequest.getBucketArgs();
            omBucketArgs = OmBucketArgs.getFromProtobuf((OzoneManagerProtocolProtos.BucketArgs)bucketArgs);
            volumeName = bucketArgs.getVolumeName();
            bucketName = bucketArgs.getBucketName();
            omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CreateBucket).setStatus(OzoneManagerProtocolProtos.Status.OK);
            omBucketInfo = null;
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            exception = null;
            acquiredBucketLock = false;
            success = true;
            omClientResponse = null;
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, null);
            }
            acquiredBucketLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
            dbBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
            if (dbBucketInfo == null) {
                OMBucketSetPropertyRequest.LOG.debug("bucket: {} not found ", (Object)bucketName);
                throw new OMException("Bucket doesn't exist", OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            if (!this.isReplay(ozoneManager, (WithObjectID)dbBucketInfo, transactionLogIndex)) break block18;
            OMBucketSetPropertyRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)transactionLogIndex, (Object)setBucketPropertyRequest);
            var22_22 = new OMBucketSetPropertyResponse(this.createReplayOMResponse(omResponse));
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
            return var22_22;
        }
        try {
            bucketInfoBuilder = OmBucketInfo.newBuilder();
            bucketInfoBuilder.setVolumeName(dbBucketInfo.getVolumeName()).setBucketName(dbBucketInfo.getBucketName()).setObjectID(dbBucketInfo.getObjectID()).setUpdateID(transactionLogIndex);
            bucketInfoBuilder.addAllMetadata(KeyValueUtil.getFromProtobuf((List)bucketArgs.getMetadataList()));
            storageType = omBucketArgs.getStorageType();
            if (storageType != null) {
                bucketInfoBuilder.setStorageType(storageType);
                OMBucketSetPropertyRequest.LOG.debug("Updating bucket storage type for bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
            } else {
                bucketInfoBuilder.setStorageType(dbBucketInfo.getStorageType());
            }
            versioning = omBucketArgs.getIsVersionEnabled();
            if (versioning != null) {
                bucketInfoBuilder.setIsVersionEnabled(versioning);
                OMBucketSetPropertyRequest.LOG.debug("Updating bucket versioning for bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
            } else {
                bucketInfoBuilder.setIsVersionEnabled(Boolean.valueOf(dbBucketInfo.getIsVersionEnabled()));
            }
            bucketInfoBuilder.setCreationTime(dbBucketInfo.getCreationTime());
            if (dbBucketInfo.getAcls() != null) {
                bucketInfoBuilder.setAcls(dbBucketInfo.getAcls());
            }
            if (dbBucketInfo.getObjectID() != 0L) {
                bucketInfoBuilder.setObjectID(dbBucketInfo.getObjectID());
            }
            bucketInfoBuilder.setUpdateID(transactionLogIndex);
            omBucketInfo = bucketInfoBuilder.build();
            omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), new CacheValue(Optional.of((Object)omBucketInfo), transactionLogIndex));
            omResponse.setSetBucketPropertyResponse(OzoneManagerProtocolProtos.SetBucketPropertyResponse.newBuilder().build());
            omClientResponse = new OMBucketSetPropertyResponse(omResponse.build(), omBucketInfo);
        }
        catch (IOException ex) {
            try {
                success = false;
                exception = ex;
                omClientResponse = new OMBucketSetPropertyResponse(this.createErrorOMResponse(omResponse, exception), omBucketInfo);
            }
            catch (Throwable var25_26) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredBucketLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var25_26;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl91
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (acquiredBucketLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.UPDATE_BUCKET, omBucketArgs.toAuditMap(), exception, userInfo));
        if (success) {
            OMBucketSetPropertyRequest.LOG.debug("Setting bucket property for bucket:{} in volume:{}", (Object)bucketName, (Object)volumeName);
            return omClientResponse;
        }
        OMBucketSetPropertyRequest.LOG.error("Setting bucket property failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        omMetrics.incNumBucketUpdateFails();
        return omClientResponse;
    }
}

