/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket.acl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketAclRequest;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketAddAclRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.acl.OMBucketAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.util.BooleanBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketSetAclRequest
extends OMBucketAclRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketAddAclRequest.class);
    private static BooleanBiFunction<List<OzoneAcl>, OmBucketInfo> bucketAddAclOp = (ozoneAcls, omBucketInfo) -> omBucketInfo.setAcls(ozoneAcls);
    private String path;
    private List<OzoneAcl> ozoneAcls;

    public OMBucketSetAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, bucketAddAclOp);
        OzoneManagerProtocolProtos.SetAclRequest setAclRequest = this.getOmRequest().getSetAclRequest();
        this.path = setAclRequest.getObj().getPath();
        this.ozoneAcls = new ArrayList<OzoneAcl>();
        setAclRequest.getAclList().forEach(aclInfo -> this.ozoneAcls.add(OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)aclInfo)));
    }

    @Override
    List<OzoneAcl> getAcls() {
        return this.ozoneAcls;
    }

    @Override
    String getPath() {
        return this.path;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetAcl).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmBucketInfo omBucketInfo, boolean operationResult) {
        omResponse.setSuccess(operationResult);
        omResponse.setSetAclResponse(OzoneManagerProtocolProtos.SetAclResponse.newBuilder().setResponse(operationResult));
        return new OMBucketAclResponse(omResponse.build(), omBucketInfo);
    }

    @Override
    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, IOException exception) {
        return new OMBucketAclResponse(this.createErrorOMResponse(omResponse, exception));
    }

    @Override
    void onComplete(boolean operationResult, IOException exception, OMMetrics omMetrics) {
        if (operationResult) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set acl: {} for path: {} success!", this.getAcls(), (Object)this.getPath());
            }
        } else {
            omMetrics.incNumBucketUpdateFails();
            if (exception == null) {
                LOG.error("Set acl {} for path {} failed", this.getAcls(), (Object)this.getPath());
            } else {
                LOG.error("Set acl {} for path {} failed!", new Object[]{this.getAcls(), this.getPath(), exception});
            }
        }
    }
}

