/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMReplayException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMFileCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMFileCreateRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMFileCreateRequest.class);

    public OMFileCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        HddsProtos.ReplicationType type;
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest = this.getOmRequest().getCreateFileRequest();
        Preconditions.checkNotNull((Object)createFileRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = createFileRequest.getKeyArgs();
        if (keyArgs.getKeyName().length() == 0) {
            return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).build();
        }
        long scmBlockSize = ozoneManager.getScmBlockSize();
        long requestedSize = keyArgs.getDataSize() > 0L ? keyArgs.getDataSize() : scmBlockSize;
        boolean useRatis = ozoneManager.shouldUseRatis();
        HddsProtos.ReplicationFactor factor = keyArgs.getFactor();
        if (factor == null) {
            HddsProtos.ReplicationFactor replicationFactor = factor = useRatis ? HddsProtos.ReplicationFactor.THREE : HddsProtos.ReplicationFactor.ONE;
        }
        if ((type = keyArgs.getType()) == null) {
            type = useRatis ? HddsProtos.ReplicationType.RATIS : HddsProtos.ReplicationType.STAND_ALONE;
        }
        List<OmKeyLocationInfo> omKeyLocationInfoList = this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), type, factor, new ExcludeList(), requestedSize, scmBlockSize, ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMNodeId());
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setType(type).setFactor(factor).setDataSize(requestedSize);
        newKeyArgs.addAllKeyLocations((Iterable)omKeyLocationInfoList.stream().map(OmKeyLocationInfo::getProtobuf).collect(Collectors.toList()));
        OzoneManagerProtocolProtos.CreateFileRequest.Builder newCreateFileRequest = createFileRequest.toBuilder().setKeyArgs(newKeyArgs).setClientID(UniqueId.next());
        return this.getOmRequest().toBuilder().setCreateFileRequest(newCreateFileRequest).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        createFileRequest = this.getOmRequest().getCreateFileRequest();
        keyArgs = createFileRequest.getKeyArgs();
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        keyName = keyArgs.getKeyName();
        isRecursive = createFileRequest.getIsRecursive();
        OMFileCreateRequest.LOG.info("File create for : " + volumeName + "/" + bucketName + "/" + keyName + ":" + isRecursive);
        isOverWrite = createFileRequest.getIsOverwrite();
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumCreateFile();
        omMetadataManager = ozoneManager.getMetadataManager();
        acquiredLock = false;
        encryptionInfo = Optional.absent();
        omKeyInfo = null;
        locations = new ArrayList<OmKeyLocationInfo>();
        omClientResponse = null;
        omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CreateFile).setStatus(OzoneManagerProtocolProtos.Status.OK);
        exception = null;
        result = null;
        try {
            this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
            acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            if (keyName.length() == 0) {
                throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
            }
            ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
            dbKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)ozoneKey);
            if (dbKeyInfo != null && this.isReplay(ozoneManager, (WithObjectID)dbKeyInfo, trxnLogIndex)) {
                throw new OMReplayException();
            }
            omDirectoryResult = OMFileRequest.verifyFilesInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0])).getDirectoryResult();
            if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS) {
                if (!isOverWrite) {
                    throw new OMException("File " + keyName + " already exists", OMException.ResultCodes.FILE_ALREADY_EXISTS);
                }
            } else {
                if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS) {
                    throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                }
                if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                    throw new OMException("Can not create file: " + keyName + " as there is already file in the given path", OMException.ResultCodes.NOT_A_FILE);
                }
            }
            if (!(isRecursive || omDirectoryResult != OMFileRequest.OMDirectoryResult.NONE && omDirectoryResult != OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH || (canBeCreated = this.checkKeysUnderPath(omMetadataManager, volumeName, bucketName, keyName)))) {
                throw new OMException("Can not create file: " + keyName + " as one of parent directory is not created", OMException.ResultCodes.NOT_A_FILE);
            }
            bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
            encryptionInfo = this.getFileEncryptionInfo(ozoneManager, bucketInfo);
            omKeyInfo = this.prepareKeyInfo(omMetadataManager, keyArgs, dbKeyInfo, keyArgs.getDataSize(), locations, (FileEncryptionInfo)encryptionInfo.orNull(), ozoneManager.getPrefixManager(), bucketInfo, trxnLogIndex, ozoneManager.isRatisEnabled());
            openVersion = omKeyInfo.getLatestVersionLocations().getVersion();
            clientID = createFileRequest.getClientID();
            dbOpenKeyName = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
            omKeyInfo.appendNewBlocks(keyArgs.getKeyLocationsList().stream().map((Function<OzoneManagerProtocolProtos.KeyLocation, OmKeyLocationInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFromProtobuf(org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$KeyLocation ), (Lorg/apache/hadoop/ozone/protocol/proto/OzoneManagerProtocolProtos$KeyLocation;)Lorg/apache/hadoop/ozone/om/helpers/OmKeyLocationInfo;)()).collect(Collectors.toList()), false);
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)dbOpenKeyName), new CacheValue(Optional.of((Object)omKeyInfo), trxnLogIndex));
            omResponse.setCreateFileResponse(OzoneManagerProtocolProtos.CreateFileResponse.newBuilder().setKeyInfo(omKeyInfo.getProtobuf()).setID(clientID).setOpenVersion(openVersion).build()).setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
            omClientResponse = new OMFileCreateResponse(omResponse.build(), omKeyInfo, clientID);
            result = Result.SUCCESS;
        }
        catch (IOException ex) {
            block22: {
                try {
                    if (ex instanceof OMReplayException) {
                        result = Result.REPLAY;
                        omClientResponse = new OMFileCreateResponse(this.createReplayOMResponse(omResponse));
                        break block22;
                    }
                    result = Result.FAILURE;
                    exception = ex;
                    omMetrics.incNumCreateFileFails();
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
                    omClientResponse = new OMFileCreateResponse(this.createErrorOMResponse(omResponse, exception));
                }
                catch (Throwable var31_30) {
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    throw var31_30;
                }
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl79
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (acquiredLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        if (result != Result.REPLAY) {
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.CREATE_FILE, auditMap, exception, this.getOmRequest().getUserInfo()));
        }
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$file$OMFileCreateRequest$Result[result.ordinal()]) {
            case 1: {
                OMFileCreateRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)trxnLogIndex, (Object)createFileRequest);
                break;
            }
            case 2: {
                OMFileCreateRequest.LOG.debug("File created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case 3: {
                OMFileCreateRequest.LOG.error("File create failed. Volume:{}, Bucket:{}, Key{}. Exception:{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                OMFileCreateRequest.LOG.error("Unrecognized Result for OMFileCreateRequest: {}", (Object)createFileRequest);
            }
        }
        return omClientResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkKeysUnderPath(OMMetadataManager omMetadataManager, @Nonnull String volumeName, @Nonnull String bucketName, @Nonnull String keyName) throws IOException {
        Path parentPath = Paths.get(keyName, new String[0]).getParent();
        if (parentPath == null) return true;
        String dbKeyPath = omMetadataManager.getOzoneDirKey(volumeName, bucketName, parentPath.toString());
        Iterator iterator = omMetadataManager.getKeyTable().cacheIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)((CacheKey)entry.getKey()).getCacheKey();
            OmKeyInfo omKeyInfo = (OmKeyInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (!key.startsWith(dbKeyPath) || omKeyInfo == null) continue;
            return true;
        }
        try (TableIterator keyIter = omMetadataManager.getKeyTable().iterator();){
            Table.KeyValue kv = (Table.KeyValue)keyIter.seek((Object)dbKeyPath);
            if (kv == null) return false;
            CacheValue cacheValue = omMetadataManager.getKeyTable().getCacheValue(new CacheKey(kv.getKey()));
            if (cacheValue != null) {
                if (!((String)kv.getKey()).startsWith(dbKeyPath) || cacheValue.getCacheValue() == null) return false;
                boolean bl = true;
                return bl;
            } else {
                if (!((String)kv.getKey()).startsWith(dbKeyPath)) return false;
                boolean bl = true;
                return bl;
            }
        }
    }

    private static enum Result {
        SUCCESS,
        REPLAY,
        FAILURE;

    }
}

