/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMFileRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMFileRequest.class);
    private static final long TRANSACTION_ID_SHIFT = 8L;

    private OMFileRequest() {
    }

    public static OMPathInfo verifyFilesInPath(@Nonnull OMMetadataManager omMetadataManager, @Nonnull String volumeName, @Nonnull String bucketName, @Nonnull String keyName, @Nonnull Path keyPath) throws IOException {
        String fileNameFromDetails = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
        String dirNameFromDetails = omMetadataManager.getOzoneDirKey(volumeName, bucketName, keyName);
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<OzoneAcl> inheritAcls = new ArrayList();
        OMDirectoryResult result = OMDirectoryResult.NONE;
        while (keyPath != null) {
            String pathName = keyPath.toString();
            String dbKeyName = omMetadataManager.getOzoneKey(volumeName, bucketName, pathName);
            String dbDirKeyName = omMetadataManager.getOzoneDirKey(volumeName, bucketName, pathName);
            if (omMetadataManager.getKeyTable().isExist((Object)dbKeyName)) {
                result = dbKeyName.equals(fileNameFromDetails) ? OMDirectoryResult.FILE_EXISTS : OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH;
            } else if (omMetadataManager.getKeyTable().isExist((Object)dbDirKeyName)) {
                if (dbDirKeyName.equals(dirNameFromDetails)) {
                    result = OMDirectoryResult.DIRECTORY_EXISTS;
                } else {
                    result = OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH;
                    inheritAcls = ((OmKeyInfo)omMetadataManager.getKeyTable().get((Object)dbDirKeyName)).getAcls();
                    LOG.trace("Acls inherited from parent " + dbDirKeyName + " are : " + inheritAcls);
                }
            } else if (!dbDirKeyName.equals(dirNameFromDetails)) {
                missing.add(keyPath.toString());
            }
            if (result != OMDirectoryResult.NONE) {
                LOG.trace("verifyFiles in Path : /" + volumeName + "/" + bucketName + "/" + keyName + ":" + (Object)((Object)result));
                return new OMPathInfo(missing, result, inheritAcls);
            }
            keyPath = keyPath.getParent();
        }
        if (inheritAcls.isEmpty()) {
            String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
            inheritAcls = ((OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey)).getAcls();
            LOG.trace("Acls inherited from bucket " + bucketName + " are : " + inheritAcls);
        }
        LOG.trace("verifyFiles in Path : " + volumeName + "/" + bucketName + "/" + keyName + ":" + (Object)((Object)result));
        return new OMPathInfo(missing, OMDirectoryResult.NONE, inheritAcls);
    }

    public static long getObjIDFromTxId(long id) {
        return id << 8;
    }

    public static ImmutablePair<Long, Long> getObjIdRangeFromTxId(long id) {
        long baseId = OMFileRequest.getObjIDFromTxId(id);
        long maxAvailableId = OMFileRequest.getObjIDFromTxId(id + 1L) - 1L;
        Preconditions.checkState((maxAvailableId >= baseId ? 1 : 0) != 0, (Object)"max available id must be atleast equal to the base id.");
        return new ImmutablePair((Object)baseId, (Object)maxAvailableId);
    }

    static enum OMDirectoryResult {
        DIRECTORY_EXISTS_IN_GIVENPATH,
        FILE_EXISTS_IN_GIVENPATH,
        FILE_EXISTS,
        DIRECTORY_EXISTS,
        NONE;

    }

    public static class OMPathInfo {
        private OMDirectoryResult directoryResult;
        private List<String> missingParents;
        private List<OzoneAcl> acls;

        public OMPathInfo(List missingParents, OMDirectoryResult result, List<OzoneAcl> aclList) {
            this.missingParents = missingParents;
            this.directoryResult = result;
            this.acls = aclList;
        }

        public List getMissingParents() {
            return this.missingParents;
        }

        public OMDirectoryResult getDirectoryResult() {
            return this.directoryResult;
        }

        public List<OzoneAcl> getAcls() {
            return this.acls;
        }
    }
}

