/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMReplayException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyCreateRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyCreateRequest.class);

    public OMKeyCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.CreateKeyRequest createKeyRequest = this.getOmRequest().getCreateKeyRequest();
        Preconditions.checkNotNull((Object)createKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = createKeyRequest.getKeyArgs();
        OzoneManagerProtocolProtos.CreateKeyRequest.Builder newCreateKeyRequest = null;
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = null;
        if (!keyArgs.getIsMultipartKey()) {
            HddsProtos.ReplicationType type;
            long scmBlockSize = ozoneManager.getScmBlockSize();
            long requestedSize = keyArgs.getDataSize() > 0L ? keyArgs.getDataSize() : scmBlockSize;
            boolean useRatis = ozoneManager.shouldUseRatis();
            HddsProtos.ReplicationFactor factor = keyArgs.getFactor();
            if (factor == null) {
                HddsProtos.ReplicationFactor replicationFactor = factor = useRatis ? HddsProtos.ReplicationFactor.THREE : HddsProtos.ReplicationFactor.ONE;
            }
            if ((type = keyArgs.getType()) == null) {
                type = useRatis ? HddsProtos.ReplicationType.RATIS : HddsProtos.ReplicationType.STAND_ALONE;
            }
            List<OmKeyLocationInfo> omKeyLocationInfoList = this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), type, factor, new ExcludeList(), requestedSize, scmBlockSize, ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMNodeId());
            newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setType(type).setFactor(factor).setDataSize(requestedSize);
            newKeyArgs.addAllKeyLocations((Iterable)omKeyLocationInfoList.stream().map(OmKeyLocationInfo::getProtobuf).collect(Collectors.toList()));
        } else {
            newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now());
        }
        newCreateKeyRequest = createKeyRequest.toBuilder().setKeyArgs(newKeyArgs).setClientID(UniqueId.next());
        return this.getOmRequest().toBuilder().setCreateKeyRequest(newCreateKeyRequest).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        createKeyRequest = this.getOmRequest().getCreateKeyRequest();
        keyArgs = createKeyRequest.getKeyArgs();
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        keyName = keyArgs.getKeyName();
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumKeyAllocates();
        omMetadataManager = ozoneManager.getMetadataManager();
        omKeyInfo = null;
        locations = new ArrayList<OmKeyLocationInfo>();
        encryptionInfo = Optional.absent();
        acquireLock = false;
        omClientResponse = null;
        omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CreateKey).setStatus(OzoneManagerProtocolProtos.Status.OK);
        exception = null;
        result = null;
        try {
            this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
            acquireLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            dbKeyName = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
            dbKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)dbKeyName);
            if (dbKeyInfo != null && this.isReplay(ozoneManager, (WithObjectID)dbKeyInfo, trxnLogIndex)) {
                throw new OMReplayException();
            }
            bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
            encryptionInfo = this.getFileEncryptionInfo(ozoneManager, bucketInfo);
            omKeyInfo = this.prepareKeyInfo(omMetadataManager, keyArgs, dbKeyInfo, keyArgs.getDataSize(), locations, (FileEncryptionInfo)encryptionInfo.orNull(), ozoneManager.getPrefixManager(), bucketInfo, trxnLogIndex, ozoneManager.isRatisEnabled());
            openVersion = omKeyInfo.getLatestVersionLocations().getVersion();
            clientID = createKeyRequest.getClientID();
            dbOpenKeyName = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
            omKeyInfo.appendNewBlocks(keyArgs.getKeyLocationsList().stream().map((Function<OzoneManagerProtocolProtos.KeyLocation, OmKeyLocationInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFromProtobuf(org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$KeyLocation ), (Lorg/apache/hadoop/ozone/protocol/proto/OzoneManagerProtocolProtos$KeyLocation;)Lorg/apache/hadoop/ozone/om/helpers/OmKeyLocationInfo;)()).collect(Collectors.toList()), false);
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)dbOpenKeyName), new CacheValue(Optional.of((Object)omKeyInfo), trxnLogIndex));
            omResponse.setCreateKeyResponse(OzoneManagerProtocolProtos.CreateKeyResponse.newBuilder().setKeyInfo(omKeyInfo.getProtobuf()).setID(clientID).setOpenVersion(openVersion).build()).setCmdType(OzoneManagerProtocolProtos.Type.CreateKey);
            omClientResponse = new OMKeyCreateResponse(omResponse.build(), omKeyInfo, clientID);
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            block15: {
                try {
                    if (ex instanceof OMReplayException) {
                        result = OMClientRequest.Result.REPLAY;
                        omClientResponse = new OMKeyCreateResponse(this.createReplayOMResponse(omResponse));
                        break block15;
                    }
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omMetrics.incNumKeyAllocateFails();
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateKey);
                    omClientResponse = new OMKeyCreateResponse(this.createErrorOMResponse(omResponse, exception));
                }
                catch (Throwable var28_26) {
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquireLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    throw var28_26;
                }
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquireLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl63
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (acquireLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        if (result != OMClientRequest.Result.REPLAY) {
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.ALLOCATE_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        }
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$OMClientRequest$Result[result.ordinal()]) {
            case 1: {
                OMKeyCreateRequest.LOG.debug("Key created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case 2: {
                OMKeyCreateRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)trxnLogIndex, (Object)createKeyRequest);
                break;
            }
            case 3: {
                OMKeyCreateRequest.LOG.error("Key creation failed. Volume:{}, Bucket:{}, Key{}. Exception:{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                OMKeyCreateRequest.LOG.error("Unrecognized Result for OMKeyCreateRequest: {}", (Object)createKeyRequest);
            }
        }
        return omClientResponse;
    }
}

