/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMReplayException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyDeleteRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyDeleteRequest.class);

    public OMKeyDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.DeleteKeyRequest deleteKeyRequest = this.getOmRequest().getDeleteKeyRequest();
        Preconditions.checkNotNull((Object)deleteKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = deleteKeyRequest.getKeyArgs();
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now());
        return this.getOmRequest().toBuilder().setDeleteKeyRequest(deleteKeyRequest.toBuilder().setKeyArgs(newKeyArgs)).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        deleteKeyRequest = this.getOmRequest().getDeleteKeyRequest();
        deleteKeyArgs = deleteKeyRequest.getKeyArgs();
        volumeName = deleteKeyArgs.getVolumeName();
        bucketName = deleteKeyArgs.getBucketName();
        keyName = deleteKeyArgs.getKeyName();
        omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumKeyDeletes();
        auditLogger = ozoneManager.getAuditLogger();
        userInfo = this.getOmRequest().getUserInfo();
        auditMap = this.buildKeyArgsAuditMap(deleteKeyArgs);
        omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.DeleteKey).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        omMetadataManager = ozoneManager.getMetadataManager();
        exception = null;
        acquiredLock = false;
        omClientResponse = null;
        result = null;
        try {
            this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.DELETE, OzoneObj.ResourceType.KEY);
            objectKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
            acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            omKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)objectKey);
            if (omKeyInfo == null) {
                throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (this.isReplay(ozoneManager, (WithObjectID)omKeyInfo, trxnLogIndex)) {
                throw new OMReplayException();
            }
            omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, keyName)), new CacheValue(Optional.absent(), trxnLogIndex));
            omClientResponse = new OMKeyDeleteResponse(omResponse.setDeleteKeyResponse(OzoneManagerProtocolProtos.DeleteKeyResponse.newBuilder()).build(), omKeyInfo, ozoneManager.isRatisEnabled());
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            block16: {
                try {
                    if (ex instanceof OMReplayException) {
                        result = OMClientRequest.Result.REPLAY;
                        omClientResponse = new OMKeyDeleteResponse(this.createReplayOMResponse(omResponse));
                        break block16;
                    }
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyDeleteResponse(this.createErrorOMResponse(omResponse, exception));
                }
                catch (Throwable var22_22) {
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    throw var22_22;
                }
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl54
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (acquiredLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        if (result != OMClientRequest.Result.REPLAY) {
            this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_KEY, auditMap, exception, userInfo));
        }
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$OMClientRequest$Result[result.ordinal()]) {
            case 1: {
                omMetrics.decNumKeys();
                OMKeyDeleteRequest.LOG.debug("Key deleted. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case 2: {
                OMKeyDeleteRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)trxnLogIndex, (Object)deleteKeyRequest);
                break;
            }
            case 3: {
                omMetrics.incNumKeyDeleteFails();
                OMKeyDeleteRequest.LOG.error("Key delete failed. Volume:{}, Bucket:{}, Key{}. Exception:{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                OMKeyDeleteRequest.LOG.error("Unrecognized Result for OMKeyDeleteRequest: {}", (Object)deleteKeyRequest);
            }
        }
        return omClientResponse;
    }
}

