/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyPurgeResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyPurgeRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyPurgeRequest.class);

    public OMKeyPurgeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        omMetadataManager = ozoneManager.getMetadataManager();
        purgeKeysRequest = this.getOmRequest().getPurgeKeysRequest();
        bucketDeletedKeysList = purgeKeysRequest.getDeletedKeysList();
        keysToBePurgedList = new ArrayList<String>();
        omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.PurgeKeys).setPurgeKeysResponse(OzoneManagerProtocolProtos.PurgeKeysResponse.newBuilder().build()).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        omClientResponse = null;
        success = true;
        exception = null;
        for (OzoneManagerProtocolProtos.DeletedKeys bucketWithDeleteKeys : bucketDeletedKeysList) {
            acquiredLock = false;
            volumeName = bucketWithDeleteKeys.getVolumeName();
            bucketName = bucketWithDeleteKeys.getBucketName();
            keysNotPurged = new ArrayList<String>();
            result = null;
            try {
                acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                for (String deletedKey : bucketWithDeleteKeys.getKeysList()) {
                    repeatedOmKeyInfo = (RepeatedOmKeyInfo)omMetadataManager.getDeletedTable().get((Object)deletedKey);
                    purgeKey = true;
                    if (repeatedOmKeyInfo == null) continue;
                    for (OmKeyInfo omKeyInfo : repeatedOmKeyInfo.getOmKeyInfoList()) {
                        if (!this.isReplay(ozoneManager, (WithObjectID)omKeyInfo, trxnLogIndex)) continue;
                        purgeKey = false;
                        result = OMClientRequest.Result.REPLAY;
                        break;
                    }
                    if (purgeKey) {
                        keysToBePurgedList.add(deletedKey);
                        continue;
                    }
                    keysNotPurged.add(deletedKey);
                }
                ** if (!acquiredLock) goto lbl-1000
            }
            catch (IOException ex) {
                try {
                    success = false;
                    exception = ex;
                    if (!acquiredLock) break;
                }
                catch (Throwable var26_26) {
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    throw var26_26;
                }
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                break;
            }
lbl-1000:
            // 1 sources

            {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
lbl-1000:
            // 2 sources

            {
            }
            if (result != OMClientRequest.Result.REPLAY) continue;
            OMKeyPurgeRequest.LOG.debug("Replayed Transaction {}. Request: {}", (Object)trxnLogIndex, (Object)purgeKeysRequest);
            if (keysNotPurged.isEmpty()) continue;
            notPurgeList = new StringBuilder();
            for (String key : keysNotPurged) {
                notPurgeList.append(", ").append(key);
            }
            OMKeyPurgeRequest.LOG.debug("Following keys from Volume:{}, Bucket:{} will not be purged: {}", (Object)notPurgeList.toString().substring(2));
        }
        if (success) {
            if (OMKeyPurgeRequest.LOG.isDebugEnabled()) {
                if (keysToBePurgedList.isEmpty()) {
                    OMKeyPurgeRequest.LOG.debug("No keys will be purged as part of KeyPurgeRequest: {}", (Object)purgeKeysRequest);
                } else {
                    OMKeyPurgeRequest.LOG.debug("Following keys will be purged as part of KeyPurgeRequest: {} - {}", (Object)purgeKeysRequest, (Object)String.join((CharSequence)",", keysToBePurgedList));
                }
            }
            omClientResponse = new OMKeyPurgeResponse(omResponse.build(), keysToBePurgedList);
        } else {
            omClientResponse = new OMKeyPurgeResponse(this.createErrorOMResponse(omResponse, exception));
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        return omClientResponse;
    }
}

