/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAddAclRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.acl.OMKeyAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyRemoveAclRequest
extends OMKeyAclRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyAddAclRequest.class);
    private String path;
    private List<OzoneAcl> ozoneAcls;

    public OMKeyRemoveAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
        OzoneManagerProtocolProtos.RemoveAclRequest removeAclRequest = this.getOmRequest().getRemoveAclRequest();
        this.path = removeAclRequest.getObj().getPath();
        this.ozoneAcls = Lists.newArrayList((Object[])new OzoneAcl[]{OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)removeAclRequest.getAcl())});
    }

    @Override
    String getPath() {
        return this.path;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.RemoveAcl).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmKeyInfo omKeyInfo, boolean operationResult) {
        omResponse.setSuccess(operationResult);
        omResponse.setRemoveAclResponse(OzoneManagerProtocolProtos.RemoveAclResponse.newBuilder().setResponse(operationResult));
        return new OMKeyAclResponse(omResponse.build(), omKeyInfo);
    }

    @Override
    void onComplete(OMClientRequest.Result result, boolean operationResult, IOException exception, long trxnLogIndex) {
        switch (result) {
            case SUCCESS: {
                if (!LOG.isDebugEnabled()) break;
                if (operationResult) {
                    LOG.debug("Remove acl: {} to path: {} success!", this.ozoneAcls, (Object)this.path);
                    break;
                }
                LOG.debug("Acl {} not removed from path {} as it does not exist", this.ozoneAcls, (Object)this.path);
                break;
            }
            case REPLAY: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)trxnLogIndex, (Object)this.getOmRequest());
                break;
            }
            case FAILURE: {
                LOG.error("Remove acl {} to path {} failed!", new Object[]{this.ozoneAcls, this.path, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyRemoveAclRequest: {}", (Object)this.getOmRequest());
            }
        }
    }

    @Override
    boolean apply(OmKeyInfo omKeyInfo, long trxnLogIndex) {
        return omKeyInfo.removeAcl(this.ozoneAcls.get(0));
    }
}

