/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl.prefix;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManagerImpl;
import org.apache.hadoop.ozone.om.exceptions.OMReplayException;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.acl.prefix.OMPrefixAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public abstract class OMPrefixAclRequest
extends OMClientRequest {
    public OMPrefixAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        omPrefixInfo = null;
        omResponse = this.onInit();
        omClientResponse = null;
        exception = null;
        omMetadataManager = ozoneManager.getMetadataManager();
        lockAcquired = false;
        volume = null;
        bucket = null;
        key = null;
        operationResult = null;
        opResult = false;
        result = null;
        prefixManager = (PrefixManagerImpl)ozoneManager.getPrefixManager();
        try {
            prefixPath = this.getOzoneObj().getPath();
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.PREFIX, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, bucket, key);
            }
            lockAcquired = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            omPrefixInfo = (OmPrefixInfo)omMetadataManager.getPrefixTable().get((Object)prefixPath);
            if (omPrefixInfo != null && this.isReplay(ozoneManager, (WithObjectID)omPrefixInfo, trxnLogIndex)) {
                throw new OMReplayException();
            }
            try {
                operationResult = this.apply(prefixManager, omPrefixInfo, trxnLogIndex);
            }
            catch (IOException ex) {
                operationResult = new PrefixManagerImpl.OMPrefixAclOpResult(null, false);
            }
            omPrefixInfo = operationResult.getOmPrefixInfo();
            omPrefixInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            if (this.getOmRequest().hasRemoveAclRequest() && omPrefixInfo.getAcls().size() == 0) {
                omMetadataManager.getPrefixTable().addCacheEntry(new CacheKey((Object)prefixPath), new CacheValue(Optional.absent(), trxnLogIndex));
            } else {
                omMetadataManager.getPrefixTable().addCacheEntry(new CacheKey((Object)prefixPath), new CacheValue(Optional.of((Object)omPrefixInfo), trxnLogIndex));
            }
            opResult = operationResult.isSuccess();
            omClientResponse = this.onSuccess(omResponse, omPrefixInfo, opResult);
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            block14: {
                try {
                    if (ex instanceof OMReplayException) {
                        result = OMClientRequest.Result.REPLAY;
                        omClientResponse = this.onReplay(omResponse);
                        break block14;
                    }
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.onFailure(omResponse, ex);
                }
                catch (Throwable var20_20) {
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (lockAcquired) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{this.getOzoneObj().getPath()});
                    }
                    throw var20_20;
                }
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (lockAcquired) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{this.getOzoneObj().getPath()});
            } else {
                ** GOTO lbl59
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (lockAcquired) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{this.getOzoneObj().getPath()});
        }
        this.onComplete(opResult, exception, ozoneManager.getMetrics(), result, trxnLogIndex);
        return omClientResponse;
    }

    abstract OzoneObj getOzoneObj();

    abstract OzoneManagerProtocolProtos.OMResponse.Builder onInit();

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmPrefixInfo var2, boolean var3);

    abstract OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder var1, IOException var2);

    OMClientResponse onReplay(OzoneManagerProtocolProtos.OMResponse.Builder omResonse) {
        return new OMPrefixAclResponse(this.createReplayOMResponse(omResonse));
    }

    abstract void onComplete(boolean var1, IOException var2, OMMetrics var3, OMClientRequest.Result var4, long var5);

    abstract PrefixManagerImpl.OMPrefixAclOpResult apply(PrefixManagerImpl var1, OmPrefixInfo var2, long var3) throws IOException;
}

