/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl.prefix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.PrefixManagerImpl;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.acl.prefix.OMPrefixAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.prefix.OMPrefixAddAclRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.acl.prefix.OMPrefixAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMPrefixSetAclRequest
extends OMPrefixAclRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMPrefixAddAclRequest.class);
    private OzoneObj ozoneObj;
    private List<OzoneAcl> ozoneAcls;

    public OMPrefixSetAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
        OzoneManagerProtocolProtos.SetAclRequest setAclRequest = this.getOmRequest().getSetAclRequest();
        this.ozoneObj = OzoneObjInfo.fromProtobuf((OzoneManagerProtocolProtos.OzoneObj)setAclRequest.getObj());
        this.ozoneAcls = new ArrayList<OzoneAcl>();
        setAclRequest.getAclList().forEach(aclInfo -> this.ozoneAcls.add(OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)aclInfo)));
    }

    @Override
    OzoneObj getOzoneObj() {
        return this.ozoneObj;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetAcl).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmPrefixInfo omPrefixInfo, boolean operationResult) {
        omResponse.setSuccess(operationResult);
        omResponse.setSetAclResponse(OzoneManagerProtocolProtos.SetAclResponse.newBuilder().setResponse(operationResult));
        return new OMPrefixAclResponse(omResponse.build(), omPrefixInfo);
    }

    @Override
    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, IOException exception) {
        return new OMPrefixAclResponse(this.createErrorOMResponse(omResponse, exception));
    }

    @Override
    void onComplete(boolean operationResult, IOException exception, OMMetrics omMetrics, OMClientRequest.Result result, long trxnLogIndex) {
        switch (result) {
            case SUCCESS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Set acl: {} to path: {} success!", this.ozoneAcls, (Object)this.ozoneObj.getPath());
                break;
            }
            case REPLAY: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)trxnLogIndex, (Object)this.getOmRequest());
                break;
            }
            case FAILURE: {
                omMetrics.incNumBucketUpdateFails();
                LOG.error("Set acl {} to path {} failed!", new Object[]{this.ozoneAcls, this.ozoneObj.getPath(), exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMPrefixSetAclRequest: {}", (Object)this.getOmRequest());
            }
        }
    }

    @Override
    PrefixManagerImpl.OMPrefixAclOpResult apply(PrefixManagerImpl prefixManager, OmPrefixInfo omPrefixInfo, long trxnLogIndex) throws IOException {
        return prefixManager.setAcl(this.ozoneObj, this.ozoneAcls, omPrefixInfo, trxnLogIndex);
    }
}

