/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.bucket;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketCreateResponse;
import org.apache.hadoop.ozone.om.response.s3.bucket.S3BucketCreateResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BucketCreateRequest
extends OMVolumeRequest {
    private static final String S3_ADMIN_NAME = "OzoneS3Manager";
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerProtocolProtos.S3CreateBucketRequest.class);

    public S3BucketCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.S3CreateBucketRequest s3CreateBucketRequest = this.getOmRequest().getCreateS3BucketRequest();
        Preconditions.checkNotNull((Object)s3CreateBucketRequest);
        OzoneManagerProtocolProtos.S3CreateBucketRequest.Builder newS3CreateBucketRequest = s3CreateBucketRequest.toBuilder().setS3CreateVolumeInfo(OzoneManagerProtocolProtos.S3CreateVolumeInfo.newBuilder().setCreationTime(Time.now()));
        int bucketLength = s3CreateBucketRequest.getS3Bucketname().length();
        if (bucketLength < 3 || bucketLength >= 64) {
            throw new OMException("S3BucketName must be at least 3 and not more than 63 characters long", OMException.ResultCodes.S3_BUCKET_INVALID_LENGTH);
        }
        return this.getOmRequest().toBuilder().setCreateS3BucketRequest(newS3CreateBucketRequest).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        block17: {
            s3CreateBucketRequest = this.getOmRequest().getCreateS3BucketRequest();
            userName = s3CreateBucketRequest.getUserName();
            s3BucketName = s3CreateBucketRequest.getS3Bucketname();
            omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CreateS3Bucket).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumS3BucketCreates();
            omMetadataManager = ozoneManager.getMetadataManager();
            exception = null;
            volumeCreated = false;
            acquiredVolumeLock = false;
            acquiredUserLock = false;
            acquiredS3Lock = false;
            success = true;
            volumeName = S3BucketCreateRequest.formatOzoneVolumeName(userName);
            omClientResponse = null;
            acquiredS3Lock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
            if (!omMetadataManager.getS3Table().isExist((Object)s3BucketName)) ** GOTO lbl33
            omBucketKey = omMetadataManager.getBucketKey(volumeName, s3BucketName);
            dbBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omBucketKey);
            if (dbBucketInfo == null) break block17;
            if (!this.isReplay(ozoneManager, (WithObjectID)dbBucketInfo, trxnLogIndex)) ** GOTO lbl32
            S3BucketCreateRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)trxnLogIndex, (Object)s3CreateBucketRequest);
            var21_23 = new S3BucketCreateResponse(this.createReplayOMResponse(omResponse));
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredS3Lock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
            }
            return var21_23;
        }
        try {
            block18: {
                throw new OMException("S3Bucket " + s3BucketName + " mapping already exists in S3 table but Bucket does not exist.", OMException.ResultCodes.S3_BUCKET_ALREADY_EXISTS);
lbl32:
                // 1 sources

                throw new OMException("S3Bucket " + s3BucketName + " already exists", OMException.ResultCodes.S3_BUCKET_ALREADY_EXISTS);
lbl33:
                // 1 sources

                omVolumeCreateResponse = null;
                try {
                    acquiredVolumeLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
                    acquiredUserLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
                    volumeKey = omMetadataManager.getVolumeKey(volumeName);
                    if (!omMetadataManager.getVolumeTable().isExist((Object)volumeKey)) {
                        omVolumeArgs = this.createOmVolumeArgs(volumeName, userName, s3CreateBucketRequest.getS3CreateVolumeInfo().getCreationTime(), trxnLogIndex);
                        volumeList = (OzoneManagerProtocolProtos.UserVolumeInfo)omMetadataManager.getUserTable().get((Object)omMetadataManager.getUserKey(userName));
                        volumeList = this.addVolumeToOwnerList(volumeList, volumeName, userName, ozoneManager.getMaxUserVolumeCount(), trxnLogIndex);
                        this.createVolume(omMetadataManager, omVolumeArgs, volumeList, volumeKey, omMetadataManager.getUserKey(userName), trxnLogIndex);
                        volumeCreated = true;
                        omVolumeCreateResponse = new OMVolumeCreateResponse(omResponse.build(), omVolumeArgs, volumeList);
                    }
                    if (!acquiredUserLock) break block18;
                }
                catch (Throwable var23_26) {
                    if (acquiredUserLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
                    }
                    if (acquiredVolumeLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
                    }
                    throw var23_26;
                }
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{userName});
            }
            if (acquiredVolumeLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
            }
            omBucketInfo = this.createBucket(ozoneManager, volumeName, s3BucketName, userName, s3CreateBucketRequest.getS3CreateVolumeInfo().getCreationTime(), trxnLogIndex);
            omMetadataManager.getS3Table().addCacheEntry(new CacheKey((Object)s3BucketName), new CacheValue(Optional.of((Object)S3BucketCreateRequest.formatS3MappingName(volumeName, s3BucketName)), trxnLogIndex));
            omBucketCreateResponse = new OMBucketCreateResponse(omResponse.build(), omBucketInfo);
            omClientResponse = new S3BucketCreateResponse(omResponse.setCreateS3BucketResponse(OzoneManagerProtocolProtos.S3CreateBucketResponse.newBuilder()).build(), omVolumeCreateResponse, omBucketCreateResponse, s3BucketName, S3BucketCreateRequest.formatS3MappingName(volumeName, s3BucketName));
        }
        catch (IOException ex) {
            try {
                success = false;
                exception = ex;
                omClientResponse = new S3BucketCreateResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var24_27) {
                this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                if (acquiredS3Lock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
                }
                throw var24_27;
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredS3Lock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
            } else {
                ** GOTO lbl79
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (acquiredS3Lock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.CREATE_S3_BUCKET, this.buildAuditMap(userName, s3BucketName), exception, this.getOmRequest().getUserInfo()));
        if (success) {
            S3BucketCreateRequest.LOG.debug("S3Bucket is successfully created for userName: {}, s3BucketName {}, volumeName {}", new Object[]{userName, s3BucketName, volumeName});
            S3BucketCreateRequest.updateMetrics(omMetrics, volumeCreated);
        } else {
            S3BucketCreateRequest.LOG.error("S3Bucket Creation Failed for userName: {}, s3BucketName {}, VolumeName {}", new Object[]{userName, s3BucketName, volumeName});
            omMetrics.incNumS3BucketCreateFails();
        }
        return omClientResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OmBucketInfo createBucket(OzoneManager ozoneManager, String volumeName, String s3BucketName, String userName, long creationTime, long transactionLogIndex) throws IOException {
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        boolean acquireBucketLock = false;
        OmBucketInfo omBucketInfo = null;
        try {
            acquireBucketLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, s3BucketName});
            String bucketKey = omMetadataManager.getBucketKey(volumeName, s3BucketName);
            if (omMetadataManager.getBucketTable().isExist((Object)bucketKey)) {
                throw new OMException("Bucket " + s3BucketName + " already exists", OMException.ResultCodes.BUCKET_ALREADY_EXISTS);
            }
            omBucketInfo = this.createOmBucketInfo(volumeName, s3BucketName, userName, creationTime, transactionLogIndex);
            omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), new CacheValue(Optional.of((Object)omBucketInfo), transactionLogIndex));
            if (!acquireBucketLock) return omBucketInfo;
        }
        catch (Throwable throwable) {
            if (!acquireBucketLock) throw throwable;
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, s3BucketName});
            throw throwable;
        }
        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, s3BucketName});
        return omBucketInfo;
    }

    private static void updateMetrics(OMMetrics omMetrics, boolean isVolumeCreated) {
        if (isVolumeCreated) {
            omMetrics.incNumVolumes();
        }
        omMetrics.incNumBuckets();
        omMetrics.incNumS3Buckets();
    }

    @VisibleForTesting
    public static String formatOzoneVolumeName(String userName) {
        return String.format("s3%s", userName);
    }

    @VisibleForTesting
    public static String formatS3MappingName(String volumeName, String bucketName) {
        return String.format("%s/%s", volumeName, bucketName);
    }

    private OmVolumeArgs createOmVolumeArgs(String volumeName, String userName, long creationTime, long transactionLogIndex) throws IOException {
        long objectID = OMFileRequest.getObjIDFromTxId(transactionLogIndex);
        OmVolumeArgs.Builder builder = OmVolumeArgs.newBuilder().setAdminName(S3_ADMIN_NAME).setVolume(volumeName).setQuotaInBytes(0x1000000000000000L).setOwnerName(userName).setCreationTime(creationTime).setObjectID(objectID).setUpdateID(transactionLogIndex);
        for (OzoneAcl acl : this.getDefaultAcls(userName)) {
            builder.addOzoneAcls(OzoneAcl.toProtobuf((OzoneAcl)acl));
        }
        return builder.build();
    }

    private OmBucketInfo createOmBucketInfo(String volumeName, String s3BucketName, String userName, long creationTime, long transactionLogIndex) {
        OmBucketInfo.Builder builder = OmBucketInfo.newBuilder().setVolumeName(volumeName).setBucketName(s3BucketName).setIsVersionEnabled(Boolean.FALSE).setStorageType(StorageType.DEFAULT).setCreationTime(creationTime).setObjectID(transactionLogIndex).setUpdateID(transactionLogIndex);
        builder.setAcls(this.getDefaultAcls(userName));
        return builder.build();
    }

    private Map<String, String> buildAuditMap(String userName, String s3BucketName) {
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put(userName, "username");
        auditMap.put(s3BucketName, "s3Bucket");
        return auditMap;
    }

    private List<OzoneAcl> getDefaultAcls(String userName) {
        UserGroupInformation ugi = this.createUGI();
        return OzoneAcl.parseAcls((String)("user:" + (ugi == null ? userName : ugi.getUserName()) + ":a,user:" + S3_ADMIN_NAME + ":a"));
    }
}

