/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.bucket;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.bucket.S3BucketDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BucketDeleteRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(S3BucketDeleteRequest.class);

    public S3BucketDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.S3DeleteBucketRequest s3DeleteBucketRequest = this.getOmRequest().getDeleteS3BucketRequest();
        int bucketLength = s3DeleteBucketRequest.getS3BucketName().length();
        if (bucketLength < 3 || bucketLength >= 64) {
            throw new OMException("S3BucketName must be at least 3 and not more than 63 characters long", OMException.ResultCodes.S3_BUCKET_INVALID_LENGTH);
        }
        return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        block15: {
            s3DeleteBucketRequest = this.getOmRequest().getDeleteS3BucketRequest();
            s3BucketName = s3DeleteBucketRequest.getS3BucketName();
            omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.DeleteS3Bucket).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumS3BucketDeletes();
            exception = null;
            acquiredS3Lock = false;
            acquiredBucketLock = false;
            volumeName = null;
            omMetadataManager = ozoneManager.getMetadataManager();
            omClientResponse = null;
            acquiredS3Lock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
            s3Mapping = (String)omMetadataManager.getS3Table().get((Object)s3BucketName);
            if (s3Mapping == null) {
                throw new OMException("S3Bucket " + s3BucketName + " not found", OMException.ResultCodes.S3_BUCKET_NOT_FOUND);
            }
            volumeName = this.getOzoneVolumeName(s3Mapping);
            acquiredBucketLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, s3BucketName});
            bucketKey = omMetadataManager.getBucketKey(volumeName, s3BucketName);
            dbBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
            if (dbBucketInfo == null) ** GOTO lbl34
            if (!this.isReplay(ozoneManager, (WithObjectID)dbBucketInfo, transactionLogIndex)) break block15;
            S3BucketDeleteRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)transactionLogIndex, (Object)s3DeleteBucketRequest);
            var18_18 = new S3BucketDeleteResponse(this.createReplayOMResponse(omResponse));
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, s3BucketName});
            }
            if (acquiredS3Lock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
            }
            return var18_18;
        }
        try {
            block17: {
                break block17;
lbl34:
                // 1 sources

                S3BucketDeleteRequest.LOG.debug("bucket: {} not found ", (Object)bucketKey);
                throw new OMException("Bucket doesn't exist", OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), new CacheValue(Optional.absent(), transactionLogIndex));
            omMetadataManager.getS3Table().addCacheEntry(new CacheKey((Object)s3BucketName), new CacheValue(Optional.absent(), transactionLogIndex));
            omResponse.setDeleteS3BucketResponse(OzoneManagerProtocolProtos.S3DeleteBucketResponse.newBuilder());
            omClientResponse = new S3BucketDeleteResponse(omResponse.build(), s3BucketName, volumeName);
        }
        catch (IOException ex) {
            try {
                exception = ex;
                omClientResponse = new S3BucketDeleteResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var19_19) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredBucketLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, s3BucketName});
                }
                if (acquiredS3Lock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
                }
                throw var19_19;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, s3BucketName});
            }
            if (acquiredS3Lock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
            } else {
                ** GOTO lbl65
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (acquiredBucketLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, s3BucketName});
        }
        if (acquiredS3Lock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.S3_BUCKET_LOCK, new String[]{s3BucketName});
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.DELETE_S3_BUCKET, this.buildAuditMap(s3BucketName), exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            S3BucketDeleteRequest.LOG.debug("S3Bucket {} successfully deleted", (Object)s3BucketName);
            omMetrics.decNumS3Buckets();
            omMetrics.decNumBuckets();
            return omClientResponse;
        }
        S3BucketDeleteRequest.LOG.error("S3Bucket Deletion failed for S3Bucket:{}", (Object)s3BucketName, (Object)exception);
        omMetrics.incNumS3BucketDeleteFails();
        return omClientResponse;
    }

    private String getOzoneVolumeName(String s3Mapping) throws IOException {
        return s3Mapping.split("/")[0];
    }

    private Map<String, String> buildAuditMap(String s3BucketName) {
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put(s3BucketName, "s3Bucket");
        return auditMap;
    }
}

