/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3InitiateMultipartUploadResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3InitiateMultipartUploadRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(S3InitiateMultipartUploadRequest.class);

    public S3InitiateMultipartUploadRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) {
        OzoneManagerProtocolProtos.MultipartInfoInitiateRequest multipartInfoInitiateRequest = this.getOmRequest().getInitiateMultiPartUploadRequest();
        Preconditions.checkNotNull((Object)multipartInfoInitiateRequest);
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = multipartInfoInitiateRequest.getKeyArgs().toBuilder().setMultipartUploadID(UUID.randomUUID().toString() + "-" + UniqueId.next()).setModificationTime(Time.now());
        return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).setInitiateMultiPartUploadRequest(multipartInfoInitiateRequest.toBuilder().setKeyArgs(newKeyArgs)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        multipartInfoInitiateRequest = this.getOmRequest().getInitiateMultiPartUploadRequest();
        keyArgs = multipartInfoInitiateRequest.getKeyArgs();
        Preconditions.checkNotNull((Object)keyArgs.getMultipartUploadID());
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        keyName = keyArgs.getKeyName();
        omMetadataManager = ozoneManager.getMetadataManager();
        ozoneManager.getMetrics().incNumInitiateMultipartUploads();
        acquiredBucketLock = false;
        exception = null;
        multipartKeyInfo = null;
        omKeyInfo = null;
        result = null;
        objectID = OMFileRequest.getObjIDFromTxId(transactionLogIndex);
        omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.InitiateMultiPartUpload).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        omClientResponse = null;
        try {
            acquiredBucketLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, keyArgs.getMultipartUploadID());
            multipartKeyInfo = new OmMultipartKeyInfo.Builder().setUploadID(keyArgs.getMultipartUploadID()).setCreationTime(keyArgs.getModificationTime()).setReplicationType(keyArgs.getType()).setReplicationFactor(keyArgs.getFactor()).setObjectID(objectID).setUpdateID(transactionLogIndex).build();
            omKeyInfo = new OmKeyInfo.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setReplicationType(keyArgs.getType()).setReplicationFactor(keyArgs.getFactor()).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList<E>()))).setAcls(OzoneAclUtil.fromProtobuf((List)keyArgs.getAclsList())).setObjectID(objectID).setUpdateID(transactionLogIndex).build();
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)omKeyInfo), transactionLogIndex));
            omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)multipartKeyInfo), transactionLogIndex));
            omClientResponse = new S3InitiateMultipartUploadResponse(omResponse.setInitiateMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartInfoInitiateResponse.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setMultipartUploadID(keyArgs.getMultipartUploadID())).build(), multipartKeyInfo, omKeyInfo);
            result = Result.SUCCESS;
        }
        catch (IOException ex) {
            try {
                result = Result.FAILURE;
                exception = ex;
                omClientResponse = new S3InitiateMultipartUploadResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var21_20) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredBucketLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var21_20;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredBucketLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl46
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (acquiredBucketLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, this.buildKeyArgsAuditMap(keyArgs), exception, this.getOmRequest().getUserInfo()));
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$s3$multipart$S3InitiateMultipartUploadRequest$Result[result.ordinal()]) {
            case 1: {
                S3InitiateMultipartUploadRequest.LOG.debug("S3 InitiateMultipart Upload request for Key {} in Volume/Bucket {}/{} is successfully completed", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case 2: {
                ozoneManager.getMetrics().incNumInitiateMultipartUploadFails();
                S3InitiateMultipartUploadRequest.LOG.error("S3 InitiateMultipart Upload request for Key {} in Volume/Bucket {}/{} is failed", new Object[]{keyName, volumeName, bucketName, exception});
            }
            default: {
                S3InitiateMultipartUploadRequest.LOG.error("Unrecognized Result for S3InitiateMultipartUploadRequest: {}", (Object)multipartInfoInitiateRequest);
            }
        }
        return omClientResponse;
    }

    private static enum Result {
        SUCCESS,
        REPLAY,
        FAILURE;

    }
}

