/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMReplayException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCommitPartResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadCommitPartRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(S3MultipartUploadCommitPartRequest.class);

    public S3MultipartUploadCommitPartRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) {
        OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest multipartCommitUploadPartRequest = this.getOmRequest().getCommitMultiPartUploadRequest();
        return this.getOmRequest().toBuilder().setCommitMultiPartUploadRequest(multipartCommitUploadPartRequest.toBuilder().setKeyArgs(multipartCommitUploadPartRequest.getKeyArgs().toBuilder().setModificationTime(Time.now()))).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        multipartCommitUploadPartRequest = this.getOmRequest().getCommitMultiPartUploadRequest();
        keyArgs = multipartCommitUploadPartRequest.getKeyArgs();
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        keyName = keyArgs.getKeyName();
        omMetadataManager = ozoneManager.getMetadataManager();
        ozoneManager.getMetrics().incNumCommitMultipartUploadParts();
        acquiredLock = false;
        exception = null;
        partName = null;
        omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CommitMultiPartUpload).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        omClientResponse = null;
        oldPartKeyInfo = null;
        openKey = null;
        omKeyInfo = null;
        multipartKey = null;
        multipartKeyInfo = null;
        result = null;
        try {
            acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            uploadID = keyArgs.getMultipartUploadID();
            multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
            clientID = multipartCommitUploadPartRequest.getClientID();
            openKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
            omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)openKey);
            if (omKeyInfo == null) {
                ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                dbKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)ozoneKey);
                if (dbKeyInfo != null && this.isReplay(ozoneManager, (WithObjectID)dbKeyInfo, trxnLogIndex)) {
                    throw new OMReplayException();
                }
                throw new OMException("Failed to commit Multipart Upload key, as " + openKey + "entry is not found in the openKey table", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (this.isReplay(ozoneManager, (WithObjectID)omKeyInfo, trxnLogIndex)) {
                throw new OMReplayException();
            }
            omKeyInfo.setDataSize(keyArgs.getDataSize());
            omKeyInfo.updateLocationInfoList(keyArgs.getKeyLocationsList().stream().map((Function<OzoneManagerProtocolProtos.KeyLocation, OmKeyLocationInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFromProtobuf(org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$KeyLocation ), (Lorg/apache/hadoop/ozone/protocol/proto/OzoneManagerProtocolProtos$KeyLocation;)Lorg/apache/hadoop/ozone/om/helpers/OmKeyLocationInfo;)()).collect(Collectors.toList()));
            omKeyInfo.setModificationTime(keyArgs.getModificationTime());
            omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            partName = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName) + clientID;
            if (multipartKeyInfo == null) {
                throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            partNumber = keyArgs.getMultipartNumber();
            oldPartKeyInfo = multipartKeyInfo.getPartKeyInfo(partNumber);
            partKeyInfo = OzoneManagerProtocolProtos.PartKeyInfo.newBuilder();
            partKeyInfo.setPartName(partName);
            partKeyInfo.setPartNumber(partNumber);
            partKeyInfo.setPartKeyInfo(omKeyInfo.getProtobuf());
            multipartKeyInfo.addPartKeyInfo(partNumber, partKeyInfo.build());
            multipartKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
            omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)multipartKeyInfo), trxnLogIndex));
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)openKey), new CacheValue(Optional.absent(), trxnLogIndex));
            omResponse.setCommitMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse.newBuilder().setPartName(partName));
            omClientResponse = new S3MultipartUploadCommitPartResponse(omResponse.build(), multipartKey, openKey, omKeyInfo, multipartKeyInfo, oldPartKeyInfo, ozoneManager.isRatisEnabled());
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            block17: {
                try {
                    if (ex instanceof OMReplayException) {
                        result = OMClientRequest.Result.REPLAY;
                        omClientResponse = new S3MultipartUploadCommitPartResponse(this.createReplayOMResponse(omResponse));
                        break block17;
                    }
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new S3MultipartUploadCommitPartResponse(this.createErrorOMResponse(omResponse, exception), multipartKey, openKey, omKeyInfo, multipartKeyInfo, oldPartKeyInfo, ozoneManager.isRatisEnabled());
                }
                catch (Throwable var27_28) {
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    throw var27_28;
                }
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl83
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (acquiredLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.COMMIT_MULTIPART_UPLOAD_PARTKEY, this.buildAuditMap(keyArgs, partName), exception, this.getOmRequest().getUserInfo()));
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$OMClientRequest$Result[result.ordinal()]) {
            case 1: {
                S3MultipartUploadCommitPartRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)trxnLogIndex, (Object)multipartCommitUploadPartRequest);
                break;
            }
            case 2: {
                S3MultipartUploadCommitPartRequest.LOG.debug("MultipartUpload Commit is successfully for Key:{} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case 3: {
                ozoneManager.getMetrics().incNumCommitMultipartUploadPartFails();
                S3MultipartUploadCommitPartRequest.LOG.error("MultipartUpload Commit is failed for Key:{} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName, exception});
                break;
            }
            default: {
                S3MultipartUploadCommitPartRequest.LOG.error("Unrecognized Result for S3MultipartUploadCommitPartRequest: {}", (Object)multipartCommitUploadPartRequest);
            }
        }
        return omClientResponse;
    }

    private Map<String, String> buildAuditMap(OzoneManagerProtocolProtos.KeyArgs keyArgs, String partName) {
        Map<String, String> auditMap = this.buildKeyArgsAuditMap(keyArgs);
        auditMap.put("partNumber", String.valueOf(keyArgs.getMultipartNumber()));
        auditMap.put("partName", partName);
        return auditMap;
    }
}

