/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMReplayException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCompleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadCompleteRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(S3MultipartUploadCompleteRequest.class);

    public S3MultipartUploadCompleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadCompleteRequest multipartUploadCompleteRequest = this.getOmRequest().getCompleteMultiPartUploadRequest();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartUploadCompleteRequest.getKeyArgs();
        return this.getOmRequest().toBuilder().setCompleteMultiPartUploadRequest(multipartUploadCompleteRequest.toBuilder().setKeyArgs(keyArgs.toBuilder().setModificationTime(Time.now()))).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerDoubleBufferHelper omDoubleBufferHelper) {
        multipartUploadCompleteRequest = this.getOmRequest().getCompleteMultiPartUploadRequest();
        keyArgs = multipartUploadCompleteRequest.getKeyArgs();
        partsList = multipartUploadCompleteRequest.getPartsListList();
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        keyName = keyArgs.getKeyName();
        uploadID = keyArgs.getMultipartUploadID();
        ozoneManager.getMetrics().incNumCompleteMultipartUploads();
        omMetadataManager = ozoneManager.getMetadataManager();
        acquiredLock = false;
        omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CommitMultiPartUpload).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        omClientResponse = null;
        exception = null;
        result = null;
        try {
            acquiredLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
            omKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)ozoneKey);
            if (omKeyInfo != null && this.isReplay(ozoneManager, (WithObjectID)omKeyInfo, trxnLogIndex)) {
                throw new OMReplayException();
            }
            multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
            if (multipartKeyInfo == null) {
                throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            partKeyInfoMap = multipartKeyInfo.getPartKeyInfoMap();
            if (partsList.size() > 0) {
                if (partKeyInfoMap.size() == 0) {
                    S3MultipartUploadCompleteRequest.LOG.error("Complete MultipartUpload failed for key {} , MPU Key has no parts in OM, parts given to upload are {}", (Object)ozoneKey, (Object)partsList);
                    throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.INVALID_PART);
                }
                prevPartNumber = ((OzoneManagerProtocolProtos.Part)partsList.get(0)).getPartNumber();
                partNumbers = new ArrayList<Integer>();
                partsListSize = partsList.size();
                partNumbers.add(prevPartNumber);
                for (i = 1; i < partsListSize; ++i) {
                    currentPartNumber = ((OzoneManagerProtocolProtos.Part)partsList.get(i)).getPartNumber();
                    if (prevPartNumber >= currentPartNumber) {
                        S3MultipartUploadCompleteRequest.LOG.error("PartNumber at index {} is {}, and its previous partNumber at index {} is {} for ozonekey is {}", new Object[]{i, currentPartNumber, i - 1, prevPartNumber, ozoneKey});
                        throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName + "because parts are in Invalid order.", OMException.ResultCodes.INVALID_PART_ORDER);
                    }
                    prevPartNumber = currentPartNumber;
                    partNumbers.add(prevPartNumber);
                }
                partLocationInfos = new ArrayList<E>();
                dataSize = 0L;
                currentPartCount = 0;
                for (OzoneManagerProtocolProtos.Part part : partsList) {
                    ++currentPartCount;
                    partNumber = part.getPartNumber();
                    partName = part.getPartName();
                    partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoMap.get(partNumber);
                    if (partKeyInfo == null || !partName.equals(partKeyInfo.getPartName())) {
                        omPartName = partKeyInfo == null ? null : partKeyInfo.getPartName();
                        throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName + ". Provided Part info is { " + partName + ", " + partNumber + "}, where as OM has partName " + omPartName, OMException.ResultCodes.INVALID_PART);
                    }
                    currentPartKeyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
                    if (currentPartCount != partsListSize && currentPartKeyInfo.getDataSize() < 0x500000L) {
                        S3MultipartUploadCompleteRequest.LOG.error("MultipartUpload: {} Part number: {} size {}  is less than minimum part size {}", new Object[]{ozoneKey, partKeyInfo.getPartNumber(), currentPartKeyInfo.getDataSize(), 0x500000});
                        throw new OMException("Complete Multipart Upload Failed: Entity too small: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.ENTITY_TOO_SMALL);
                    }
                    currentKeyInfoGroup = (OmKeyLocationInfoGroup)currentPartKeyInfo.getKeyLocationVersions().get(0);
                    partLocationInfos.addAll(currentKeyInfoGroup.getLocationList());
                    dataSize += currentPartKeyInfo.getDataSize();
                }
                type = ((OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoMap.lastEntry().getValue()).getPartKeyInfo().getType();
                factor = ((OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoMap.lastEntry().getValue()).getPartKeyInfo().getFactor();
                if (omKeyInfo == null) {
                    keyLocationInfoGroup = new OmKeyLocationInfoGroup(0L, partLocationInfos);
                    dbOpenKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)multipartKey);
                    builder = new OmKeyInfo.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setReplicationFactor(factor).setReplicationType(type).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setDataSize(dataSize).setOmKeyLocationInfos(Collections.singletonList(keyLocationInfoGroup)).setAcls(OzoneAclUtil.fromProtobuf((List)keyArgs.getAclsList()));
                    if (dbOpenKeyInfo.getObjectID() != 0L) {
                        builder.setObjectID(dbOpenKeyInfo.getObjectID());
                    }
                    omKeyInfo = builder.build();
                } else {
                    omKeyInfo.updateLocationInfoList(partLocationInfos);
                    omKeyInfo.setModificationTime(keyArgs.getModificationTime());
                    omKeyInfo.setDataSize(dataSize);
                }
                omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                unUsedParts = new ArrayList<OmKeyInfo>();
                for (Object partKeyInfo : partKeyInfoMap.entrySet()) {
                    if (partNumbers.contains(partKeyInfo.getKey())) continue;
                    unUsedParts.add(OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)((OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfo.getValue()).getPartKeyInfo()));
                }
            } else {
                throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName + "because of empty part list", OMException.ResultCodes.INVALID_REQUEST);
            }
            this.updateCache(omMetadataManager, ozoneKey, multipartKey, omKeyInfo, trxnLogIndex);
            omResponse.setCompleteMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartUploadCompleteResponse.newBuilder().setVolume(volumeName).setBucket(bucketName).setKey(keyName).setHash(DigestUtils.sha256Hex((String)keyName)));
            omClientResponse = new S3MultipartUploadCompleteResponse(omResponse.build(), multipartKey, omKeyInfo, unUsedParts);
            result = OMClientRequest.Result.SUCCESS;
        }
        catch (IOException ex) {
            block27: {
                try {
                    if (ex instanceof OMReplayException) {
                        result = OMClientRequest.Result.REPLAY;
                        omClientResponse = new S3MultipartUploadCompleteResponse(this.createReplayOMResponse(omResponse));
                        break block27;
                    }
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new S3MultipartUploadCompleteResponse(this.createErrorOMResponse(omResponse, exception));
                }
                catch (Throwable var37_40) {
                    this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
                    if (acquiredLock) {
                        omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    }
                    throw var37_40;
                }
            }
            this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
            if (acquiredLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            } else {
                ** GOTO lbl116
            }
        }
        this.addResponseToDoubleBuffer(trxnLogIndex, omClientResponse, omDoubleBufferHelper);
        if (acquiredLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        auditMap = this.buildKeyArgsAuditMap(keyArgs);
        auditMap.put("multipartList", partsList.toString());
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (1.$SwitchMap$org$apache$hadoop$ozone$om$request$OMClientRequest$Result[result.ordinal()]) {
            case 1: {
                S3MultipartUploadCompleteRequest.LOG.debug("MultipartUpload Complete request is successfull for Key: {} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case 2: {
                S3MultipartUploadCompleteRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)trxnLogIndex, (Object)multipartUploadCompleteRequest);
                break;
            }
            case 3: {
                ozoneManager.getMetrics().incNumCompleteMultipartUploadFails();
                S3MultipartUploadCompleteRequest.LOG.error("MultipartUpload Complete request failed for Key: {} in Volume/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName, exception});
            }
            default: {
                S3MultipartUploadCompleteRequest.LOG.error("Unrecognized Result for S3MultipartUploadCommitRequest: {}", (Object)multipartUploadCompleteRequest);
            }
        }
        return omClientResponse;
    }

    private void updateCache(OMMetadataManager omMetadataManager, String ozoneKey, String multipartKey, OmKeyInfo omKeyInfo, long transactionLogIndex) {
        omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)ozoneKey), new CacheValue(Optional.of((Object)omKeyInfo), transactionLogIndex));
        omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.absent(), transactionLogIndex));
        omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.absent(), transactionLogIndex));
    }
}

