/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.security;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.security.OMGetDelegationTokenResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMGetDelegationTokenRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMGetDelegationTokenRequest.class);

    public OMGetDelegationTokenRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        SecurityProtos.GetDelegationTokenRequestProto getDelegationTokenRequest = this.getOmRequest().getGetDelegationTokenRequest();
        Token<OzoneTokenIdentifier> token = ozoneManager.getDelegationToken(new Text(getDelegationTokenRequest.getRenewer()));
        OzoneManagerProtocolProtos.OMRequest.Builder omRequest = token != null ? OzoneManagerProtocolProtos.OMRequest.newBuilder().setUserInfo(this.getUserInfo()).setUpdateGetDelegationTokenRequest(OzoneManagerProtocolProtos.UpdateGetDelegationTokenRequest.newBuilder().setGetDelegationTokenResponse(OzoneManagerProtocolProtos.GetDelegationTokenResponseProto.newBuilder().setResponse(SecurityProtos.GetDelegationTokenResponseProto.newBuilder().setToken(OMPBHelper.convertToTokenProto(token)).build()).build())).setCmdType(this.getOmRequest().getCmdType()).setClientId(this.getOmRequest().getClientId()) : OzoneManagerProtocolProtos.OMRequest.newBuilder().setUserInfo(this.getUserInfo()).setUpdateGetDelegationTokenRequest(OzoneManagerProtocolProtos.UpdateGetDelegationTokenRequest.newBuilder().setGetDelegationTokenResponse(OzoneManagerProtocolProtos.GetDelegationTokenResponseProto.newBuilder())).setCmdType(this.getOmRequest().getCmdType()).setClientId(this.getOmRequest().getClientId());
        if (this.getOmRequest().hasTraceID()) {
            omRequest.setTraceID(this.getOmRequest().getTraceID());
        }
        return omRequest.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        OzoneManagerProtocolProtos.UpdateGetDelegationTokenRequest updateGetDelegationTokenRequest = this.getOmRequest().getUpdateGetDelegationTokenRequest();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.GetDelegationToken).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        OMGetDelegationTokenResponse omClientResponse = null;
        if (!updateGetDelegationTokenRequest.getGetDelegationTokenResponse().hasResponse()) {
            omClientResponse = new OMGetDelegationTokenResponse(null, -1L, omResponse.setGetDelegationTokenResponse(OzoneManagerProtocolProtos.GetDelegationTokenResponseProto.newBuilder()).build());
            omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
            return omClientResponse;
        }
        SecurityProtos.TokenProto tokenProto = updateGetDelegationTokenRequest.getGetDelegationTokenResponse().getResponse().getToken();
        Token ozoneTokenIdentifierToken = OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)tokenProto);
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        try {
            OzoneTokenIdentifier ozoneTokenIdentifier = OzoneTokenIdentifier.readProtoBuf((byte[])ozoneTokenIdentifierToken.getIdentifier());
            long renewTime = ozoneManager.getDelegationTokenMgr().updateToken(ozoneTokenIdentifierToken, ozoneTokenIdentifier);
            omMetadataManager.getDelegationTokenTable().addCacheEntry(new CacheKey((Object)ozoneTokenIdentifier), new CacheValue(Optional.of((Object)renewTime), transactionLogIndex));
            omClientResponse = new OMGetDelegationTokenResponse(ozoneTokenIdentifier, renewTime, omResponse.setGetDelegationTokenResponse(updateGetDelegationTokenRequest.getGetDelegationTokenResponse()).build());
        }
        catch (IOException ex) {
            LOG.error("Error in Updating DelegationToken {}", (Object)ozoneTokenIdentifierToken, (Object)ex);
            omClientResponse = new OMGetDelegationTokenResponse(null, -1L, this.createErrorOMResponse(omResponse, ex));
        }
        finally {
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated delegation token in-memory map: {}", (Object)ozoneTokenIdentifierToken);
        }
        return omClientResponse;
    }
}

