/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.util;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class ObjectParser {
    private String volume;
    private String bucket;
    private String key;

    public ObjectParser(String path, OzoneManagerProtocolProtos.OzoneObj.ObjectType objectType) throws OMException {
        Preconditions.checkNotNull((Object)path);
        String[] tokens = StringUtils.split((String)path, (String)"/", (int)3);
        if (objectType == OzoneManagerProtocolProtos.OzoneObj.ObjectType.VOLUME && tokens.length == 1) {
            this.volume = tokens[0];
        } else if (objectType == OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET && tokens.length == 2) {
            this.volume = tokens[0];
            this.bucket = tokens[1];
        } else if (objectType == OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY && tokens.length == 3) {
            this.volume = tokens[0];
            this.bucket = tokens[1];
            this.key = tokens[2];
        } else {
            throw new OMException("Illegal path " + path, OMException.ResultCodes.INVALID_PATH_IN_ACL_REQUEST);
        }
    }

    public String getVolume() {
        return this.volume;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }
}

