/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeCreateRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeCreateRequest.class);

    public OMVolumeCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.VolumeInfo volumeInfo = this.getOmRequest().getCreateVolumeRequest().getVolumeInfo();
        OzoneManagerProtocolProtos.VolumeInfo updatedVolumeInfo = volumeInfo.toBuilder().setCreationTime(Time.now()).build();
        return this.getOmRequest().toBuilder().setCreateVolumeRequest(OzoneManagerProtocolProtos.CreateVolumeRequest.newBuilder().setVolumeInfo(updatedVolumeInfo)).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        block19: {
            block20: {
                block21: {
                    createVolumeRequest = this.getOmRequest().getCreateVolumeRequest();
                    Preconditions.checkNotNull((Object)createVolumeRequest);
                    volumeInfo = createVolumeRequest.getVolumeInfo();
                    omMetrics = ozoneManager.getMetrics();
                    omMetrics.incNumVolumeCreates();
                    volume = volumeInfo.getVolume();
                    owner = volumeInfo.getOwnerName();
                    omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CreateVolume).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
                    omMetadataManager = ozoneManager.getMetadataManager();
                    acquiredVolumeLock = false;
                    acquiredUserLock = false;
                    exception = null;
                    omClientResponse = null;
                    omVolumeArgs = null;
                    auditMap = new HashMap<K, V>();
                    ozAdmins = ozoneManager.getOzoneAdmins();
                    omVolumeArgs = OmVolumeArgs.getFromProtobuf((OzoneManagerProtocolProtos.VolumeInfo)volumeInfo);
                    omVolumeArgs.setObjectID(OMFileRequest.getObjIDFromTxId(transactionLogIndex));
                    omVolumeArgs.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
                    auditMap = omVolumeArgs.toAuditMap();
                    if (ozoneManager.getAclsEnabled() && !ozAdmins.contains("*") && !ozAdmins.contains(this.getUserInfo().getUserName())) {
                        throw new OMException("Only admin users are authorized to create Ozone volumes. User: " + this.getUserInfo().getUserName(), OMException.ResultCodes.PERMISSION_DENIED);
                    }
                    acquiredVolumeLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                    acquiredUserLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                    dbVolumeKey = omMetadataManager.getVolumeKey(volume);
                    dbVolumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)dbVolumeKey);
                    volumeList = null;
                    if (dbVolumeArgs == null) {
                        dbUserKey = omMetadataManager.getUserKey(owner);
                        volumeList = (OzoneManagerProtocolProtos.UserVolumeInfo)omMetadataManager.getUserTable().get((Object)dbUserKey);
                        volumeList = this.addVolumeToOwnerList(volumeList, volume, owner, ozoneManager.getMaxUserVolumeCount(), transactionLogIndex);
                        this.createVolume(omMetadataManager, omVolumeArgs, volumeList, dbVolumeKey, dbUserKey, transactionLogIndex);
                        omResponse.setCreateVolumeResponse(OzoneManagerProtocolProtos.CreateVolumeResponse.newBuilder().build());
                        omClientResponse = new OMVolumeCreateResponse(omResponse.build(), omVolumeArgs, volumeList);
                        OMVolumeCreateRequest.LOG.debug("volume:{} successfully created", (Object)omVolumeArgs.getVolume());
                        break block19;
                    }
                    if (!this.isReplay(ozoneManager, (WithObjectID)dbVolumeArgs, transactionLogIndex)) break block20;
                    OMVolumeCreateRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)transactionLogIndex, (Object)createVolumeRequest);
                    var22_23 = new OMVolumeCreateResponse(this.createReplayOMResponse(omResponse));
                    if (omClientResponse != null) {
                        omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                    }
                    if (!acquiredUserLock) break block21;
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                }
                if (acquiredVolumeLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                }
                return var22_23;
            }
            try {
                OMVolumeCreateRequest.LOG.debug("volume:{} already exists", (Object)omVolumeArgs.getVolume());
                throw new OMException("Volume already exists", OMException.ResultCodes.VOLUME_ALREADY_EXISTS);
            }
            catch (IOException ex) {
                block22: {
                    try {
                        exception = ex;
                        omClientResponse = new OMVolumeCreateResponse(this.createErrorOMResponse(omResponse, exception));
                        if (omClientResponse != null) {
                            omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                        }
                        if (!acquiredUserLock) break block22;
                    }
                    catch (Throwable var23_24) {
                        if (omClientResponse != null) {
                            omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
                        }
                        if (acquiredUserLock) {
                            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                        }
                        if (acquiredVolumeLock) {
                            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                        }
                        throw var23_24;
                    }
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                }
                if (acquiredVolumeLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                } else {
                    ** GOTO lbl83
                }
            }
        }
        if (omClientResponse != null) {
            omClientResponse.setFlushFuture(ozoneManagerDoubleBufferHelper.add(omClientResponse, transactionLogIndex));
        }
        if (acquiredUserLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
        }
        if (acquiredVolumeLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.CREATE_VOLUME, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            OMVolumeCreateRequest.LOG.info("created volume:{} for user:{}", (Object)volume, (Object)owner);
            omMetrics.incNumVolumes();
        } else {
            OMVolumeCreateRequest.LOG.error("Volume creation failed for user:{} volume:{}", new Object[]{owner, volume, exception});
            omMetrics.incNumVolumeCreateFails();
        }
        return omClientResponse;
    }
}

