/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeSetOwnerResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeSetOwnerRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeSetOwnerRequest.class);

    public OMVolumeSetOwnerRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        block18: {
            setVolumePropertyRequest = this.getOmRequest().getSetVolumePropertyRequest();
            Preconditions.checkNotNull((Object)setVolumePropertyRequest);
            omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetVolumeProperty).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
            if (!setVolumePropertyRequest.hasOwnerName()) {
                omResponse.setStatus(OzoneManagerProtocolProtos.Status.INVALID_REQUEST).setSuccess(false);
                return new OMVolumeSetOwnerResponse(omResponse.build());
            }
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumVolumeUpdates();
            volume = setVolumePropertyRequest.getVolumeName();
            newOwner = setVolumePropertyRequest.getOwnerName();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            auditMap = this.buildVolumeAuditMap(volume);
            auditMap.put("owner", newOwner);
            acquiredUserLocks = false;
            acquiredVolumeLock = false;
            exception = null;
            omMetadataManager = ozoneManager.getMetadataManager();
            oldOwner = null;
            omClientResponse = null;
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, null, null);
            }
            maxUserVolumeCount = ozoneManager.getMaxUserVolumeCount();
            dbVolumeKey = omMetadataManager.getVolumeKey(volume);
            oldOwnerVolumeList = null;
            newOwnerVolumeList = null;
            omVolumeArgs = null;
            acquiredVolumeLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            omVolumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (omVolumeArgs == null) {
                OMVolumeSetOwnerRequest.LOG.debug("Changing volume ownership failed for user:{} volume:{}", (Object)newOwner, (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            if (!this.isReplay(ozoneManager, (WithObjectID)omVolumeArgs, transactionLogIndex)) break block18;
            OMVolumeSetOwnerRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)transactionLogIndex, (Object)setVolumePropertyRequest);
            var25_24 = new OMVolumeSetOwnerResponse(this.createReplayOMResponse(omResponse));
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredUserLocks) {
                omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
            }
            if (acquiredVolumeLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            }
            return var25_24;
        }
        try {
            oldOwner = omVolumeArgs.getOwnerName();
            acquiredUserLocks = omMetadataManager.getLock().acquireMultiUserLock(newOwner, oldOwner);
            oldOwnerVolumeList = (OzoneManagerProtocolProtos.UserVolumeInfo)omMetadataManager.getUserTable().get((Object)oldOwner);
            oldOwnerVolumeList = this.delVolumeFromOwnerList(oldOwnerVolumeList, volume, oldOwner, transactionLogIndex);
            newOwnerVolumeList = (OzoneManagerProtocolProtos.UserVolumeInfo)omMetadataManager.getUserTable().get((Object)newOwner);
            newOwnerVolumeList = this.addVolumeToOwnerList(newOwnerVolumeList, volume, newOwner, maxUserVolumeCount, transactionLogIndex);
            omVolumeArgs.setOwnerName(newOwner);
            omVolumeArgs.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
            omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getUserKey(newOwner)), new CacheValue(Optional.of((Object)newOwnerVolumeList), transactionLogIndex));
            omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getUserKey(oldOwner)), new CacheValue(Optional.of((Object)oldOwnerVolumeList), transactionLogIndex));
            omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), new CacheValue(Optional.of((Object)omVolumeArgs), transactionLogIndex));
            omResponse.setSetVolumePropertyResponse(OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder().build());
            omClientResponse = new OMVolumeSetOwnerResponse(omResponse.build(), oldOwner, oldOwnerVolumeList, newOwnerVolumeList, omVolumeArgs);
        }
        catch (IOException ex) {
            try {
                exception = ex;
                omClientResponse = new OMVolumeSetOwnerResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var26_25) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquiredUserLocks) {
                    omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
                }
                if (acquiredVolumeLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                }
                throw var26_25;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquiredUserLocks) {
                omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
            }
            if (acquiredVolumeLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            } else {
                ** GOTO lbl85
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (acquiredUserLocks) {
            omMetadataManager.getLock().releaseMultiUserLock(newOwner, oldOwner);
        }
        if (acquiredVolumeLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.SET_OWNER, auditMap, exception, userInfo));
        if (exception == null) {
            OMVolumeSetOwnerRequest.LOG.debug("Successfully changed Owner of Volume {} from {} -> {}", new Object[]{volume, oldOwner, newOwner});
        } else {
            OMVolumeSetOwnerRequest.LOG.error("Changing volume ownership failed for user:{} volume:{}", new Object[]{newOwner, volume, exception});
            omMetrics.incNumVolumeUpdateFails();
        }
        return omClientResponse;
    }
}

