/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerDoubleBufferHelper;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeSetQuotaResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeSetQuotaRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeSetQuotaRequest.class);

    public OMVolumeSetQuotaRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex, OzoneManagerDoubleBufferHelper ozoneManagerDoubleBufferHelper) {
        block14: {
            setVolumePropertyRequest = this.getOmRequest().getSetVolumePropertyRequest();
            Preconditions.checkNotNull((Object)setVolumePropertyRequest);
            omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetVolumeProperty).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
            if (!setVolumePropertyRequest.hasQuotaInBytes()) {
                omResponse.setStatus(OzoneManagerProtocolProtos.Status.INVALID_REQUEST).setSuccess(false);
                return new OMVolumeSetQuotaResponse(omResponse.build());
            }
            volume = setVolumePropertyRequest.getVolumeName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumVolumeUpdates();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            auditMap = this.buildVolumeAuditMap(volume);
            auditMap.put("quota", String.valueOf(setVolumePropertyRequest.getQuotaInBytes()));
            omMetadataManager = ozoneManager.getMetadataManager();
            exception = null;
            acquireVolumeLock = false;
            omClientResponse = null;
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volume, null, null);
            }
            omVolumeArgs = null;
            acquireVolumeLock = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            dbVolumeKey = omMetadataManager.getVolumeKey(volume);
            omVolumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (omVolumeArgs == null) {
                OMVolumeSetQuotaRequest.LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException(OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            if (!this.isReplay(ozoneManager, (WithObjectID)omVolumeArgs, transactionLogIndex)) break block14;
            OMVolumeSetQuotaRequest.LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)transactionLogIndex, (Object)setVolumePropertyRequest);
            var18_18 = new OMVolumeSetQuotaResponse(this.createReplayOMResponse(omResponse));
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquireVolumeLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            }
            return var18_18;
        }
        try {
            omVolumeArgs.setQuotaInBytes(setVolumePropertyRequest.getQuotaInBytes());
            omVolumeArgs.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
            omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), new CacheValue(Optional.of((Object)omVolumeArgs), transactionLogIndex));
            omResponse.setSetVolumePropertyResponse(OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder().build());
            omClientResponse = new OMVolumeSetQuotaResponse(omResponse.build(), omVolumeArgs);
        }
        catch (IOException ex) {
            try {
                exception = ex;
                omClientResponse = new OMVolumeSetQuotaResponse(this.createErrorOMResponse(omResponse, exception));
            }
            catch (Throwable var19_19) {
                this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
                if (acquireVolumeLock) {
                    omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                }
                throw var19_19;
            }
            this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
            if (acquireVolumeLock) {
                omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            } else {
                ** GOTO lbl63
            }
        }
        this.addResponseToDoubleBuffer(transactionLogIndex, omClientResponse, ozoneManagerDoubleBufferHelper);
        if (acquireVolumeLock) {
            omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.SET_QUOTA, auditMap, exception, userInfo));
        if (exception == null) {
            OMVolumeSetQuotaRequest.LOG.debug("Changing volume quota is successfully completed for volume: {} quota:{}", (Object)volume, (Object)setVolumePropertyRequest.getQuotaInBytes());
        } else {
            omMetrics.incNumVolumeUpdateFails();
            OMVolumeSetQuotaRequest.LOG.error("Changing volume quota failed for volume:{} quota:{}", new Object[]{volume, setVolumePropertyRequest.getQuotaInBytes(), exception});
        }
        return omClientResponse;
    }
}

