/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume.acl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.scm.storage.CheckedBiFunction;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeAclRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeAclOpResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeAddAclRequest
extends OMVolumeAclRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeAddAclRequest.class);
    private static CheckedBiFunction<List<OzoneAcl>, OmVolumeArgs, IOException> volumeAddAclOp = (acls, volArgs) -> volArgs.addAcl((OzoneAcl)acls.get(0));
    private List<OzoneAcl> ozoneAcls;
    private String volumeName;

    public OMVolumeAddAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, volumeAddAclOp);
        OzoneManagerProtocolProtos.AddAclRequest addAclRequest = this.getOmRequest().getAddAclRequest();
        Preconditions.checkNotNull((Object)addAclRequest);
        this.ozoneAcls = Lists.newArrayList((Object[])new OzoneAcl[]{OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)addAclRequest.getAcl())});
        this.volumeName = addAclRequest.getObj().getPath().substring(1);
    }

    @Override
    public List<OzoneAcl> getAcls() {
        return this.ozoneAcls;
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    private OzoneAcl getAcl() {
        return this.ozoneAcls.get(0);
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.AddAcl).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmVolumeArgs omVolumeArgs, boolean aclApplied) {
        omResponse.setAddAclResponse(OzoneManagerProtocolProtos.AddAclResponse.newBuilder().setResponse(aclApplied).build());
        return new OMVolumeAclOpResponse(omResponse.build(), omVolumeArgs);
    }

    @Override
    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, IOException ex) {
        return new OMVolumeAclOpResponse(this.createErrorOMResponse(omResponse, ex));
    }

    @Override
    void onComplete(OMClientRequest.Result result, IOException ex, long trxnLogIndex) {
        switch (result) {
            case SUCCESS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Add acl: {} to volume: {} success!", (Object)this.getAcl(), (Object)this.getVolumeName());
                break;
            }
            case REPLAY: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Replayed Transaction {} ignored. Request: {}", (Object)trxnLogIndex, (Object)this.getOmRequest());
                break;
            }
            case FAILURE: {
                LOG.error("Add acl {} to volume {} failed!", new Object[]{this.getAcl(), this.getVolumeName(), ex});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMVolumeAddAclRequest: {}", (Object)this.getOmRequest());
            }
        }
    }
}

