/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.bucket;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class OMBucketDeleteResponse
extends OMClientResponse {
    private String volumeName;
    private String bucketName;

    public OMBucketDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String volumeName, String bucketName) {
        super(omResponse);
        this.volumeName = volumeName;
        this.bucketName = bucketName;
    }

    public OMBucketDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String dbBucketKey = omMetadataManager.getBucketKey(this.volumeName, this.bucketName);
        omMetadataManager.getBucketTable().deleteWithBatch(batchOperation, (Object)dbBucketKey);
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }
}

