/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.file;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDirectoryCreateResponse
extends OMClientResponse {
    public static final Logger LOG = LoggerFactory.getLogger(OMDirectoryCreateResponse.class);
    private OmKeyInfo dirKeyInfo;
    private List<OmKeyInfo> parentKeyInfos;
    private boolean createPrefix;

    public OMDirectoryCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nullable OmKeyInfo dirKeyInfo, @Nullable List<OmKeyInfo> parentKeyInfos, boolean createPrefix) {
        super(omResponse);
        this.dirKeyInfo = dirKeyInfo;
        this.parentKeyInfos = parentKeyInfos;
        this.createPrefix = createPrefix;
    }

    public OMDirectoryCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.dirKeyInfo != null) {
            String dirKey = omMetadataManager.getOzoneKey(this.dirKeyInfo.getVolumeName(), this.dirKeyInfo.getBucketName(), this.dirKeyInfo.getKeyName());
            omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)dirKey, (Object)this.dirKeyInfo);
            if (this.createPrefix && this.parentKeyInfos != null) {
                for (OmKeyInfo parentKeyInfo : this.parentKeyInfos) {
                    String parentKey = omMetadataManager.getOzoneDirKey(parentKeyInfo.getVolumeName(), parentKeyInfo.getBucketName(), parentKeyInfo.getKeyName());
                    LOG.debug("putWithBatch parent : key {} info : {}", (Object)parentKey, (Object)parentKeyInfo);
                    omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)parentKey, (Object)parentKeyInfo);
                }
            }
        } else {
            LOG.debug("Response Status is OK, dirKeyInfo is null in OMDirectoryCreateResponse");
        }
    }
}

